%% This is an -*- erlang -*- file.
%% Copyright (C) 1990, Ellemtel Telecommunications Systems Laboratories
%% File    : erl_internal.erl
%% Author  : Robert Virding
%% Purpose : Define Erlang bifs, guard tests and other internal stuff.

%%% NOTE: The first part of erl_internal.erl has been copied 
%%% automatically from erl_internal.src. Don't edit erl_internal.erl.

-module(erl_internal).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/4').

-export([bif/2,guard_bif/2,type_test/2,builtins/0,obsolete/3]).
-export([arith_op/2,bool_op/2,comp_op/2,list_op/2,send_op/2,op_type/2]).

%% -type guard_bif(Name, Arity) -> bool()
%%	when Name = atom(), Arity = integer().
%%  Erlang builtin functions allowed in guards.

guard_bif(abs, 1) -> true;
guard_bif(float, 1) -> true;
guard_bif(trunc, 1) -> true;
guard_bif(round, 1) -> true;
guard_bif(length, 1) -> true;
guard_bif(hd, 1) -> true;
guard_bif(tl, 1) -> true;
guard_bif(size, 1) -> true;
guard_bif(element, 2) -> true;
guard_bif(self, 0) -> true;
guard_bif(node,0) -> true;
guard_bif(node,1) -> true;
guard_bif(N, A) -> false.

%% -type type_test(Name, Arity) -> bool()
%%	when Name = atom(), Arity = integer().
%%  Erlang type tests.

type_test(integer, 1) -> true;
type_test(float, 1) -> true;
type_test(number, 1) -> true;
type_test(atom, 1) -> true;
type_test(constant, 1) -> true;
type_test(list, 1) -> true;
type_test(tuple, 1) -> true;
type_test(pid, 1) -> true;
type_test(reference, 1) -> true;
type_test(port, 1) -> true;
type_test(binary, 1) -> true;
type_test(record, 2) -> true;
type_test(function, 1) -> true;
type_test(N, A) -> false.

%% -type arith_op(Op, Arity) -> bool()
%%	when Op = atom(), Arity = integer().

arith_op('+', 1) -> true;
arith_op('-', 1) -> true;
arith_op('*', 2) -> true;
arith_op('/', 2) -> true;
arith_op('+', 2) -> true;
arith_op('-', 2) -> true;
arith_op('bnot', 1) -> true;
arith_op('div', 2) -> true;
arith_op('rem', 2) -> true;
arith_op('band', 2) -> true;
arith_op('bor', 2) -> true;
arith_op('bxor', 2) -> true;
arith_op('bsl', 2) -> true;
arith_op('bsr', 2) -> true;
arith_op(N, A) -> false.

%% -type bool_op(Op, Arity) -> bool()
%%	when Op = atom(), Arity = integer().

bool_op('not', 1) -> true;
bool_op('and', 2) -> true;
bool_op('or', 2) -> true;
bool_op('xor', 2) -> true;
bool_op(N, A) -> false.

%% -type comp_op(Op, Arity) -> bool()
%%	when Op = atom(), Arity = integer().

comp_op('==', 2) -> true;
comp_op('/=', 2) -> true;
comp_op('=<', 2) -> true;
comp_op('<', 2) -> true;
comp_op('>=', 2) -> true;
comp_op('>', 2) -> true;
comp_op('=:=', 2) -> true;
comp_op('=/=', 2) -> true;
comp_op(N, A) -> false.

%% -type list_op(Op, Arity) -> bool()
%%	when Op = atom(), Arity = integer().

list_op('++', 2) -> true;
list_op('--', 2) -> true;
list_op(_, _) -> false.

%% -type send_op(Op, Arity) -> bool()
%%	when Op = atom(), Arity = integer().

send_op('!', 2) -> true;
send_op(_, _) -> false.

%% -type op_type(Op, Arity) -> arith | bool | comp | list | send
%%	when Op = atom(), Arity = integer().

op_type('+', 1) -> arith;
op_type('-', 1) -> arith;
op_type('*', 2) -> arith;
op_type('/', 2) -> arith;
op_type('+', 2) -> arith;
op_type('-', 2) -> arith;
op_type('bnot', 1) -> arith;
op_type('div', 2) -> arith;
op_type('rem', 2) -> arith;
op_type('band', 2) -> arith;
op_type('bor', 2) -> arith;
op_type('bxor', 2) -> arith;
op_type('bsl', 2) -> arith;
op_type('bsr', 2) -> arith;
op_type('not', 1) -> bool;
op_type('and', 2) -> bool;
op_type('or', 2) -> bool;
op_type('xor', 2) -> bool;
op_type('==', 2) -> comp;
op_type('/=', 2) -> comp;
op_type('=<', 2) -> comp;
op_type('<', 2) -> comp;
op_type('>=', 2) -> comp;
op_type('>', 2) -> comp;
op_type('=:=', 2) -> comp;
op_type('=/=', 2) -> comp;
op_type('++', 2) -> list;
op_type('--', 2) -> list;
op_type('!', 2) -> send.

bif(Name, Arity) ->
    case bif_type(Name, Arity) of
	true ->
	    true;
	_ ->
	    false
    end.

obsolete(init, get_flag, 1) ->
    {true, {init, get_argument, 1}};
obsolete(init, get_flags, 0) ->
    {true, {init, get_arguments, 0}};
obsolete(unix, cmd, 1) ->
    {true, {os, cmd, 1}};
obsolete(_, _, _) ->
    false.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% The text below has been automatically generated by erl_mk_internal.

bif_type(append, 2) -> false;
bif_type(append_element, 2) -> false;
bif_type(binary_to_dist, 1) -> false;
bif_type(cancel_timer, 1) -> false;
bif_type(db_all_tables, 0) -> false;
bif_type(db_create, 2) -> false;
bif_type(db_erase, 1) -> false;
bif_type(db_erase, 2) -> false;
bif_type(db_first, 1) -> false;
bif_type(db_fixtable, 2) -> false;
bif_type(db_get, 2) -> false;
bif_type(db_get_element, 3) -> false;
bif_type(db_info, 2) -> false;
bif_type(db_match, 2) -> false;
bif_type(db_match_erase, 2) -> false;
bif_type(db_match_object, 3) -> false;
bif_type(db_next_key, 2) -> false;
bif_type(db_put, 2) -> false;
bif_type(db_slot, 2) -> false;
bif_type(db_update_counter, 3) -> false;
bif_type(display, 1) -> false;
bif_type(dist_exit, 3) -> false;
bif_type(dist_link, 2) -> false;
bif_type(dist_to_binary, 1) -> false;
bif_type(dist_unlink, 2) -> false;
bif_type(float_to_words, 1) -> false;
bif_type(function_exported, 3) -> false;
bif_type(get_os_pid, 0) -> false;
bif_type(hash, 2) -> false;
bif_type(info, 1) -> false;
bif_type(loaded, 0) -> false;
bif_type(localtime, 0) -> false;
bif_type(localtime_to_universaltime, 1) -> false;
bif_type(m_acos, 1) -> false;
bif_type(m_acosh, 1) -> false;
bif_type(m_asin, 1) -> false;
bif_type(m_asinh, 1) -> false;
bif_type(m_atan, 1) -> false;
bif_type(m_atan2, 2) -> false;
bif_type(m_atanh, 1) -> false;
bif_type(m_cos, 1) -> false;
bif_type(m_cosh, 1) -> false;
bif_type(m_erf, 1) -> false;
bif_type(m_erfc, 1) -> false;
bif_type(m_exp, 1) -> false;
bif_type(m_log, 1) -> false;
bif_type(m_log10, 1) -> false;
bif_type(m_pow, 2) -> false;
bif_type(m_sin, 1) -> false;
bif_type(m_sinh, 1) -> false;
bif_type(m_sqrt, 1) -> false;
bif_type(m_tan, 1) -> false;
bif_type(m_tanh, 1) -> false;
bif_type(make_tuple, 2) -> false;
bif_type(member, 2) -> false;
bif_type(old_binary_to_term, 1) -> false;
bif_type(open_port_prim, 2) -> false;
bif_type(os_put_env, 1) -> false;
bif_type(port_info, 1) -> false;
bif_type(port_info, 2) -> false;
bif_type(ports, 0) -> false;
bif_type(reverse, 2) -> false;
bif_type(send, 2) -> false;
bif_type(send_after, 3) -> false;
bif_type(seq_trace, 2) -> false;
bif_type(seq_trace_info, 1) -> false;
bif_type(seq_trace_print, 2) -> false;
bif_type(setnode, 2) -> false;
bif_type(setnode, 3) -> false;
bif_type(spawn, 2) -> false;
bif_type(spawn_link, 2) -> false;
bif_type(spawn_opt, 2) -> false;
bif_type(start_timer, 3) -> false;
bif_type(subtract, 2) -> false;
bif_type(system_flag, 2) -> false;
bif_type(system_info, 1) -> false;
bif_type(type, 2) -> false;
bif_type(universaltime, 0) -> false;
bif_type(universaltime_to_localtime, 1) -> false;
bif_type(abs, 1) -> true;
bif_type(apply, 2) -> true;
bif_type(apply, 3) -> true;
bif_type(atom_to_list, 1) -> true;
bif_type(binary_to_list, 1) -> true;
bif_type(binary_to_list, 3) -> true;
bif_type(binary_to_term, 1) -> true;
bif_type(check_process_code, 2) -> true;
bif_type(concat_binary, 1) -> true;
bif_type(date, 0) -> true;
bif_type(delete_module, 1) -> true;
bif_type(disconnect_node, 1) -> true;
bif_type(element, 2) -> true;
bif_type(erase, 0) -> true;
bif_type(erase, 1) -> true;
bif_type(exit, 1) -> true;
bif_type(exit, 2) -> true;
bif_type(float, 1) -> true;
bif_type(float_to_list, 1) -> true;
bif_type(garbage_collect, 0) -> true;
bif_type(garbage_collect, 1) -> true;
bif_type(get, 0) -> true;
bif_type(get, 1) -> true;
bif_type(get_keys, 1) -> true;
bif_type(group_leader, 0) -> true;
bif_type(group_leader, 2) -> true;
bif_type(halt, 0) -> true;
bif_type(halt, 1) -> true;
bif_type(hd, 1) -> true;
bif_type(integer_to_list, 1) -> true;
bif_type(is_alive, 0) -> true;
bif_type(length, 1) -> true;
bif_type(link, 1) -> true;
bif_type(list_to_atom, 1) -> true;
bif_type(list_to_binary, 1) -> true;
bif_type(list_to_float, 1) -> true;
bif_type(list_to_integer, 1) -> true;
bif_type(list_to_pid, 1) -> true;
bif_type(list_to_tuple, 1) -> true;
bif_type(load_module, 2) -> true;
bif_type(make_ref, 0) -> true;
bif_type(module_loaded, 1) -> true;
bif_type(monitor_node, 2) -> true;
bif_type(node, 0) -> true;
bif_type(node, 1) -> true;
bif_type(nodes, 0) -> true;
bif_type(now, 0) -> true;
bif_type(open_port, 2) -> true;
bif_type(pid_to_list, 1) -> true;
bif_type(port_close, 1) -> true;
bif_type(port_command, 2) -> true;
bif_type(port_connect, 2) -> true;
bif_type(port_control, 3) -> true;
bif_type(pre_loaded, 0) -> true;
bif_type(process_flag, 2) -> true;
bif_type(process_info, 1) -> true;
bif_type(process_info, 2) -> true;
bif_type(processes, 0) -> true;
bif_type(purge_module, 1) -> true;
bif_type(put, 2) -> true;
bif_type(register, 2) -> true;
bif_type(registered, 0) -> true;
bif_type(round, 1) -> true;
bif_type(self, 0) -> true;
bif_type(setelement, 3) -> true;
bif_type(size, 1) -> true;
bif_type(spawn, 3) -> true;
bif_type(spawn, 4) -> true;
bif_type(spawn_link, 3) -> true;
bif_type(spawn_link, 4) -> true;
bif_type(spawn_opt, 4) -> true;
bif_type(split_binary, 2) -> true;
bif_type(statistics, 1) -> true;
bif_type(term_to_binary, 1) -> true;
bif_type(throw, 1) -> true;
bif_type(time, 0) -> true;
bif_type(tl, 1) -> true;
bif_type(trace, 3) -> true;
bif_type(trunc, 1) -> true;
bif_type(tuple_to_list, 1) -> true;
bif_type(unlink, 1) -> true;
bif_type(unregister, 1) -> true;
bif_type(whereis, 1) -> true;
bif_type(_, _) -> undefined.


builtins() -> [
   {abs,1},
   {apply,2},
   {apply,3},
   {atom_to_list,1},
   {binary_to_list,1},
   {binary_to_list,3},
   {binary_to_term,1},
   {check_process_code,2},
   {concat_binary,1},
   {date,0},
   {delete_module,1},
   {disconnect_node,1},
   {element,2},
   {erase,0},
   {erase,1},
   {exit,1},
   {exit,2},
   {float,1},
   {float_to_list,1},
   {garbage_collect,0},
   {garbage_collect,1},
   {get,0},
   {get,1},
   {get_keys,1},
   {group_leader,0},
   {group_leader,2},
   {halt,0},
   {halt,1},
   {hd,1},
   {integer_to_list,1},
   {is_alive,0},
   {length,1},
   {link,1},
   {list_to_atom,1},
   {list_to_binary,1},
   {list_to_float,1},
   {list_to_integer,1},
   {list_to_pid,1},
   {list_to_tuple,1},
   {load_module,2},
   {make_ref,0},
   {module_loaded,1},
   {monitor_node,2},
   {node,0},
   {node,1},
   {nodes,0},
   {now,0},
   {open_port,2},
   {pid_to_list,1},
   {port_close,1},
   {port_command,2},
   {port_connect,2},
   {port_control,3},
   {pre_loaded,0},
   {process_flag,2},
   {process_info,1},
   {process_info,2},
   {processes,0},
   {purge_module,1},
   {put,2},
   {register,2},
   {registered,0},
   {round,1},
   {self,0},
   {setelement,3},
   {size,1},
   {spawn,3},
   {spawn,4},
   {spawn_link,3},
   {spawn_link,4},
   {spawn_opt,4},
   {split_binary,2},
   {statistics,1},
   {term_to_binary,1},
   {throw,1},
   {time,0},
   {tl,1},
   {trace,3},
   {trunc,1},
   {tuple_to_list,1},
   {unlink,1},
   {unregister,1},
   {whereis,1}].
