%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%% Copyright (C) 1996, Ericsson Computer Science Laboratory
%% File    : jam_listing.erl
%% Author  : Joe Armstrong
%% Purpose : List JAM assembly code on stream

-module(jam_listing).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').

-export([module/2]).
-import(lists, [foreach/2]).


module(Stream, CodeList) ->
    foreach(
      fun ({code,Mod,Func,Arity,Type,Opcodes}) ->
	      io:format(Stream, "~w:~w/~w ~w\n", [Mod, Func, Arity, Type]),
	      foreach( fun(Op) ->
			       io:format(Stream, "    ~p\n", [Op])
		       end,
		      Opcodes),
	      io:format(Stream,"\n",[])
      end,
      CodeList).
