%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%% Copyright (C) 1997, Ellemtel Telecommunications Systems Laboratories
%%
%% File    : beam_listing.erl
%% Author  : Tony Rogvall & Bogumil Hausman
%% Purpose : List Beam assembly on stream
%%

-module(beam_listing).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').

-export([module/2]).

-import(lists, [foreach/2]).

module(Stream, {Mod, Exp, Code, NumLabels}) ->
    io:format(Stream, "-module(~s).  %% version = ~w\n", 
	      [Mod, beam_opcodes:format_number()]),
    io:format(Stream, "\n-exports(~p).\n", [Exp]),
    io:format(Stream, "\n-labels(~p).\n", [NumLabels]),
    foreach(
      fun ({function, Name, Arity, Entry, Asm}) ->
	      io:format(Stream, "\n\n-function(~w, ~w, ~w).\n",
			[Name, Arity, Entry]),
	      foreach(fun(Op) -> print_op(Stream, Op) end, Asm) end,
      Code).

print_op(Stream, Label) when element(1, Label) == label ->
    io:format(Stream, "  ~p\n", [Label]);
print_op(Stream, Op) ->
    io:format(Stream, "    ~p\n", [Op]).

