/* 
   scrollbar.h [2000-11-10]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SCROLLBAR_H
#define SCROLLBAR_H

#include <SDL.h>

#define VERTICAL 0
#define HORIZONTAL 1

#define SCROLL_UP			1
#define SCROLL_DOWN			2
#define SCROLL_LEFT			3
#define SCROLL_RIGHT		4
#define SCROLL_PAGE_UP		5
#define SCROLL_PAGE_DOWN	6
#define SCROLL_PAGE_LEFT	7
#define SCROLL_PAGE_RIGHT	8
#define SCROLL_VERTICAL		9
#define SCROLL_HORIZONTAL	10

typedef struct _ScrollBar {
	SDL_Rect rect;
	SDL_Rect sliderarea;
	SDL_Rect slider;
	int orientation;
	int linestep;
	int pagestep;
	int minvalue;
	int maxvalue;
	int curvalue;
	int isvisible;
}SCROLLBAR;

extern SCROLLBAR *ScrollBar(Sint16 x, Sint16 y, Uint16 size, int orientation);
extern void drawScrollBar(SCROLLBAR *s, SDL_Surface *surface);
extern void setScrollBarSize(SCROLLBAR *s, Uint16 size, int visible);
extern void setScrollBarRange(SCROLLBAR *s, int linestep, int pagestep, int minvalue, int maxvalue, int value);
extern void updateScrollBarSlider(SCROLLBAR *s, SDL_Surface *surface, int value);
extern void deleteScrollBar(SCROLLBAR *s);
extern int getValueFromSlider(SCROLLBAR *s, SDL_Surface *surface, Sint16 x, Sint16 y);
extern int handleScrollBarEvent(SDL_Event *event, SCROLLBAR *s, SDL_Surface *surface);

#endif
