/* 
   msgbox.c [2000-11-20]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdlib.h>
#include <string.h>
#include "msgbox.h"
#include "button.h"
#include "listbox.h"
#include "drawutil.h"

#define OK		1

struct _MsgBox {
	SDL_Rect rect;
	BUTTON *ok;
	LISTBOX *lb;
};

void parseMessage(MSGBOX *msg, char *text)
{
	char *tmp;
	char *out = text;
	int done = 0;
	
	while(!done) {
		if((tmp = strchr(out, '\n')) != NULL) {
			*tmp = '\0';
			addListBoxItem(msg->lb, out, NULL);
			//printf("parse %s\n",out);
			++tmp;
			out = tmp;
		} else {
			done = 1;
		}
	}
}

void showMsg(MSGBOX *msg, SDL_Surface *surface)
{
	int done = 0;

	SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
	while ( ! done ) {
		SDL_Event event;
		SDL_WaitEvent(&event);
		if (!handleListBoxEvent(&event, msg->lb, surface)) {
			switch (event.type) {
				case SDL_KEYDOWN:
					if (event.key.keysym.sym == SDLK_ESCAPE) {
						done = 1;
					} else if (event.key.keysym.sym == SDLK_RETURN) {
						done = 1;
					}
					break;
				case SDL_MOUSEBUTTONUP:
				case SDL_MOUSEBUTTONDOWN:
					if ((event.button.state == SDL_PRESSED) && (event.button.button == SDL_BUTTON_LEFT)) {
						if (isButtonPressed(msg->ok, event.button.x, event.button.y)) {
						}
					} else if ((event.button.state == SDL_RELEASED) && (event.button.button == SDL_BUTTON_LEFT)) {
						if (isButtonReleased(msg->ok, event.button.x, event.button.y)) {
							done = 1;
						}
					}
					drawButton(surface, msg->ok);
					SDL_UpdateRects(surface, 1, &msg->rect);
					break;
				default:
					break;
			}
		}
	}
	SDL_EnableKeyRepeat(0, SDL_DEFAULT_REPEAT_INTERVAL);
}

void messageBox(SDL_Surface *surface, char *text)
{
	MSGBOX m;
	SDL_Rect button;
	SDL_Surface *backingstore = NULL;
	int margin = 4;

	m.rect.w = 300;
	m.rect.h = 300;
	if (m.rect.w > surface->w)
		m.rect.w = surface->w;
	if (m.rect.h > surface->h)
		m.rect.h = surface->h;

	m.rect.x = (surface->w - m.rect.w) / 2;
	m.rect.y = (surface->h - m.rect.h) / 2;

	backingstore = SDL_CreateRGBSurface(SDL_SWSURFACE, m.rect.w, m.rect.h,
								surface->format->BitsPerPixel,
								surface->format->Rmask, surface->format->Gmask,
								surface->format->Bmask, surface->format->Amask);

	if (backingstore)
		SDL_BlitSurface(surface, &m.rect, backingstore, NULL);


	button.w = 50;
	button.h = 30;
	button.x = (m.rect.w - 20 - button.w) / 2 + m.rect.x;
	button.y = m.rect.y + m.rect.h -1 - 40;
	
	m.ok = Button(&button, OK);
	setButtonText(m.ok, "OK");

	m.lb = ListBox(m.rect.x + 10, m.rect.y + 10,
			m.rect.w - 20, button.y - (m.rect.y + 10), margin, 0);

	parseMessage(&m, text);

	initListBox(m.lb, surface);

	setTransparent(1);
	drawRaisedWin(surface, &m.rect, light_color, shadow_color, back_color);
	drawListBox(m.lb, surface);
	drawButton(surface, m.ok);
	SDL_UpdateRects(surface, 1, &m.rect);

	showMsg(&m, surface);

	free(m.ok);
	deleteListBox(m.lb);
	if (backingstore) {
		SDL_BlitSurface(backingstore, NULL, surface, &m.rect);
		SDL_UpdateRects(surface, 1, &m.rect);
		SDL_FreeSurface(backingstore);
		backingstore = NULL;
	}
}
