/* 
   drawutil.h [2000-11-2]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef DRAWUTIL_H
#define DRAWUTIL_H

#include <SDL.h>
#include "config.h"

Uint32 back_color;
Uint32 light_color;
Uint32 shadow_color;

extern int drawLine(SDL_Surface *surface, Sint16 x, Sint16 y, Uint16 w, Uint16 h, Uint32 color);
extern int drawRaisedWin(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor);
extern int drawSunkenWin(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor);
extern int drawUpArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor);
extern int drawDownArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor);
extern int drawLeftArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor);
extern int drawRightArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor);
extern int charWidth();
extern int charHeight();
extern void loadFont();
extern void deleteFont();
extern void setTransparent(int t);
extern void drawText(SDL_Surface *surface, Sint16 x, Sint16 y, char *text);

#endif
