/* 
   drawutil.c [2000-10-29]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <string.h>
#include "drawutil.h"

int charwidth;
int charheight;

SDL_Surface *font = NULL;

void loadFont()
{
	char bmpfile[256];

	if (font != NULL)
		return;

	strcpy(bmpfile, BMPDIR);
	strcat(bmpfile, "/font.bmp");
	font = SDL_LoadBMP(bmpfile);
	//printf("LoadFont\n");
	if (font != NULL) {
		charwidth = font->w / 16;
		charheight = font->h / 16;
	} else {
		charwidth = 0;
		charheight = 0;
	}
}

void deleteFont()
{
	if (!font)
		return;

	SDL_FreeSurface(font);
	font = NULL;
	charwidth = 0;
	charheight = 0;
}

int charWidth()
{
	if (!font)
		return 0;

	return charwidth;
}

int charHeight()
{
	if (!font)
		return 0;

	return charheight;
}

void setTransparent(int t)
{
	if (!font)
		return;

	if (t)
		SDL_SetColorKey(font, SDL_SRCCOLORKEY, 1);
	else
		SDL_SetColorKey(font, 0, 0);
}

void drawText(SDL_Surface *surface, Sint16 x, Sint16 y, char *text)
{
	int i;
	int textlen;
	Uint8 ch;
	SDL_Rect src;
	SDL_Rect dst;
	
	if (font == NULL)
		return;

	src.w = charwidth;
	src.h = charheight;
	dst.y = y;
	dst.w = charwidth;
	dst.h = charheight;
	
	textlen = strlen(text);
	
	for ( i = 0; i < textlen; i++) {
		ch = text[i];
		src.x = (ch % 16) * charwidth;
		src.y = (ch / 16) * charheight;
		dst.x = x + (i * charwidth);
		if (dst.x >= 0)
			SDL_BlitSurface(font, &src, surface, &dst);
	}
}

int drawLine(SDL_Surface *surface, Sint16 x, Sint16 y, Uint16 w, Uint16 h, Uint32 color)
{
	int error = 0;
	SDL_Rect r;
	r.x = x;
	r.y = y;
	r.w = w;
	r.h = h;
	
	error = SDL_FillRect(surface,&r, color);
	
	return error;
}

int drawRaisedWin(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor)
{
	int error = 0;
	
    error = SDL_FillRect(surface,r,backcolor);
	// Top
	error |= drawLine(surface, r->x, r->y, r->w, 2, lightcolor);
	// Bottom
	error |= drawLine(surface, r->x, r->y + r->h - 2, r->w, 2, shadowcolor);
	// Left 1
	error |= drawLine(surface, r->x, r->y, 1, r->h, lightcolor);
	// Left 2
	error |= drawLine(surface, r->x + 1, r->y, 1, r->h - 1, lightcolor);
	// Right 1
	error |= drawLine(surface, r->x + r->w - 1, r->y + 1, 1, r->h - 1, shadowcolor);
	// Right 2
	error |= drawLine(surface, r->x + r->w - 2, r->y + 2, 1, r->h - 2, shadowcolor);
	
	return error;
}

int drawSunkenWin(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor)
{
	int error = 0;
	
    error = SDL_FillRect(surface,r,backcolor);
	// Top
	error |= drawLine(surface, r->x, r->y, r->w, 2, shadowcolor);
	// Bottom
	error |= drawLine(surface, r->x, r->y + r->h - 2, r->w, 2, lightcolor);
	// Left 1
	error |= drawLine(surface, r->x, r->y, 1, r->h, shadowcolor);
	// Left 2
	error |= drawLine(surface, r->x + 1, r->y, 1, r->h - 1, shadowcolor);
	// Right 1
	error |= drawLine(surface, r->x + r->w - 1, r->y + 1, 1, r->h - 1, lightcolor);
	// Right 2
	error |= drawLine(surface, r->x + r->w - 2, r->y + 2, 1, r->h - 2, lightcolor);
	
	return error;
}

int drawUpArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor)
{
	int y = r->y;
	int x = r->w / 2 + r->x;

	drawLine(surface, x, y, 1, 1, lightcolor);
	y += 1;
	while (y < (r->y + r->h - 2)) {
		drawLine(surface, x, y, 2, 2, shadowcolor);
		x++;
		y += 2;
	}
	drawLine(surface, r->x, y, r->w, 2, shadowcolor);
	
	y = r->y + 1;
	x = r->w / 2 + r->x - 1;
	while (y < (r->y + r->h - 2)) {
		drawLine(surface, x, y, 2, 2, lightcolor);
		x--;
		y += 2;
	}
	drawLine(surface, x, y, 2, 1, lightcolor);
	drawLine(surface, x, y + 1, 1, 1, lightcolor);

	return 1;
}

int drawDownArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor)
{
	int y = r->y + r->h;
	int x = r->w / 2 + r->x;

	drawLine(surface, x, y, 1, 1, shadowcolor);
	y -= 2;
	x--;
	while (y > (r->y + 2)) {
		drawLine(surface, x, y, 2, 2, lightcolor);
		x--;
		y -= 2;
	}
	drawLine(surface, x, y, r->w, 2, lightcolor);
	
	y = r->y + r->h - 2;
	x = r->w / 2 + r->x;
	while (y > (r->y + 2)) {
		drawLine(surface, x, y, 2, 2, shadowcolor);
		x++;
		y -= 2;
	}
	drawLine(surface, x, y + 1, 2, 1, shadowcolor);

	return 1;
}

int drawLeftArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor)
{
	int x = r->x + 1;
	int y = r->h / 2 + r->y + 1;

	while (y < (r->y + r->h - 1)) {
		drawLine(surface, x, y, 4, 1, shadowcolor);
		x += 2;
		y++;
	}
	drawLine(surface, x, r->y, 2, r->h, shadowcolor);

	x = r->x;
	y = r->h / 2 + r->y;
	drawLine(surface, x, y, 3, 1, lightcolor);
	x++;
	y--;
	while (y > (r->y + 1)) {
		drawLine(surface, x, y, 4, 1, lightcolor);
		x +=2;
		y--;
	}
	drawLine(surface, x, y, 3, 1, lightcolor);
	drawLine(surface, x + 2, y - 1, 2, 1, lightcolor);

	return 1;
}

int drawRightArrow(SDL_Surface *surface, SDL_Rect *r, Uint32 lightcolor, Uint32 shadowcolor, Uint32 backcolor)
{
	int x = r->x + r->w + 1;
	int y = r->h / 2 + r->y;

	x -= 3;
	drawLine(surface, x, y, 3, 1, shadowcolor);
	x -= 2;
	y++;
	while (y < (r->y + r->h -1)) {
		drawLine(surface, x, y, 4, 1, shadowcolor);
		x -= 2;
		y++;
	}
	drawLine(surface, r->x + 1, y, 2, 1, shadowcolor);

	x = r->x + r->w + 1;
	y = r->h / 2 + r->y;
	x -= 5;
	y--;
	while (y > r->y) {
		drawLine(surface, x, y, 4, 1, lightcolor);
		x -=2;
		y--;
	}
	drawLine(surface, r->x + 1, r->y, 1, r->h, lightcolor);
	drawLine(surface, r->x + 2, r->y, 1, r->h - 2, lightcolor);

	return 1;
}
