/* 
   button.h [2000-10-29]
   (c) 2000 by Dieter Mittelmaier <dieter.mittelmaier@freenet.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef BUTTON_H
#define BUTTON_H

#include <SDL.h>

#define BUTTON_UP		0
#define BUTTON_DOWN		1

struct _Button;
typedef struct _Button BUTTON;

extern BUTTON *Button(SDL_Rect *r, int type);
extern void setButtonText(BUTTON * b, char *text);
extern void setButtonImages(BUTTON * b, char *image1, char *image2);
extern void setToggleButton(BUTTON *b, int on, int toggled);
extern void setCheckButton(BUTTON *b, int checked);
extern int drawButton(SDL_Surface *surface, BUTTON * b);
extern int isButtonPressed(BUTTON *b, Sint16 x, Sint16 y);
extern int isButtonReleased(BUTTON *b, Sint16 x, Sint16 y);
extern int ButtonType(BUTTON *b);
extern int isButtonChecked(BUTTON *b);

#endif
