//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#ifndef PX_TOOLS_HH
#define PX_TOOLS_HH

namespace px
{
    class Nocopy {
        Nocopy(const Nocopy&);
        Nocopy& operator=(const Nocopy&);
      public:
        Nocopy() {}
    };
}

//----------------------------------------
// Callbacks
//----------------------------------------
namespace px
{
    class Callback {
    public:
        virtual ~Callback() {}
        virtual void operator() () = 0;
    };

    template <class T>
    class MethodCallback : public Callback {
    public:
        typedef void (T::* Func)();
        MethodCallback(T* o, Func f) : obj(o), func(f) {}
        void operator() () { obj->*func(); }
    private:
        T *obj;
        Func func;
    };

    class FunctionCallback : public Callback {
    public:
        typedef void (*Func)();
        FunctionCallback(Func f) : func(f) {}
        void operator() () { func(); }
    private:
        Func func;
    };

    inline FunctionCallback
    make_callback(void (*func)()) 
    {
        return FunctionCallback(func);
    }

    template <class T>
    MethodCallback<T> make_callback(void (T::* f)())
    {
        return MethodCallback<T>(f);
    }
}

namespace px
{
// This handle class comes (almost verbatim) from TC++PL.
    template <class X> class Handle {
        X *rep;
        int *cnt;
    public:
        X *operator->() { return rep; }
        X *get() { return rep; }

        Handle() : rep(0), cnt(new int(1)) {}
        Handle(X *p) : rep(p), cnt(new int(1)) {}
        Handle(const Handle<X>& a) : rep(a.rep), cnt(a.cnt) {
            (*cnt)++;
        }
        Handle<X> &operator=(const Handle<X> &a) {
            if (rep == a.rep) return *this;
            if (--(*cnt) == 0) {
                delete rep;
                delete cnt;
            }
            rep = a.rep;
            cnt = a.cnt;
            (*cnt)++;
            return *this;
        }
        ~Handle() {
            if (--(*cnt) == 0) {
                delete rep;
                delete cnt;
            }
        }
    };

//     template <>
//     class hash<string> {
//         hash<const char *> hasher;
//     public:
//         size_t operator() (const string &s) const {
//             return hasher(s.c_str());
//         }
//     };

    template <class Iter> 
    Iter next(const Iter i) {
        Iter j=i;
        return ++j;
    }
    template <class Iter> 
    Iter prev(const Iter i) {
        Iter j=i;
        return --j;
    }


    template <class Exc> void
    Assert(bool cond) 
    {
        if (!cond)
            throw Exc();
    }

    template <class For> void
    delete_sequence(For begin, For end) 
    {
        while (begin != end) 
            delete *begin++;
    }

    template <class For> void 
    delete_map(For begin, For end) 
    {
        while (begin != end) 
        {
            delete begin->second;
            ++begin;
        }
    }

    template <class T> const T &
    Max(const T &a, const T &b)
    {
        return (a > b) ? a : b;
    }

    template <class T> const T &
    Min(const T &a, const T &b)
    {
        return (a < b) ? a : b;
    }
}

#endif
