//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#include "font.hh"
#include "geom.hh"
#include "tools.hh"
#include <vector>
#include <string>
#include <stdio.h>

using namespace px;
using namespace std;

//
// Bitmap fonts
//

namespace
{
    class InvalidFont {};
    
    class BitmapFont : public Font {
	vector<Rect>	char_rects;
	vector<int>	advance;
	Surface		*surface;
    public:
	BitmapFont(Surface *s, const string &descr) throw(InvalidFont);
	~BitmapFont() { delete surface; }

	int get_lineskip() { return surface->height() + 3; }
	int get_width(char c);
	int get_width(const std::string &str);
	int get_height();

	Surface *render(const std::string &str);
    };
}

BitmapFont::BitmapFont(Surface *s, const string &descr)
    throw(InvalidFont)
    : char_rects(256), advance(256), surface(s)
{
    Assert<InvalidFont>(surface != 0);
    
    // Read and interpret the font description file.
    // expected line format:
    // charno xpos width xadvance

    FILE *fp=fopen(descr.c_str(), "rt");
    if (!fp) throw InvalidFont();
//     ifstream d(descr.c_str());
//     if (!d) throw InvalidFont();

    int c;
    int x=0, w=0, adv=0;
    while (fscanf(fp, "%d %d %d %d\n", &c, &x, &w, &adv) != EOF) {
//         d >> x >> w >> adv;
        char_rects[c].x = x;
        char_rects[c].w = w;
        char_rects[c].y = 0;
        char_rects[c].h = s->height();
        advance[c] = adv;
    }
    
}

int BitmapFont::get_width(char c)
{
    return advance[int(c)];
}

int BitmapFont::get_width(const string &str)
{
    string::const_iterator i, e=str.end();
    int w=0;
    for (i=str.begin(); i!=e; ++i)
    {
	w += get_width(*i);
    }
    return w;
}

int BitmapFont::get_height()
{
    return surface->height();
}

Surface *
BitmapFont::render(const string &str)
{
    Surface *s = new Surface16(get_width(str), get_height());
    s->set_color_key(0);
    if (s) {
        string::const_iterator i, e=str.end();
	int x=0;
	for (i=str.begin(); i!=e; ++i) {
	    s->blit(x, 0, surface, char_rects[int(*i)]);
	    x += get_width(*i);
	}
    }
    return s;
}

Font *
px::LoadBitmapFont(const string &imgname, const string &descrname)
{
    if (Surface *s = LoadImage(imgname.c_str()))
        return new BitmapFont(s, descrname);
    return 0;
}
 
//
// TrueType fonts (using SDL_ttf if available)
//
namespace
{
    class TTF_Font : public Font {
    public:

    };
}
