//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#ifndef PX_ERROR_HH
#define PX_ERROR_HH

#include <string>

namespace px
{
    using std::string;

/*======================================================================
  EXCEPTIONS.
  ======================================================================*/
    class XGeneric {
    public:
	// Constructor.
	XGeneric (const std::string& str = "")
	    : m_string (str)
	{}
	virtual ~XGeneric() {}
	// Accessors
	const string& get_string() const { return m_string; }
    private:
	std::string m_string;
    };

    class XInputOutput : public XGeneric {
    public:
	XInputOutput (const std::string& str = "InputOutput")
	    : XGeneric(str)
	{}
    };

    class XEndOfFile : public XInputOutput {
    public:
	XEndOfFile (const std::string& str = "End of file")
	    : XInputOutput(str)
	{}
    };

    class XFileFormat : public XInputOutput {
    public:
	XFileFormat (const std::string& str = "File format")
	    : XInputOutput(str)
	{}
    };

    class XVideo : public XGeneric {
    public:
	XVideo (const std::string& str = "Video")
	    : XGeneric(str)
	{}
    };
}
#endif
