//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#ifndef PLAYER_HH
#define PLAYER_HH

#include "objects.hh"
#include <vector>

namespace player
{
    using world::Item;
    using world::Actor;

    class Inventory {
    public:
        Inventory();
        ~Inventory();
        void add_item(Item *i);
        int size() { return items.size(); } // number of items
        bool is_full() { return items.size() == max_items; }
        void rotate();
        void activate_first();
        Item *get_item(int idx);
    private:
        static const unsigned max_items;
        std::vector<Item*> items;
    };

    class Player {
    public:

    private:
        std::string name;
        Inventory inv;
    };

    Inventory *GetInventory(int iplayer);
    int CurrentPlayer();
    void Suicide();

    void NewWorld(int nplayers);
    void SetMainActor(int iplayer, Actor *a);

    bool AllActorsDead();

    void InhibitPickup(bool fl);
    void PickupItem(Actor *a, world::GridPos p);
    void RotateInventory();
    void ActivateItem();
}
#endif
