//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#ifndef LUA_HH
#define LUA_HH

#include <string>
#include <exception>
#include "tools.hh"

extern "C" {
#include "lua/include/lua.h"
}

namespace lua
{
    extern lua_State *state;

    class Error : public std::exception {
    public:
        const char *what() const throw() { return "Error in Lua code"; }
    };


    struct CFunction {
        lua_CFunction func;
        const char *name;
    };

    // Register the C functions in `funcs'.  The end of the array is
    // denoted by an entry with func==0.
    void RegisterFuncs(CFunction funcs[]);

    // Call a LUA function with one argument.  This is mainly used for
    // callbacks during the game.
    void CallFunc(const std::string &funcname, const tools::Value& arg);


    void set_str(const char *varname, const char *str);
    const char *get_str(const char *varname);

    void set_num(const char *varname, double num);
    double get_num(const char *varname);

    void Dofile(const std::string & filename);

    void Init();
    void Shutdown();
}

#endif
