//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#ifndef ENIGMA_HH
#define ENIGMA_HH

#include "fwd.hh"
#include "px/pxfwd.hh"

#include <vector>
#include <string>

namespace enigma
{

    enum Direction { 
        NODIR = -1,
        NORTH = 3,
        EAST = 2,
        SOUTH = 1, 
        WEST = 0,
    };
    Direction reverse(Direction d);

    enum DirectionBits {
        NODIRBIT = 0,
        NORTHBIT = 1 << NORTH,
        EASTBIT  = 1 << EAST,
        SOUTHBIT = 1 << SOUTH,
        WESTBIT  = 1 << WEST,
    };

    inline DirectionBits to_bits(Direction d) {
        if (d==-1)
            return NODIRBIT;
        return DirectionBits(1 << d);
    }

    inline bool has_dir(DirectionBits db, Direction dir) {
        return db & to_bits(dir);
    }

    struct GridPos {
        int x, y;
        explicit GridPos(int xx=0, int yy=0) : x(xx), y(yy) {}

        void move(Direction dir);
    };
    GridPos move(GridPos p, Direction dir);
    inline bool operator< (GridPos a, GridPos b) {
        return ((a.y<<16) + a.x) < ((b.y<<16) + b.x);
    }
    bool operator!=(GridPos a, GridPos b);
}

namespace enigma
{
    void SetCaption(const std::string &str);

    // Find a file named `filename' in one of the Enigma data
    // directories.  The filename may include subdirectory names.
    // 
    // FindDataFile("graphics/bomb.png") 
    //     -> "/usr/local/share/enigma/graphics/bomb.png"
    //     or "/home/user/.enigma/graphics/bomb.png"
    std::string FindDataFile(const std::string &filename);

    px::Font &LoadFont(const std::string &name);
    px::Surface *LoadImage(const std::string &name);

    void ClearLevelList();
    void AddLevel(const std::string &file,
                  const std::string &descr);

    void FinishLevel();
    void RestartLevel();

    void QuitMainloop();
}

#endif
