//======================================================================
// Copyright (C) 2002 Daniel Heck
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//======================================================================
#ifndef CACHE_HH
#define CACHE_HH

#include <map>
#include <string>

namespace cache 
{
    template <class T, class Alloc>
    class Cache {
    public:
        Cache() {}
        Cache(const Alloc &a) :alloc(a) {}
        ~Cache() { clear(); }
        void clear() {
            for (iterator i=cache.begin(); i!=cache.end(); ++i) 
                alloc.release(i->second);
            cache.clear();
        }

        T get(const std::string &key) {
            iterator i=cache.find(key);
            if (i!=cache.end())
                return i->second;
            else {
                T p = alloc.acquire(key);
                cache[key] = p;
                return p;
            }
        }
    private:
        typedef std::map<std::string, T> Map;
        typedef Map::iterator iterator;
        typedef Map::const_iterator const_iterator;

        Alloc alloc;
        Map cache;
    };

}

#endif
