/*
 *         $BH~>/=w%3%9%W%l;~7W(B
 *             Emi Clock
 *           ($B$($_$/$m$C$/(B)
 *   for X Window System, Version 11
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


#include "config.h"			/* $B%3%s%Q%$%k4D6-$NDj5A(B */

/* $B#X%D!<%k%-%C%H%W%m%0%i%_%s%0$KI,MW$J%X%C%@!<(B */
#include <X11/Intrinsic.h>		/* $B%$%s%H%j%s%7%C%/$NDj5A(B */
#include <X11/StringDefs.h>		/* $BI8=`%j%=!<%9J8;zNs$NDj5A(B */

#if XlibSpecificationRelease > 4
#include <X11/Xlocale.h>		/* X11 $B$N(B locale $B4X78(B */
#else	/* X11R4? */
#include <locale.h>			/* locale $B%i%$%V%i%j(B */
#endif	/* X11R5, X11R6 */

/* kernel $B4X78$N%X%C%@!<(B */
#include <sys/param.h>			/* $B%7%9%F%`%Q%i%a!<%?(B */

/* Widgets */
#include "EmiClock.h"			/* EmiClock Widget */
#include <X11/Shell.h>			/* Shell Widget */

/* $B#C8@8l%i%$%V%i%j(B */
#include <stdio.h>			/* $BI8=`F~=PNO%i%$%V%i%j(B */
#include <stdlib.h>			/* $BI8=`%i%$%V%i%j(B */
#include <signal.h>			/* $B%7%0%J%k4X78(B */
#include <sys/types.h>			/* $B7?$NDj5A(B */
#include <time.h>			/* $B;~4V4X78(B (1) */
#include <sys/time.h>			/* $B;~4V4X78(B (2) */

/* Emi Clock $BFH<+$N%X%C%@!<(B */
#include "include/system.h"		/* $B%7%9%F%`4D6-$N:9J,5[<}(B */
#include "include/const.h"		/* $BDj?tDj5A(B */
#include "include/types.h"		/* $BFC<l$J7?$NDj5A(B */
#include "include/public.h"		/* $BHFMQ4X?t!?30ItDj5A%G!<%?$N@k8@(B */
#include "include/util.h"		/* $B%^%/%mDj5A(B */

/* $B%"%$%3%s(B */
#include "graphics/misc/icon.xbm"
#include "graphics/misc/icon_mask.xbm"

/* RCS ID */
rcsId(mainId, "$Id: main.c,v 1.4 1999/09/26 16:18:18 koba Exp $")

/* $B%m!<%+%k4X?t$N%W%m%H%?%$%W@k8@(B */
static void NonX11Syntax __P((int, char **));
static void AfterXtInitSyntax __P((int, char **, Boolean *));
static void Usage __P((void));
static void SetIcon __P((Widget));
static void HourlyChimeCallback __P((Widget, XtPointer, XtPointer));
static void HalfHourChimeCallback __P((Widget, XtPointer, XtPointer));
static void AlarmCallback __P((Widget, XtPointer, XtPointer));
static void Quit __P((Widget, XEvent *, String *, Cardinal *));
static SIGTYPE SigHandler __P((void));
static int IOError __P((Display *));

/* $B%"%/%7%g%s%F!<%V%k(B */
static XtActionsRec	actionList[] = {
    { "placeMainMenu",		(XtActionProc)PlaceMainMenu },
    { "redrawCreditPicture",	(XtActionProc)RedrawCreditPicture },
    { "dialogButtonPress",	(XtActionProc)DialogButtonPress },
    { "setNeko1Curs",		(XtActionProc)SetNeko1Curs },
    { "hourlyChimeDialogOk",	(XtActionProc)HourlyChimeDialogOk },
    { "halfHourChimeDialogOk",	(XtActionProc)HalfHourChimeDialogOk },
    { "noteAlarmDialogOk",	(XtActionProc)NoteAlarmDialogOk },
    { "alarmSettingsDialogOk",	(XtActionProc)AlarmSettingsDialogOk },
    { "quit",			(XtActionProc)Quit },
};

/* $B%"%W%j%1!<%7%g%s%G!<%?(B */
AppData	app_data;

/* $BJ8;zNs%j%=!<%9$NDj5A(B */
#define	XtNnoSave			"noSave"
#define	XtCNoSave			"NoSave"
#define	XtNnoSoundCache			"noSoundCache"
#define	XtCNoSoundCache			"NoSoundCache"

/* $B%"%W%j%1!<%7%g%s%j%=!<%9%F!<%V%k(B */
static XtResource	resources[] = {
    {
	XtNnoSave, XtCNoSave, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isNoSave),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNnoSoundCache, XtCNoSoundCache, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isNoSoundCache),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNnoShape, XtCNoShape, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isNoShape),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNperfect, XtCPerfect, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isPerfect),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNgrayscale, XtCGrayscale, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isGrayscale),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNgray4, XtCGray4, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isGray4),
			XtRImmediate, (XtPointer)FALSE
    },
    {
	XtNmono, XtCMono, XtRBoolean, sizeof(Boolean),
		XtOffset(AppDataPtr, isMono),
			XtRImmediate, (XtPointer)FALSE
    },
};

/* $B%3%^%s%I9T%*%W%7%g%s%F!<%V%k(B */
static XrmOptionDescRec	options[] = {
    { "-nosave",	"*noSave",	XrmoptionNoArg,		"TRUE" },
    { "-noscache",	"*noSoundCache",
					XrmoptionNoArg,		"TRUE" },
    { "-noshape",	"*noShape",	XrmoptionNoArg,		"TRUE" },
    { "-perfect",	"*perfect",	XrmoptionNoArg,		"TRUE" },
    { "-grayscale",	"*grayscale",	XrmoptionNoArg,		"TRUE" },
    { "-gray4",		"*gray4",	XrmoptionNoArg,		"TRUE" },
    { "-mono",		"*mono",	XrmoptionNoArg,		"TRUE" },
};

/* $B%0%m!<%P%k(B */
char		*programName = NULL;	/* $B%W%m%0%i%`L>(B */
Widget		toplevel;		/* $B%H%C%W%l%Y%k(B Widget */
Widget		emiclock;		/* EmiClock Widget */
static Atom	wm_delete_window;	/* "WM_DELETE_WINDOW" $B$N%"%H%`(B */

static Boolean		isSoundEnvInit = False;
static RcData		rcData;		/* $HOME/.emiclockrc $BJ]B8%G!<%?(B */
static AlarmTime	alarmTime;


/*
 *  $B%a%$%s4X?t(B
 */
int
main(argc, argv)
    int		argc;
    char	**argv;
{
    XtAppContext	appContext;
    Boolean		isRcFile;
    long		now;
    struct tm		*tm;

    static String	trans = "#override\n\
	<Btn1Down>: timerButtonPress() placeMainMenu() XtMenuPopup(mainMenu)";

    /* $B%W%m%0%i%`L>$N5-21(B */
    programName = argv[0];

    /* $BFCJL$J%3%^%s%I%i%$%s0z?t$N%A%'%C%/(B */
    NonX11Syntax(argc, argv);

    /* locale $B$N@_Dj(B */
#if XlibSpecificationRelease > 4
    XtSetLanguageProc(NULL, NULL, NULL);
#endif	/* X11R5, X11R6 */
    setlocale(LC_CTYPE, "");

    /* $B%H%C%W%l%Y%k(B Widget $B$N@8@.(B */
    toplevel = XtVaAppInitialize(
	&appContext,		/* $B%"%W%j%1!<%7%g%s%3%s%F%/%9%H(B */
	"EmiClock",		/* $B%"%W%j%1!<%7%g%s$N%/%i%9L>(B */
	options,		/* $B%"%W%j%1!<%7%g%s8GM-$N%3%^%s%I9T0z?t(B */
	XtNumber(options),	/* $B%"%W%j%1!<%7%g%s%3%^%s%I9T0z?t$N?t(B */
	&argc, argv,		/* $B%3%^%s%I9T0z?t(B */
	NULL,			/* $B%G%U%)%k%H$N%j%=!<%9@_Dj(B */
	NULL);			/* $B2DJQD90z?t$N=*C<(B */

    /* $B%5%&%s%I4D6-$N=i4|2=(B */
    SoundEnvInit();
    isSoundEnvInit = True;

    /* 0$BJ,%A%c%$%`$H(B30$BJ,%A%c%$%`!"%"%i!<%`$N%G%U%)%k%H@_Dj(B */
#ifdef	USE_SOUND
    StoreHourlyChimeFileName(GetStartupSoundFileName());
    StoreHalfHourChimeFileName(GetStartupSoundFileName());
    StoreAlarmFileName(GetStartupSoundFileName());
#endif	/* USE_SOUND */

    /* $BFC<l$J%"%W%j%1!<%7%g%s%G!<%?$N=i4|2=(B */
    app_data.isNoStartupSound = False;

    /* $HOME/.emiclockrc $B$NFbMFI|5"(B */
    isRcFile = RestoreRCFile(&rcData);
    if (isRcFile) {
	app_data.isNoStartupSound = rcData.isNoStartupSound;
    }

    if (argc > 1) {
	AfterXtInitSyntax(argc, argv, &(app_data.isNoStartupSound));
    }

    /* $B%"%/%7%g%s$NEPO?(B */
    XtAppAddActions(appContext, actionList, XtNumber(actionList));
    XtOverrideTranslations(toplevel,
		XtParseTranslationTable("<Message>WM_PROTOCOLS: quit()"));

    /* $B%"%W%j%1!<%7%g%s%j%=!<%9$N<hF@(B */
    XtVaGetApplicationResources(toplevel,
	&app_data,
	resources,
	XtNumber(resources),
	NULL);

    /* $B%H%C%W%l%Y%k(B Widget $B$NI}$H9b$5$r@_Dj(B */
    XtVaSetValues(toplevel,
	XtNwidth,	CBASE_WIDTH,
	XtNheight,	CBASE_HEIGHT,
	NULL);

    /* $B%"%$%3%s@_Dj(B */
    SetIcon(toplevel);

    /* $B%"%i!<%`;~9o$r8=:_;~9o$G=i4|2=(B */
    now = time(NULL);
    tm = localtime(&now);
    alarmTime.year = tm->tm_year + 1900;
    alarmTime.month = tm->tm_mon + 1;
    alarmTime.date = tm->tm_mday;
    alarmTime.hour = 0;
    alarmTime.minute = 0;
    alarmTime.second = 0;

    /* EmiClock Widget $B$N@8@.(B */
    emiclock = XtVaCreateManagedWidget(
		"emiclock",		/* Widget $BL>(B */
		emiClockWidgetClass,	/* Widget $B%/%i%9(B */
		toplevel,		/* $B?F$H$J$k(B Widget */
		XtNperfect,		app_data.isPerfect,
		XtNnoShape,		app_data.isNoShape,
		XtNmono,		app_data.isMono,
		XtNgrayscale,		app_data.isGrayscale,
		XtNgray4,		app_data.isGray4,
		XtNtranslations,	XtParseTranslationTable(trans),
		XtNalarmTime,		&alarmTime,
		NULL);			/* $B2DJQD90z?t$N=*C<(B */

    if (isRcFile) {
	XtVaSetValues(emiclock,
		XtNnoSecond,			rcData.isNoSecond,
		XtNhourlyCharacterChange,	rcData.isHourlyCharChange,
		XtNanimateCharacter,		rcData.isAnimateCharacter,
		XtNcharNo,			rcData.charNo,
		XtNcbaseNo,			rcData.cbaseNo,
		XtNhourlyChime,			rcData.isHourlyChime,
		XtNhalfHourChime,		rcData.isHalfHourChime,
		XtNplayAlarm,			rcData.isPlayAlarm,
		XtNoneTime,			rcData.isOneTime,
		XtNdailyAlarm,			rcData.isDailyAlarm,
		NULL);
	alarmTime = rcData.alarmTime;
    }

    /* $B%7%0%J%k%O%s%I%i@_Dj(B */
    if (signal(SIGINT, SIG_IGN) != SIG_IGN) {
	signal(SIGINT, (SIGTYPE (*)())SigHandler);
    }
    if (signal(SIGTERM, SIG_IGN) != SIG_IGN) {
	signal(SIGTERM, (SIGTYPE (*)())SigHandler);
    }

    /* $B%]%C%W%"%C%W%a%K%e!<$N@8@.(B */
    CreatePopupMenu(toplevel);

    /* $BA4$F$N(B Widget $B$N%&%#%s%I%&$r<B:]$K@8@.$7!"(BMap $B$9$k(B */
    XtRealizeWidget(toplevel);

    /* $B%&%#%s%I%&%^%M!<%8%c$+$i$N(B f.delete $B$X$NBP1~(B */
    wm_delete_window = XInternAtom(XtDisplay(toplevel),
					"WM_DELETE_WINDOW", False);
    XSetWMProtocols(XtDisplay(toplevel), XtWindow(toplevel),
						&wm_delete_window, 1);

    /* $B5/F02;!V$_$e$C!*!W:F@8(B */
    if (IsSoundAvailable()) {
	if (!app_data.isNoStartupSound) {
	    PlayStartupSound();
	}
    }

    /* $B%A%c%$%`$N%3!<%k%P%C%/@_Dj(B */
    XtAddCallback(emiclock, XtNhourlyChimeCallback, HourlyChimeCallback, NULL);
    XtAddCallback(emiclock, XtNhalfHourChimeCallback,
						HalfHourChimeCallback, NULL);

    /* $B%"%i!<%`$N%3!<%k%P%C%/@_Dj(B */
    XtAddCallback(emiclock, XtNalarmCallback, AlarmCallback, NULL);

    /* X11 I/O $B%(%i!<%O%s%I%i@_Dj(B */
    XSetIOErrorHandler((int (*)())IOError);

    /* $B%$%Y%s%H%k!<%W(B */
    XtAppMainLoop(appContext);

    exit(0);
}


/*
 *  $B%W%m%0%i%`!&%*%W%7%g%s2r@O!J(BX11$B%5!<%P$H$N@\B3A0!K(B
 */
static void
NonX11Syntax(argc, argv)
    int		argc;
    char	**argv;
{
    int		i;

    /* $B:G=i$N0z?t$O%W%m%0%i%`L>$J$N$G!"$=$l$r=|$$$?0z?t$rD4$Y$k(B */
    for (i = 1; i < argc; i++) {
	if (strncmp(argv[i], HELP_STR, strlen(HELP_STR)) == 0) {
	    Usage();
	    exit(0);
	}

	if (strncmp(argv[i], VERS_STR, strlen(VERS_STR)) == 0) {
	    fprintf(stderr, "%s version %s\n", PRODUCT_STR, GetVersion());
	    fprintf(stderr, "%s\n", COPYRIGHT_STR);
	    exit(0);
	}
    }
}


/*
 *  $B%W%m%0%i%`!&%*%W%7%g%s2r@O!J(BXtVaAppInitialize() $B<B9T8e!K(B
 */
static void
AfterXtInitSyntax(argc, argv, isNossound)
    int		argc;
    char	**argv;
    Boolean	*isNossound;
{
    int		i;
    Boolean	isError = False;

    /* $B:G=i$N0z?t$O%W%m%0%i%`L>$J$N$G!"$=$l$r=|$$$?0z?t$rD4$Y$k(B */
    for (i = 1; i < argc; i++) {
	if (strncmp(argv[i], NOSSOUND_STR, strlen(NOSSOUND_STR)) == 0) {
	    *isNossound = True;
	    continue;
	}

	if (!isError) {
	    fprintf(stderr, "%s: Unknown command line option \"%s\".\n",
							programName, argv[i]);
	    isError = True;
	}
    }

    if (isError) {
	Usage();
	exit(1);
    }
}


/*
 *  Usage
 */
static void
Usage(void)
{
    fprintf(stderr, "Usage: %s [options]\n", programName);
    fprintf(stderr, "\t-toolkitoption ...\n");
    fprintf(stderr, "\t%s\n", NOSSOUND_STR);
    fprintf(stderr, "\t-nosave\n");
    fprintf(stderr, "\t-noscache\n");
    fprintf(stderr, "\t-noshape\n");
    fprintf(stderr, "\t-perfect\n");
    fprintf(stderr, "\t-grayscale\n");
    fprintf(stderr, "\t-gray4\n");
    fprintf(stderr, "\t-mono\n");
    fprintf(stderr, "\t-help\n");
    fprintf(stderr, "\t-version\n");
}


/*
 *  $B%"%$%3%s@_Dj(B
 */
static void
SetIcon(w)
    Widget	w;
{
    XtVaSetValues(w,
    	XtNiconPixmap,	XCreateBitmapFromData(XtDisplay(w),
				RootWindowOfScreen(XtScreen(w)),
				emiicon_bits, emiicon_width, emiicon_height),
	XtNiconMask,	XCreateBitmapFromData(XtDisplay(w),
				RootWindowOfScreen(XtScreen(w)),
				emiicon_mask_bits,
				emiicon_mask_width, emiicon_mask_height),
	NULL);
}


/*
 *  0$BJ,%A%c%$%`(B
 */
static void
HourlyChimeCallback(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    if (IsSoundAvailable()) {
	PlayHourlyChime();
    }
}


/*
 *  30$BJ,%A%c%$%`(B
 */
static void
HalfHourChimeCallback(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    if (IsSoundAvailable()) {
	PlayHalfHourChime();
    }
}


/*
 *  $B%"%i!<%`(B
 */
static void
AlarmCallback(w, client_data, call_data)
    Widget	w;
    XtPointer	client_data;
    XtPointer	call_data;
{
    Boolean	isPlayAlarm;

    XtVaGetValues(emiclock, XtNplayAlarm, &isPlayAlarm, NULL);

    if (IsSoundAvailable() && isPlayAlarm) {
	PlayAlarm();
    }

    AlarmDialogPopup(w);
}


/*
 *  $B%&%#%s%I%&%^%M!<%8%c$K$h$k%W%m%0%i%`=*N;(B
 */
static void
Quit(w, event, params, num_params)
    Widget	w;
    XEvent	*event;
    String	*params;
    Cardinal	*num_params;
{
    if ((event->type == ClientMessage) && 
		(event->xclient.data.l[0] != wm_delete_window)) {
	XBell(XtDisplay(w), 0);
    } else {
	XCloseDisplay(XtDisplay(w));
	ProgramExit(0);
    }
}


/*
 *  $B%7%0%J%k%O%s%I%i(B
 */
static SIGTYPE
SigHandler()
{
    ProgramExit(1);
}


/*
 *  X11 I/O $B%(%i!<%O%s%I%i(B
 */
static int
IOError(display)
    Display	*display;
{
    char	buffer[MAXPATHLEN];

    sprintf(buffer, "%s: Fatal I/O Error on X Server.", programName);
    XtWarning(buffer);

    ProgramExit(1);
    return(0);
}


/*
 *  $B%W%m%0%i%`=*N;(B
 */
void
ProgramExit(status)
    int		status;
{
    if (!app_data.isNoSave) {
	SaveRCFile();
    }

    if (IsSoundAvailable() && isSoundEnvInit) {
	SoundEnvDispose();	/* $B%5%&%s%I4D6-$N8e;OKv(B */
    }

    exit(status);
}
