/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.WrapperItemProvider;

public class FeatureMapEntryWrapperItemProvider
extends DelegatingWrapperItemProvider {
    protected EAttribute attribute;
    protected int index;
    static /* synthetic */ Class class$0;

    public FeatureMapEntryWrapperItemProvider(FeatureMap.Entry entry, EObject owner, EAttribute attribute, int index, AdapterFactory adapterFactory) {
        super(entry, owner, adapterFactory);
        this.attribute = attribute;
        this.index = index;
    }

    protected Object getEntryValue() {
        return ((FeatureMap.Entry)this.value).getValue();
    }

    protected EStructuralFeature getEntryFeature() {
        return ((FeatureMap.Entry)this.value).getEStructuralFeature();
    }

    protected boolean isEntryAttribute() {
        return this.getEntryFeature() instanceof EAttribute;
    }

    protected Object getDelegateValue() {
        return this.isEntryAttribute() ? null : this.getEntryValue();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getText(Object object) {
        String text = null;
        XMLTypePackage xmlPackage = XMLTypePackage.eINSTANCE;
        text = this.getEntryFeature() == xmlPackage.getXMLTypeDocumentRoot_Text() ? this.encode(this.getEntryValue().toString()) : (this.getEntryFeature() == xmlPackage.getXMLTypeDocumentRoot_CDATA() ? "<![CDATA[" + this.encode(this.getEntryValue().toString()) + "]]>" : (this.getEntryFeature() == xmlPackage.getXMLTypeDocumentRoot_Comment() ? "<!--" + this.encode(this.getEntryValue().toString()) + "-->" : (ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)this.attribute) == 3 ? String.valueOf(this.getEntryFeature().getName()) + "='" + EcoreUtil.convertToString((EDataType)((EDataType)this.getEntryFeature().getEType()), (Object)this.getEntryValue()) + "'" : (this.getEntryValue() == null ? "<" + this.getEntryFeature().getName() + " xsi:nil=\"true\"/>" : (this.isEntryAttribute() ? this.addEntryFeature(EcoreUtil.convertToString((EDataType)((EDataType)this.getEntryFeature().getEType()), (Object)this.getEntryValue())) : this.addEntryFeature(super.getText(object)))))));
        return text;
    }

    protected String addEntryFeature(String text) {
        return "<" + this.getEntryFeature().getName() + "> " + text;
    }

    public Object getImage(Object object) {
        Object image = null;
        XMLTypePackage xmlPackage = XMLTypePackage.eINSTANCE;
        image = this.getEntryFeature() == xmlPackage.getXMLTypeDocumentRoot_Text() || this.getEntryFeature() == xmlPackage.getXMLTypeDocumentRoot_CDATA() || this.getEntryFeature() == xmlPackage.getXMLTypeDocumentRoot_Comment() ? EMFEditPlugin.INSTANCE.getImage("full/obj16/TextValue") : (this.isEntryAttribute() ? EMFEditPlugin.INSTANCE.getImage("full/obj16/GenericValue") : (this.getDelegateValue() == null ? EMFEditPlugin.INSTANCE.getImage("full/obj16/Item") : super.getImage(object)));
        return image;
    }

    protected String encode(String s) {
        StringBuffer result = new StringBuffer(s.length());
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ') {
                        result.append('\\');
                        result.append((int)c);
                        break;
                    }
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public List getPropertyDescriptors(Object object) {
        if (this.isEntryAttribute()) {
            if (this.propertyDescriptors == null) {
                IItemPropertyDescriptor descriptor = new ItemPropertyDescriptor(this.getRootAdapterFactory(), this.getPropertyName(), this.getPropertyDescription(), this.getEntryFeature(), this.isPropertySettable(), this.getPropertyImage());
                descriptor = new ItemPropertyDescriptorDecorator(this.owner, descriptor);
                this.propertyDescriptors = Collections.singletonList(descriptor);
            }
            return this.propertyDescriptors;
        }
        return super.getPropertyDescriptors(object);
    }

    public Object getEditableValue(Object object) {
        return this.isEntryAttribute() ? this.getEntryValue() : super.getEditableValue(object);
    }

    protected boolean isPropertySettable() {
        return false;
    }

    protected Object getPropertyImage() {
        return this.getPropertyImage(this.getEntryFeature().getEType().getInstanceClass());
    }

    public Command createCommand(Object object, EditingDomain domain, Class commandClass, CommandParameter commandParameter) {
        if (this.getDelegateValue() == null) {
            return this.baseCreateCommand(object, domain, commandClass, commandParameter);
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    protected Command wrapCommand(Command command, Class commandClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.command.CopyCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (commandClass == clazz) {
            return new WrapperItemProvider.WrappingCopyCommand(this, command){

                public IWrapperItemProvider copy() {
                    Iterator i = this.getCommand().getResult().iterator();
                    return new FeatureMapEntryWrapperItemProvider(FeatureMapUtil.createEntry((EStructuralFeature)FeatureMapEntryWrapperItemProvider.this.getEntryFeature(), i.next()), (EObject)FeatureMapEntryWrapperItemProvider.this.owner, FeatureMapEntryWrapperItemProvider.this.attribute, FeatureMapEntryWrapperItemProvider.this.index, FeatureMapEntryWrapperItemProvider.this.adapterFactory);
                }
            };
        }
        return super.wrapCommand(command, commandClass);
    }

    protected Command createCopyCommand(EditingDomain domain, Object owner, CopyCommand.Helper helper) {
        return new WrapperItemProvider.SimpleCopyCommand(this, domain){

            public IWrapperItemProvider copy() {
                Object entryValueCopy = null;
                Object entryValue = FeatureMapEntryWrapperItemProvider.this.getEntryValue();
                if (entryValue != null) {
                    EDataType dataType = (EDataType)FeatureMapEntryWrapperItemProvider.this.getEntryFeature().getEType();
                    String serialization = EcoreUtil.convertToString((EDataType)dataType, (Object)entryValue);
                    entryValueCopy = EcoreUtil.createFromString((EDataType)dataType, (String)serialization);
                    if (serialization == entryValue && serialization == entryValueCopy) {
                        entryValueCopy = new String((String)entryValue);
                    }
                }
                return new FeatureMapEntryWrapperItemProvider(FeatureMapUtil.createEntry((EStructuralFeature)FeatureMapEntryWrapperItemProvider.this.getEntryFeature(), entryValueCopy), (EObject)FeatureMapEntryWrapperItemProvider.this.owner, FeatureMapEntryWrapperItemProvider.this.attribute, FeatureMapEntryWrapperItemProvider.this.index, FeatureMapEntryWrapperItemProvider.this.adapterFactory);
            }
        };
    }
}

