/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETParseEventListener;
import org.eclipse.emf.codegen.jet.JETReader;

public class JETParser {
    protected JETReader reader;
    protected JETParseEventListener listener;
    protected CharArrayWriter writer;
    protected List coreElements = new ArrayList();
    protected String openDirective = "<%@";
    protected String closeDirective = "%>";
    protected String openScriptlet = "<%";
    protected String closeScriptlet = "%>";
    protected String openExpr = "<%=";
    protected String closeExpr = "%>";
    protected String quotedStartTag = "<\\%";
    protected String quotedEndTag = "%\\>";
    protected String startTag = "<%";
    protected String endTag = "%>";

    public JETParser(JETReader reader, JETParseEventListener parseEventListener, JETCoreElement[] coreElements) {
        this.reader = reader;
        this.listener = new DelegatingListener(parseEventListener, new Action(){

            public void execute() throws JETException {
                JETParser.this.flushCharData();
            }
        });
        this.writer = new CharArrayWriter();
        int i = 0;
        while (i < coreElements.length) {
            this.coreElements.add(coreElements[i]);
            ++i;
        }
    }

    public JETReader getReader() {
        return this.reader;
    }

    public void setStartTag(String tag) {
        this.openScriptlet = tag;
        this.openExpr = String.valueOf(tag) + "=";
        this.openDirective = String.valueOf(tag) + "@";
        this.quotedStartTag = String.valueOf(tag.charAt(0)) + "\\" + tag.charAt(1);
        this.startTag = tag;
        this.reader.setStartTag(tag);
    }

    public void setEndTag(String tag) {
        this.closeScriptlet = tag;
        this.closeExpr = tag;
        this.closeDirective = tag;
        this.quotedEndTag = String.valueOf(tag.charAt(0)) + "\\" + tag.charAt(1);
        this.endTag = tag;
        this.reader.setEndTag(tag);
    }

    public String getOpenScriptlet() {
        return this.openScriptlet;
    }

    public String getCloseScriptlet() {
        return this.closeScriptlet;
    }

    public String getOpenExpr() {
        return this.openExpr;
    }

    public String getCloseExpr() {
        return this.closeExpr;
    }

    public String getOpenDirective() {
        return this.openDirective;
    }

    public String getCloseDirective() {
        return this.closeDirective;
    }

    public String getQuotedStartTag() {
        return this.quotedStartTag;
    }

    public String getQuotedEndTag() {
        return this.quotedEndTag;
    }

    public String getStartTag() {
        return this.startTag;
    }

    public String getEndTag() {
        return this.endTag;
    }

    protected void flushCharData() throws JETException {
        char[] array = this.writer.toCharArray();
        if (array.length != 0) {
            this.listener.handleCharData(this.writer.toCharArray());
        }
        this.writer = new CharArrayWriter();
    }

    public void parse() throws JETException {
        this.parse(null);
    }

    public void parse(String until) throws JETException {
        this.parse(until, null);
    }

    public void parse(String until, Class[] accept) throws JETException {
        while (this.reader.hasMoreInput()) {
            JETCoreElement c;
            if (until != null && this.reader.matches(until)) {
                return;
            }
            Iterator e = this.coreElements.iterator();
            if (accept != null) {
                ArrayList<JETCoreElement> v = new ArrayList<JETCoreElement>();
                while (e.hasNext()) {
                    c = (JETCoreElement)e.next();
                    int i = 0;
                    while (i < accept.length) {
                        if (c.getClass().equals(accept[i])) {
                            v.add(c);
                        }
                        ++i;
                    }
                }
                e = v.iterator();
            }
            boolean accepted = false;
            while (e.hasNext()) {
                c = (JETCoreElement)e.next();
                this.reader.mark();
                if (!c.accept(this.listener, this.reader, this)) continue;
                accepted = true;
                break;
            }
            if (accepted) continue;
            String s = this.reader.nextContent();
            this.writer.write(s, 0, s.length());
        }
        this.flushCharData();
    }

    public static interface Action {
        public void execute() throws JETException;
    }

    public static class DelegatingListener
    implements JETParseEventListener {
        protected JETParseEventListener delegate;
        protected Action action;

        public DelegatingListener(JETParseEventListener delegate, Action action) {
            this.delegate = delegate;
            this.action = action;
        }

        public void doAction() throws JETException {
            this.action.execute();
        }

        public void beginPageProcessing() throws JETException {
            this.delegate.beginPageProcessing();
        }

        public void endPageProcessing() throws JETException {
            this.delegate.endPageProcessing();
        }

        public void handleDirective(String directive, JETMark start, JETMark stop, Map attrs) throws JETException {
            this.doAction();
            this.delegate.handleDirective(directive, start, stop, attrs);
        }

        public void handleScriptlet(JETMark start, JETMark stop, Map attrs) throws JETException {
            this.doAction();
            this.delegate.handleScriptlet(start, stop, attrs);
        }

        public void handleExpression(JETMark start, JETMark stop, Map attrs) throws JETException {
            this.doAction();
            this.delegate.handleExpression(start, stop, attrs);
        }

        public void handleCharData(char[] chars) throws JETException {
            this.delegate.handleCharData(chars);
        }
    }

    public static class Scriptlet
    implements JETCoreElement {
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            String end_open = null;
            HashMap attrs = null;
            if (!reader.matches(parser.getOpenScriptlet())) {
                return false;
            }
            String open = parser.getOpenScriptlet();
            String close = parser.getCloseScriptlet();
            reader.advance(open.length());
            if (end_open != null) {
                attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(end_open)) {
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.unterminated", new Object[]{open, reader.mark().toString()}));
                }
                reader.advance(end_open.length());
                reader.skipSpaces();
            }
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.unterminated", new Object[]{open, reader.mark().toString()}));
            }
            listener.handleScriptlet(start, stop, attrs);
            return true;
        }
    }

    public static class Expression
    implements JETCoreElement {
        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            Map attrs = null;
            if (!reader.matches(parser.getOpenExpr())) {
                return false;
            }
            String open = parser.getOpenExpr();
            String close = parser.getCloseExpr();
            reader.advance(open.length());
            JETMark start = reader.mark();
            JETMark stop = reader.skipUntil(close);
            if (stop == null) {
                throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.unterminated", new Object[]{open, reader.mark().toString()}));
            }
            listener.handleExpression(start, stop, attrs);
            return true;
        }
    }

    public static class QuoteEscape
    implements JETCoreElement {
        protected static final String APOS = "&apos;";
        protected static final String QUOTE = "&quote;";

        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            try {
                if (reader.matches(parser.getQuotedEndTag())) {
                    reader.advance(parser.getQuotedEndTag().length());
                    parser.writer.write(parser.getEndTag());
                    parser.flushCharData();
                    return true;
                }
                if (reader.matches(APOS)) {
                    reader.advance(APOS.length());
                    parser.writer.write("'");
                    parser.flushCharData();
                    return true;
                }
                if (reader.matches(QUOTE)) {
                    reader.advance(QUOTE.length());
                    parser.writer.write("\"");
                    parser.flushCharData();
                    return true;
                }
            }
            catch (IOException exception) {
                throw new JETException(exception);
            }
            return false;
        }
    }

    public static class Directive
    implements JETCoreElement {
        protected Collection directives = new ArrayList();

        public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
            if (reader.matches(parser.getOpenDirective())) {
                JETMark start = reader.mark();
                reader.advance(parser.getOpenDirective().length());
                reader.skipSpaces();
                String match = null;
                Iterator i = this.directives.iterator();
                while (i.hasNext()) {
                    String directive = (String)i.next();
                    if (!reader.matches(directive)) continue;
                    match = directive;
                    break;
                }
                if (match == null) {
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.bad.directive", new Object[]{start.format("jet.mark.file.line.column")}));
                }
                reader.advance(match.length());
                HashMap attrs = reader.parseTagAttributes();
                reader.skipSpaces();
                if (!reader.matches(parser.getCloseDirective())) {
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.unterminated", new Object[]{parser.getOpenDirective(), reader.mark().toString()}));
                }
                reader.advance(parser.getCloseDirective().length());
                JETMark stop = reader.mark();
                StringBuffer leadingCharacters = new StringBuffer();
                try {
                    if ("include".equals(match)) {
                        while (reader.hasMoreInput() && reader.peekChar() == 32) {
                            reader.nextChar();
                            leadingCharacters.append(' ');
                        }
                        if (reader.matches("\r\n")) {
                            reader.advance("\r\n".length());
                            leadingCharacters.append("\r\n");
                            parser.writer.write(leadingCharacters.toString());
                            parser.flushCharData();
                            stop = reader.mark();
                        } else if (reader.matches("\n\r")) {
                            reader.advance("\n\r".length());
                            leadingCharacters.append("\n\r");
                            parser.writer.write(leadingCharacters.toString());
                            parser.flushCharData();
                            stop = reader.mark();
                        } else if (reader.matches("\n")) {
                            reader.advance("\n".length());
                            leadingCharacters.append("\n");
                            parser.writer.write(leadingCharacters.toString());
                            parser.flushCharData();
                            stop = reader.mark();
                        } else {
                            reader.reset(stop);
                        }
                    }
                }
                catch (IOException exception) {
                    throw new JETException(exception);
                }
                listener.handleDirective(match, start, stop, attrs);
                return true;
            }
            return false;
        }

        public Collection getDirectives() {
            return this.directives;
        }
    }
}

