
static char rcsid[] = "@(#)$Id: reply.c,v 1.11.2.1 1999/08/27 04:06:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11.2.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/*** routine allows replying to the sender of the current message 

***/

#include "headers.h"
#include "me.h"
#include "s_elm.h"
#include <errno.h>

/** Note that this routine generates automatic header information
    for the subject and (obviously) to lines, but that these can
    be altered while in the editor composing the reply message! 
**/

char *strip_parens(), *get_token();

extern int errno;

char *error_description();

/* Prototype */
static void get_reply_subj P_((char *, char *, char *, int));

/* Determine the subject to use for a reply.  */
static void get_reply_subj(out_subj,in_subj,dflt_subj, size)
     char *out_subj;	 /* store the resulting subject here		*/
     char *in_subj;	/* subject of the original message		*/
     char *dflt_subj;	/* default to use if "in_subj" is empty		*/
     int size;
{
	if ( *in_subj == '\0' ) {
	  strfcpy(out_subj,dflt_subj, size);
	  return;
	}
	if (
	  ( in_subj[0] == 'r' || in_subj[0] == 'R' ) &&
	  ( in_subj[1] == 'e' || in_subj[1] == 'E' ) &&
	  ( in_subj[2] == ':' )
	) {
	  for ( in_subj += 3 ; whitespace(*in_subj) ; ++in_subj ) ;
	}
	strfcat( strfcpy( out_subj, "Re: ", size ), in_subj, size);
}

static int optimize_and_add P_((CONST struct addr_item * new_address, 
				struct addr_item **full_address));

static int optimize_and_add(new_address, full_address)
     CONST struct addr_item * new_address;
     struct addr_item ** full_address;
{
  int len;
  struct addr_item * result = *full_address;

  /* This routine will add the new address to the list of addresses
   * in the full address buffer IFF it doesn't already occur.  
   *
   * full_address buffer is realloced if needed.
   */

  for (len = 0; 
       result &&
	   result[len].addr && result[len].fullname && result[len].comment; 
       len++) {
    if (0 == strcmp(new_address->addr,result[len].addr)) {
      /* same address */

      if (result[len].fullname[0] == '\0')
	result[len].fullname = strmcat(result[len].fullname,
				       new_address->fullname);

      dprint(25,(debugfile,"optimize_and_add = 1:\n"));
      dprint(25,(debugfile,"        result[%d].fullname=%s\n",
		 len,result[len].fullname));
      dprint(25,(debugfile,"        result[%d].addr=%s\n",
		 len,result[len].addr));
      dprint(25,(debugfile,"        result[%d].comment=%s\n",
		 len,result[len].comment));      
      return(1);	/* duplicate address */
    }
  }

  result = safe_realloc(result,(len+2) * sizeof (struct addr_item));

  result[len].addr     = safe_strdup(new_address->addr);
  result[len].fullname = safe_strdup(new_address->fullname);
  result[len].comment = safe_strdup(new_address->comment);
  result[len+1].addr     = NULL;
  result[len+1].fullname = NULL;
  result[len+1].comment = NULL;

  dprint(25,(debugfile,"optimize_and_add = 0:\n"));
  dprint(25,(debugfile,"        result[%d].fullname=%s\n",
	     len,result[len].fullname));
  dprint(25,(debugfile,"        result[%d].addr=%s\n",
	     len,result[len].addr));
  dprint(25,(debugfile,"        result[%d].comment=%s\n",
	     len,result[len].comment));
  dprint(25,(debugfile,"        *full_address=result=%X\n",result));

  *full_address = result;
  return(0);
}

static struct addr_item * handle_reply_to P_((
					      struct header_rec * 
					      current_header
					      ));

static struct addr_item * handle_reply_to(current_header)
     struct header_rec * current_header;
{
  struct addr_item * result = NULL;
  struct addr_item * return_address = current_header->from;
  int count=0, line_len;
  char buf[VERY_LONG_STRING];

    /** First off, get to the first line of the message desired **/

  if (skip_envelope(current_header, MAILFILE(current_folder)) == -1) {
    int err = errno;
    dprint(1,(debugfile,"Error: seek %ld resulted in errno %s (%s)\n",
	      current_header->offset, error_description(err),
	      "handle_reply_to"));
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSeekFailedFile,
		      "ELM [seek] couldn't read %d bytes into file (%s)."),
	      current_header->offset, error_description(err));
    return NULL;
  }

  /** now let's parse the actual message! **/
  
  /* read_header_line reads also continuation lines ... 
   * 2 == check that this is header line...
   */
  while (0 < (line_len = read_header_line(MAILFILE(current_folder),
					  buf,sizeof(buf),
					  RHL_CHECK_HEADER))) {
    struct addr_item * addrs,*ptr;
    int iindex;
    
    /* we only want lines with reply-to addresses */
    if (!header_cmp(buf, "Reply-To", NULL)) 
      continue;
    
    /* extract the addresses from header */
    
    iindex = chloc(buf, ':')+1;               /* point beyond header name */
    dprint(2,(debugfile,"handle_reply_to> %s\n",buf));
    
    addrs = break_down_address(buf+iindex,		
			       !(current_header -> status & NOHDRENCODING) &&
			       is_rfc1522(buf+iindex) ?
			       rfc1522_decode_structured : decode_who_none);

    /* go through all addresses in this line */
    for (ptr = addrs; 
	 ptr && ptr -> addr && ptr->fullname && ptr->comment; 
	 ptr++) {
      
      /* do NOT add sendder's domain in here ! It was MTA's task
	 and if it is not added then there is good reason.
	 (adding of senders domain to unqualified addresses
	 BREAKS my local mailing lists!!!)
	 That is: It is possible that Reply-to is written by some
	 other site than From !!!
	 - Kari E. Hurtta <Kari.Hurtta@Fmi.Fi>
         */
      if (!optimize_and_add(ptr, &result)) {
	count++;
	dprint(3,(debugfile,
		  "handle_reply_to: #%d: addr=%s, fullname=%s, comment=%s\n",
		  count,ptr -> addr, ptr -> fullname, ptr->comment)); 
      }
    }
    if (addrs)
      free_addr_items(addrs);
  }
  
  /* if there wasn't reply-to header */
  if (!count) {
    struct addr_item *ptr;    
    for (ptr = return_address; 
	 ptr && ptr -> addr && ptr->fullname && ptr->comment; 
	 ptr++) {
      if (!optimize_and_add(ptr, &result)) {
	  dprint(3,(debugfile,
		    "handle_reply_to: RETADR: addr=%s, fullname=%s, comment=%s\n",
		    ptr -> addr, ptr -> fullname, ptr -> comment)); 
      }
    }
  }
  
  if (!result) {
    result             = safe_realloc(result,2 * sizeof (struct addr_item));
    result[0].addr     = safe_strdup(current_header->env_from);
    result[0].fullname = safe_strdup("");
    result[0].comment  = safe_strdup("");
    result[1].addr     = NULL;
    result[1].fullname = NULL;
    result[1].comment  = NULL;
    dprint(3,(debugfile,
	      "handle_reply_to: ENV: addr=%s, fullname=%s, comment=%s\n",
	      result[0].addr, result[0].fullname, result[0].comment)); 
  }

  return result;
}

static struct addr_item *  get_and_expand_everyone P_((
						       struct header_rec * 
						       current_header,
						       struct addr_item *
						       return_address));
 

static struct addr_item * get_and_expand_everyone(current_header,
						  return_address)
     struct header_rec * current_header;
     struct addr_item * return_address;
{
  enum { h_to = 0, h_cc = 1, h_done = 2 } count;
  struct addr_item * result = NULL;
  char * env_host = qstrpbrk(current_header->env_from,":");

  /* skip route */
  if (env_host)
    env_host = qstrpbrk(env_host,"@");
  else
    env_host = qstrpbrk(current_header->env_from,"@");

  /** As each address is taken, ensure that it
    isn't to the author of the message NOR to us.  If neither,
    prepend with current return address and append to result
    **/
    
  for (count = h_to ; count < h_done; count++) {
    struct addr_item * addrs = NULL, *ptr;
    
    switch (count) {
    case h_to: addrs = current_header->to; break;
    case h_cc: addrs = current_header->cc; break;
    }
    
    /* go through all addresses in this line */
    for (ptr = addrs; 
	 ptr && ptr -> addr && ptr->fullname && ptr->comment; 
	 ptr++) {

      if (0 == strcmp(ptr->addr,current_header->env_from)) 
	continue;

      if (okay_address_l(ptr, return_address)) {

	/**
	  Some mailers can emit unqualified addresses in the
	  headers, e.g. a Cc to a local user might appear as
	  just "user" and not "user@dom.ain".  We do a real
	  low-rent check here.  If it looks like a domain
	  address then we will pass it through.  Otherwise we
	  tag domain from envelope sender address.
	  **/
	
	if (qchloc(ptr->addr, '@') <= 0 && env_host)
	  ptr->addr = strmcat(ptr->addr,env_host);

	if (!optimize_and_add(ptr,&result)) {
	  dprint(3,(debugfile,
		    "get_and_expand_everyone: got: addr=%s, fullname=%s, comment=%s\n",
		    ptr -> addr, ptr -> fullname, ptr->comment));

	}
      }
    }
  }
  return result;
}

int
reply()
{
	/** Reply to the current message.  Returns non-zero iff
	    the screen has to be rewritten. **/

	char subject[SLEN];
	int  return_value, form_letter;
	struct addr_item * rt;
	struct header_rec * current_header =  headers[current-1];

	form_letter = (current_header->status & FORM_LETTER);

	get_reply_subj( subject, current_header->subject,
			( form_letter ?
			  catgets(elm_msg_cat, ElmSet, ElmFilledInForm, 
				  "Filled in form") :
			  catgets(elm_msg_cat, ElmSet, ElmReYourMail, 
				  "Re: your mail") ),
			sizeof subject);

	rt = handle_reply_to(current_header);
	if (form_letter)
	    return_value = mail_filled_in_form(current_header,rt, subject);
	else {
	    return_value = send_msg_l(current_header,rt, NULL, subject,
				      MAIL_EDIT_MSG | MAIL_REPLYING,
				      NO);
	    if (me_retcode) {
		current_header->status |= REPLIED;
		current_header->status_chgd = TRUE;
	    }
        }

	if (rt)
	  free_addr_items(rt);	  
	return(return_value);
}

int
reply_to_everyone()
{
  /** Reply to everyone who received the current message.  
    This includes other people in the 'To:' line and people
    in the 'Cc:' line too.  Returns non-zero iff the screen 
    has to be rewritten. **/
  
  char subject[SLEN];
  int  return_value;
  struct header_rec * current_header = headers[current-1];
  struct addr_item * rt = handle_reply_to(current_header);
  struct addr_item * cc = get_and_expand_everyone(current_header,rt);
  
  get_reply_subj( subject, current_header->subject,
		  catgets(elm_msg_cat, ElmSet, ElmReYourMail, 
			  "Re: your mail"),
		  sizeof subject);
  
  return_value = send_msg_l(current_header,rt, cc, subject,
			    MAIL_EDIT_MSG | MAIL_REPLYING,
			    NO);
  if (me_retcode) {
      current_header->status |= REPLIED;
      current_header->status_chgd = TRUE;
  }
  if (rt)
    free_addr_items(rt);	  
  if (cc)
    free_addr_items(cc);	  
  return(return_value);
}

int
forward()
{
	/** Forward the current message.  What this actually does is
	    to temporarily set forwarding to true, then call 'send' to
	    get the address and route the mail.   Modified to also set
	    'noheader' to FALSE also, so that the original headers
	    of the message sent are included in the message body also.
	    Return TRUE if the main part of the screen has been changed
	    (useful for knowing whether a redraw is needed.
	**/

	char subject[SLEN];
	int  results, edit_msg = FALSE;
	struct header_rec * current_header = headers[current-1];

	if (current_header->status & FORM_LETTER)
	  PutLineX(elm_LINES-3,elm_COLUMNS-40, 
		   CATGETS(elm_msg_cat, ElmSet, 
			   ElmNoEditingAllowed,
			   "<No editing allowed.>"));
	else {
	  elm_sfprintf(subject, sizeof subject,
		       CATGETS(elm_msg_cat, ElmSet, ElmEditOutgoingMessage,
			       "Edit outgoing message? (%c/%c) "), 
		       *def_ans_yes, *def_ans_no);
	  edit_msg = (want_to(subject,
			      *def_ans_yes, elm_LINES-3, 0) != *def_ans_no);
	}

	if (strlen(current_header->subject) > 0) {

	  strfcpy(subject, current_header->subject, sizeof subject); 

	  /* this next strange compare is to see if the last few chars are
	     already '(fwd)' before we tack another on */

	  if (strlen(subject) < 6 || (strcmp(subject+strlen(subject)-5,
					     "(fwd)") != 0))
	    strfcat(subject, " (fwd)", sizeof subject);

	  results = send_msg_l(current_header,
			       NULL, NULL, subject, 
			       (edit_msg ? MAIL_EDIT_MSG : 0 ) | 
			       MAIL_FORWARDING,
			       current_header->status & FORM_LETTER ? 
			       PREFORMATTED : allow_forms);
	}
	else
	  results = send_msg_l(current_header,
			       NULL, NULL,
			       catgets(elm_msg_cat, ElmSet, ElmForwardedMail, 
				       "Forwarded mail..."), 
			       (edit_msg ? MAIL_EDIT_MSG : 0 ) | 
			       MAIL_FORWARDING,
			       headers[current-1]->status & FORM_LETTER ? 
			       PREFORMATTED : allow_forms);	
	return(results);
}

int get_return_name(address, name, trans_to_lowercase, size)
     char *address, *name;
     int   trans_to_lowercase;
     int size;
{
	/** Given the address (either a single address or a combined list 
	    of addresses) extract the login name of the first person on
	    the list and return it as 'name'.  Modified to stop at
	    any non-alphanumeric character. **/

	/** An important note to remember is that it isn't vital that this
	    always returns just the login name, but rather that it always
	    returns the SAME name.  If the persons' login happens to be,
	    for example, joe.richards, then it's arguable if the name 
	    should be joe, or the full login.  It's really immaterial, as
	    indicated before, so long as we ALWAYS return the same name! **/

	/** Another note: modified to return the argument as all lowercase
	    always, unless trans_to_lowercase is FALSE... **/

	/**
	 *  Yet another note: Modified to return a reasonable name
	 *  even when double quoted addresses and DecNet addresses
	 *  are embedded in a domain style address.
	 **/

	char single_address[SLEN], *sa;
	register int	i, loc, iindex = 0,
			end, first = 0;
	register char	*c;

	dprint(6, (debugfile,"get_return_name called with (%s, <>, shift=%s, size=%d)\n",
		   address, onoff(trans_to_lowercase), size));

	/* First step - copy address up to a comma, space, or EOLN */

	for (sa = single_address; *address && 
	       sa - single_address < sizeof single_address -1 ; ) {
	    i = len_next_part(address);
	    if (i > 1) {
		while (--i >= 0 && 
		       sa - single_address < sizeof single_address -1)
		    *sa++ = *address++;
	    } else if (*address == ',' || whitespace(*address))
		break;
	    else
		*sa++ = *address++;
	}
	*sa = '\0';

	/* Now is it an Internet address?? */

	if ((loc = qchloc(single_address, '@')) != -1) {	  /* Yes */

	    /*
	     *	Is it a double quoted address?
	     */

	    if (single_address[0] == '"') {
		first = 1;
		/*
		 *  Notice `end' will really be the index of
		 *  the last char in a double quoted address.
		 */
		loc = ((end = chloc (&single_address[1], '"')) == -1)
		    ? loc
		    : end;
	    }
	    else {
		first = 0;
	    }

	    /*
	     *	Hope it is not one of those weird X.400
	     *	addresses formatted like
	     *	/G=Jukka/S=Ukkonen/O=CSC/@fumail.fi
	     */

	    if (single_address[first] == '/') {
		/* OK then, let's assume it is one of them. */

		iindex = 0;
		
		if ((c = strstr (&single_address[first], "/G"))
		    || (c = strstr (&single_address[first], "/g"))) {

		    for (c += 2; *c && (*c++ != '='); );
		    for ( ;*c && (*c != '/') && iindex < size-1; c++) {
		      name[iindex++] = trans_to_lowercase
#ifdef ASCII_CTYPE
			&& isascii(*c)
#endif
			? tolower ((unsigned char)*c) : *c;
		    }
		    if (iindex > 0 && iindex < size-1) {
			name[iindex++] = '.';
		    }
		}
		if ((c = strstr (&single_address[first], "/S"))
		    || (c = strstr (&single_address[first], "/s"))) {

		    for (c += 2; *c && (*c++ != '='); );
		    for ( ;*c && (*c != '/') && iindex < size-1; c++) {
			name[iindex++] = trans_to_lowercase
#ifdef ASCII_CTYPE
			  && isascii(*c)
#endif
			  ? tolower ((unsigned char)*c) : *c;
		    }
		}
		name[iindex] = '\0';

		for (c = name; *c; c++) {
		    *c = ((*c == '.') || (*c == '-') || isalnum (*c))
			? *c : '_';
		}

		if (iindex == 0) {
		    strfcpy (name, "X.400.John.Doe", size);
		}
		return 0;
	    }

	    /*
	     *	Is it an embedded DecNet address?
	     */

	    while (c = strstr (&single_address[first], "::")) {
		first = c - single_address + 2;
	    }
		    

	    /*
	     *	At this point the algorithm is to keep shifting our
	     *	copy window left until we hit a '!'.  The login name
	     *	is then located between the '!' and the first meta-
	     *	character to it's right (ie '%', ':', '/' or '@').
	     */

	    for (i=loc; single_address[i] != '!' && i > first-1; i--)
		if (single_address[i] == '%' || 
		    single_address[i] == ':' ||
		    single_address[i] == '/' ||
		    single_address[i] == '@') loc = i-1;
	
	    if (i < first || single_address[i] == '!') i++;

	    for (iindex = 0; iindex < loc - i + 1 && iindex < size-1; iindex++)
		if (trans_to_lowercase
#ifdef ASCII_CTYPE
		    && isascii(single_address[iindex+i])
#endif		    
		    )
		  name[iindex] = tolower((unsigned char)
					   single_address[iindex+i]);
		else
		    name[iindex] = single_address[iindex+i];
	    name[iindex] = '\0';

	}
	else {	/* easier - standard USENET address */

	    /*
	     *	This really is easier - we just cruise left from
	     *	the end of the string until we hit either a '!'
	     *	or the beginning of the line.  No sweat.
	     */

	    loc = strlen(single_address)-1; 	/* last char */

	    for (i = loc; 
		 i > -1 && single_address[i] != '!'
		 && single_address[i] != '.' && iindex < size-1; 
		 i--) {
		if (trans_to_lowercase
#ifdef ASCII_CTYPE
		    && isascii(single_address[iindex+i])
#endif		    
		    )
		  name[iindex++] = tolower((unsigned char)single_address[i]);
		else
		  name[iindex++] = single_address[i];
	    }
	    name[iindex] = '\0';
	    reverse(name);
	}
	return 0;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
