
static char rcsid[] = "@(#)$Id: editmsg.c,v 1.5.4.1 1999/10/10 15:57:04 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5.4.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This contains routines to do with starting up and using an editor (or two)
    from within Elm.  This stuff used to be in mailmsg2.c...
**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"
#include <errno.h>

char *error_description(), *format_long(), *strip_commas();
long  fsize();

/* The built-in editor is not re-entrant! */
static int	builtin_editor_active = FALSE;
static char *simple_continue = NULL;
static char *post_ed_continue = NULL;

extern int errno;

int      interrupts_while_editing;	/* keep track 'o dis stuff         */
JMP_BUF  edit_location;			/* for getting back from interrupt */

static int no_editor_edit_the_message P_((char *filename,
					  struct mailing_headers * headers));


void
tilde_help()
{
	/* a simple routine to print out what is available at this level */

	char	buf[SLEN];

	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgAvailOpts,
				"\n\r(Available options at this point are:\n\r\n\r"));
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgHelpMenu,
				"\t%c?\tPrint this help menu.\n\r"), 
			escape_char);
	if (escape_char == TILDE_ESCAPE) /* doesn't make sense otherwise... */
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgAddLine,
				  "\t~~\tAdd line prefixed by a single '~' character.\n\r"));

	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgBCC,
				"\t%cb\tChange the addresses in the Blind-carbon-copy list.\n\r"),
			escape_char);

	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgCC,
				"\t%cc\tChange the addresses in the Carbon-copy list.\n\r"),
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgEmacs,
				"\t%ce\tInvoke the Emacs editor on the message, if possible.\n\r"),
			escape_char);
      
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgAddMessage,
				 "\t%cf\tAdd the specified message or current.\n\r"),
			 escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgToCCBCC,
				"\t%ch\tChange all available headers (to, cc, bcc, subject).\n\r"),
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgSameCurrentPrefix,
				"\t%cm\tSame as '%cf', but with the current 'prefix'.\n\r"),
			escape_char, escape_char);
       
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgUserEditor,
				"\t%co\tInvoke a user specified editor on the message.\n\r"),
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgPrintMsg,
				"\t%cp\tPrint out message as typed in so far.\n\r"), 
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgReadFile,
				"\t%cr\tRead in the specified file.\n\r"), 
			escape_char);
       
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgSubject,
				"\t%cs\tChange the subject of the message.\n\r"),
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgTo,
				"\t%ct\tChange the addresses in the To list.\n\r"),
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgVi,
				"\t%cv\tInvoke the Vi visual editor on the message.\n\r"),
			escape_char);
       
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgUnixCmd,
			       "\t%c!\tExecute a UNIX command (or give a shell if no command).\n\r"),
	  escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgAddUnixCmd,
				"\t%c<\tExecute a UNIX command adding the output to the message.\n\r"),
			escape_char);
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgEndMsg,
				"\t.  \tby itself on a line (or a control-D) ends the message.\n\r"));
	
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgContinue,
				"Continue.)\n\r"));
}

void
read_in_file(fd, filename, show_user_filename)
FILE *fd;
char *filename;
int   show_user_filename;
{
	/** Open the specified file and stream it in to the already opened 
	    file descriptor given to us.  When we're done output the number
	    of lines and characters we added, if any... **/

	FILE *myfd;
	char exp_fname[SLEN], buffer[SLEN];
	register int n;
	register int lines = 0, nchars = 0;

	while (whitespace(*filename))
		++filename;

	/** expand any shell variables or leading '~' **/
	(void) expand_env(exp_fname, filename, sizeof(exp_fname));

	if (exp_fname[0] == '\0') {
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoFilenameSpecified,
				  "\n\r(No filename specified for file read! Continue.)\n\r"));
	  return;
	}

	if ((myfd = fopen(exp_fname,"r")) == NULL) {
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmCouldntReadFile,
				  "\n\r(Couldn't read file '%s'! Continue.)\n\r"), exp_fname);
	  return;
	}

	while (n = mail_gets(buffer, SLEN, myfd)) {
	  if(buffer[n-1] == '\n') lines++;
	  nchars += n;
  	  fwrite(buffer, 1, n, fd);
	}
	fflush(fd);

	fclose(myfd);

	if (lines == 1)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedLine,
				  "\n\r(Added 1 line ["));
	else
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedLinePlural,
				  "\n\r(Added %d lines ["), lines);

	if (nchars == 1)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedChar,
				  "1 char] "));
	else
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedCharPlural,
				  "%d chars] "), nchars);

	if (show_user_filename)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedFromFile,
				  "from file %s. Continue.)\n\r"),  
			  exp_fname);
	else
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedToMessage,
				  "to message. Continue.)\n\r"));

	return;
}

static void print_message_so_far P_((FILE *edit_fd,
				     char *filename,
				     struct mailing_headers * headers));

static void print_message_so_far(edit_fd, filename, headers)
     FILE *edit_fd;
     char *filename;
     struct mailing_headers * headers;
{
    /* This prints out the message typed in so far.  We accomplish
     * this in a cheap manner - close the file, reopen it for reading,
     * stream it to the screen, then close the file, and reopen it
     * for appending.  Simple, but effective!
     *
     * A nice enhancement would be for this to -> page <- the message
     * if it's sufficiently long.  Too much work for now, though.
     */
	
    char buffer[SLEN];
    char * addr_string;
    
    fflush(edit_fd);
    fseek(edit_fd, 0L, 0);

    addr_string = hdr_to_expval(headers->to);
    if (addr_string) {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgPrintTo,
				"\n\rTo: %s\n\r"), 
			format_long(addr_string, 4));
	free(addr_string);
    }

    addr_string = hdr_to_expval(headers->cc);
    if (addr_string) {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgPrintCC,
				"Cc: %s\n\r"), 
			format_long(addr_string, 4));
	free(addr_string);
    }

    addr_string = hdr_to_expval(headers->bcc);
    if (addr_string) {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgPrintBCC,
				"Bcc: %s\n\r"), 
			format_long(addr_string, 5));
	free(addr_string);
    }
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgPrintSubject,
			    "Subject: %s\n\r\n\r"), 
		    headers->subject ? headers->subject : "");

    while (fgets(buffer, SLEN, edit_fd) != NULL) {
	Write_to_screen(FRM("%s"),buffer, 0);
	CarriageReturn();
    }

    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgPrintContinue,
			    "\n\r(Continue entering message.)\n\r"));
}

void
read_in_messages(fd, buffer)
FILE *fd;
char *buffer;
{
	/** Read the specified messages into the open file.  If the
	    first character of "buffer" is 'm' then prefix it, other-
	    wise just stream it in straight...Since we're using the
	    pipe to 'readmsg' we can also allow the user to specify
	    patterns and such too...
	**/

	FILE *myfd, *popen();
	char  local_buffer[SLEN], *arg;
	register int add_prefix=0, mindex;
	register int n;
	int lines = 0, nchars = 0;

	add_prefix = buffer[0] == 'm' || buffer[0] == 'M';

	/* strip whitespace to get argument */
	for(arg = &buffer[1]; whitespace(*arg); arg++)
		;

	/* a couple of quick checks */
	if(message_count < 1) {
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoMessageReadContinue,
				  "(No messages to read in! Continue.)\n\r"));
	  return;
	}
	if (isdigit(*arg)) {
	  if((mindex = atoi(arg)) < 1 || mindex > message_count) {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmValidNumbersBetween,
				    "(Valid message numbers are between 1 and %d. Continue.)\n\r"),
			    message_count);
	    
	    return;
	  }
	}

	/* dump state information for "readmsg" to use */
	if (create_folder_state_file() != 0)
	  return;

	/* go run readmsg and get output */
	elm_sfprintf(local_buffer, sizeof local_buffer,
		     FRM("%s -- %s"), 
		     readmsg, arg);
	if ((myfd = popen(local_buffer, "r")) == NULL) {
	   Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmCantFindReadmsg,
				   "(Can't find 'readmsg' command! Continue.)\n\r"));
	   (void) remove_folder_state_file();
	   return;	
	}

	dprint(5, (debugfile, "** readmsg call: \"%s\" **\n", local_buffer));

	while (n = mail_gets(local_buffer, SLEN, myfd)) {
	  nchars += n;
	  if (local_buffer[n-1] == '\n') lines++;
	  if (add_prefix)
	    fprintf(fd, "%s", prefixchars);
	  fwrite(local_buffer, 1, n, fd);
	}

	pclose(myfd);
        (void) remove_folder_state_file();
	
	if (lines == 0) {
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgCouldntAdd,
	 	 "(Couldn't add the requested message. Continue.)\n\r"));
	  return;
	}

	if (lines == 1)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedLine,
	    "\n\r(Added 1 line ["));
	else
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedLinePlural,
				  "\n\r(Added %d lines ["), lines);

	if (nchars == 1)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedChar,
				  "1 char] "));
	else
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedCharPlural,
				  "%d chars] "), nchars);

	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmAddedToMessage,
				"to message. Continue.)\n\r"));

	return;
}

static void get_it P_((char *prompt, char *buffer, int size,  
		       char *sourcebuf));
static void get_it(prompt, buffer,size,sourcebuf)
     char *prompt;
     char *buffer;
     int size;
     char *sourcebuf;
{
    Write_to_screen(FRM("%s"),prompt);	fflush(stdout);	/* output! */
    
    if (sourcebuf != NULL) {
	while (!whitespace(*sourcebuf) && *sourcebuf != '\0') 
	    sourcebuf++;
	if (*sourcebuf != '\0') {
	    while (whitespace(*sourcebuf)) 
		sourcebuf++;
	    if (strlen(sourcebuf) > 0) {
		strfcat(buffer, " ", size);
		strfcat(buffer, sourcebuf, size);
	    }
	}
    }
    
    optionally_enter(buffer, -1, -1, OE_APPEND_CURRENT,
		     size);  /* already data! */
}

/* Prototype */
static void get_addr_with_expansion P_((char *prompt, 
					struct expanded_address *addr,
					char *sourcebuf)); 

static void get_addr_with_expansion(prompt,addr,sourcebuf)
     char *prompt;
     struct expanded_address *addr; 
     char *sourcebuf;
{
    char buffer[LONG_STRING];
    char *addr_string;

    /* This is used to prompt for a new value of the specified field.
     */
    
    expanded_to_edit_buffer(buffer, sizeof buffer, *addr);

    get_it(prompt, buffer, sizeof buffer, sourcebuf);

    /* update_expanded_from_edit_buffer() calls build_address_l() */
    update_expanded_from_edit_buffer(addr,buffer);

    addr_string = hdr_to_expval(*addr);
    if(addr_string != NULL) {
	if (*prompt == '\n')
	    Write_to_screen(FRM("%s%s"), prompt, addr_string);
	else
	    Write_to_screen(FRM("\n\r%s%s"), prompt, addr_string);
    }
    NewLine();
    
    return;
}

/* Prototype */
static void get_text P_((char *prompt, 
					char **text,
					char *sourcebuf)); 

static void get_text(prompt,text,sourcebuf)
     char *prompt;
     char **text; 
     char *sourcebuf;
{
    int size = STRING;
    int l = 0;
    char * buffer = NULL;
    
    if (*text)
	l+= strlen(*text);
    
    if (sourcebuf)
	l += strlen(sourcebuf);

    if (size < l)
	size = l+1;
    buffer = safe_malloc(size);
    if (*text)
	strfcpy(buffer,*text,size);
    else
	buffer[0] = '\0';

    get_it(prompt, buffer, sizeof buffer, sourcebuf);

    *text = strmcpy(*text,buffer);

    free(buffer);    
}

SIGHAND_TYPE
edit_interrupt(sig)
int sig;
{
	/** This routine is called when the user hits an interrupt key
	    while in the builtin editor...it increments the number of 
	    times an interrupt is hit and returns it.
	**/

	signal(SIGINT, edit_interrupt);
	signal(SIGQUIT, edit_interrupt);

	if (interrupts_while_editing++ == 0)
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
				  ElmEditmsgOneMoreCancel,
				  "(Interrupt. One more to cancel this letter.)\n\r"));
	else
	  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEditmsgCancelled,
				  "(Interrupt. Letter canceled.)\n\r"));

#if defined(SIGSET) && defined(HASSIGHOLD)
	/*
	 * During execution of a signal handler set with sigset(),
	 * the originating signal is held.  It must be released or
	 * it cannot recur.
	 */
	sigrelse(sig);
#endif /* SIGSET and HASSIGHOLD */

	LONGJMP(edit_location, 1);		/* get back */
}

static
enforce_newline(filename)
char *filename;
{
	/** Make sure there is a newline at the end of filename. Mostly to
	    be nice to Sun's sendmail, who hangs if there isn't. Return 0
	    if something went wrong, 1 otherwise. **/

	int err, ch, retcode = 0;
	FILE* fp;

	if ((fp = fopen(filename, "r+")) == NULL) {
	  err = errno;
	  dprint(1, (debugfile, "fopen failed on %s with mode r+\n", filename));
	  dprint(1, (debugfile, "** %s **\n", error_description(err)));
	} else if (fseek(fp, -1, 2) == -1) {
	  err = errno;
	  dprint(1, (debugfile, "fseek(-1,2) failed on %s\n", filename));
	  dprint(1, (debugfile, "** %s **\n", error_description(err)));
	} else if ((ch = fgetc(fp)) == EOF) {
	  err = errno;
	  dprint(1, (debugfile, "unexpected EOF on %s\n", filename));
	  if (ferror(fp))
	    dprint(1, (debugfile, "** %s **\n", error_description(err)));
	} else if (ch == '\n') {
	  retcode = 1;
	} else if (fseek(fp, 0, 2) == -1) {
	  err = errno;
	  dprint(1, (debugfile, "fseek(0,2) failed on %s\n", filename));
	  dprint(1, (debugfile, "** %s **\n", error_description(err)));
	  fclose(fp);
	} else if (fputc('\n', fp) == EOF) {
	  err = errno;
	  dprint(1, (debugfile, "fputc('\\n') failed on %s\n", filename));
	  dprint(1, (debugfile, "** %s **\n", error_description(err)));
	} else {
	  retcode = 1;
	}

	fclose(fp);
	return retcode;
}

static int have_editor P_((char *editor));
static int have_editor(editor)
     char *editor;
{
    int return_value = 1;
    
    if (strcmp(editor,"none") == 0 || 
	editor[0] == '\0') {
	return_value = 0;
    }
    else if (editor[0] == '/') {
	char *test = safe_strdup(editor),*ptr;
	
	if (NULL != (ptr = strchr(test,' ')))
	    *ptr = '\0';
	
	dprint(5,(debugfile,"have_editor(%s) -- test=%s\n",
		  editor,test));
	
	if (-1 == access(test,EXECUTE_ACCESS)) {
	    int err = errno;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmEditCantExecute,
			      "Can't execute editor: %.50s: %.30s"),
		      test, error_description(err));
	    
	    dprint(5,(debugfile,"have_editor: no access %s: %s\n",test,
		      error_description(err)));
	    sleep_message();
	    return_value = 0;
	}
	free(test);

    }

    dprint(5,(debugfile,"have_editor=%d\n",return_value));
    return return_value;
}

int edit_the_message(filename, already_has_text, headers,
		     editor)
     char *filename;
     int  already_has_text;
     struct mailing_headers * headers;
     char *editor;
{
    /** Invoke the users editor on the filename.  Return when done. 
	If 'already has text' then we can't use the no-editor option
	and must use 'alternative editor' (e.g. $EDITOR or default_editor)
	instead... **/

    char buffer[SLEN];
    register int stat, return_value = 0, old_raw;
    int  err;
    
    buffer[0] = '\0';
    
    if (strcmp(editor, "builtin") == 0 || 
	strcmp(editor, "none") == 0 ||
	!have_editor(editor)) {
	 if (already_has_text && 
	     0 != strcmp(alternative_editor, "builtin") &&
	     0 != strcmp(alternative_editor, "none") &&
	     !have_editor(alternative_editor)) {

	     if (in_string(alternative_editor, "%s"))
		 elm_sfprintf(buffer, sizeof buffer,
			      FRM(alternative_editor), filename);
	     else
		 elm_sfprintf(buffer, sizeof buffer,
			      FRM("%s %s"), alternative_editor, filename);
	 } else
	     return(no_editor_edit_the_message(filename, headers));
    }

    PutLine0(elm_LINES, 0, catgets(elm_msg_cat, ElmSet, ElmInvokeEditor,
				   "Invoking editor..."));
    fflush(stdout);
    
    if (strlen(buffer) == 0) {
	if (in_string(editor, "%s"))
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM(editor), 
			 filename);
	else
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("%s %s"), 
			 editor, filename);
    }
	
    (void) elm_chown(filename, userid, groupid);
    
    if (( old_raw = RawState()) == ON)
	Raw(OFF);
    
    if ((stat = system_call(buffer, SY_ENAB_SIGHUP|SY_DUMPSTATE)) == -1) {
	err = errno;
	dprint(1,(debugfile, 
		  "System call failed with stat %d (edit_the_message)\n", 
		  stat));
	dprint(1, (debugfile, "** %s **\n", error_description(err)));
	ClearLine(elm_LINES-1);
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantInvokeEditor,
			  "Can't invoke editor '%s' for composition."), 
		  editor);
	if (sleepmsg > 0)
	    sleep(sleepmsg);
	return_value = 1;
    }
	
    enforce_newline(filename);
    
    if (old_raw == ON)
	Raw(ON);
    
    SetXYLocation(0, 40);	/* a location not near the next request, so an absolute is used */
    MoveCursor(elm_LINES, 0);	/* dont know where we are, force last row, col 0 */
    
    return(return_value);
}

static int no_editor_edit_the_message(filename,headers)
     char *filename;
     struct mailing_headers * headers;
{
	/** If the current editor is set to either "builtin" or "none", then
	    invoke this program instead.  As it turns out, this and the 
	    routine above have a pretty incestuous relationship (!)...
	**/

	FILE *edit_fd;
	char buffer[SLEN], editor_name[SLEN], buf[SLEN], wrap[SLEN];
	int      old_raw, is_wrapped = 0;
	SIGHAND_TYPE	edit_interrupt();
	SIGHAND_TYPE	(*oldint)(), (*oldquit)();
	int  err;

	/* The built-in editor is not re-entrant! */
	if (builtin_editor_active) {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmIntReentrantBuiltinEditor,
				    "\r\nInternal error - reentrant call to builtin editor attempted.\r\n\r\n"), 0);
	    dprint(1, (debugfile,
		       "Reentrant call to builtin editor for %s attempted\n", filename));
	    return(1);
	}

	if (simple_continue == NULL) {
		simple_continue = catgets(elm_msg_cat, ElmSet, ElmSimpleContinue,
		  "(Continue.)\n\r");
		post_ed_continue = catgets(elm_msg_cat, ElmSet, ElmPostEdContinue,
		  "(Continue entering message.  Type ^D or '.' on a line by itself to end.)\n\r");
	}

	if ((edit_fd = fopen(filename, "r+")) == NULL) {
	    err = errno;
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmCouldntOpenAppend,
				    "Couldn't open %s for update [%s]."),
			    filename, error_description(err));
	    
	    dprint(1, (debugfile,
		       "Error encountered trying to open file %s;\n", filename));
	    dprint(1, (debugfile, "** %s **\n", error_description(err)));
	    return(1);
	}

	/* Skip past any existing text */
	fseek(edit_fd, 0, SEEK_END);
	
	/** is there already text in this file? **/

	if (fsize(edit_fd) > 0L)
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmContinueEntering,
				    "\n\rContinue entering message."),
			    sizeof buf);
	else
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEnterMessage,
				    "\n\rEnter message."),
			    sizeof buf);
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmTypeElmCommands,
				"  Type Elm commands on lines by themselves.\n\r"),
			sizeof buf);
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmCommandsInclude,
				"Commands include:  ^D or '.' to end, %cp to list, %c? for help.\n\r\n\r"),
			escape_char, escape_char);
	CleartoEOS();
	

	oldint  = signal(SIGINT,  edit_interrupt);
	oldquit = signal(SIGQUIT, edit_interrupt);

	builtin_editor_active = TRUE;
	interrupts_while_editing = 0;

	if (SETJMP(edit_location) != 0) {
	    if (interrupts_while_editing > 1) {

		(void) signal(SIGINT,  oldint);
		(void) signal(SIGQUIT, oldquit);

		if (edit_fd != NULL)	/* insurance... */
		    fclose(edit_fd);
		builtin_editor_active = FALSE;
		return(1);
	    }
	    goto more_input;	/* read input again, please! */
	}
	
 more_input: buffer[0] = '\0';

	/*** Code changed to provide for line wrapping ***/
 wrap_input: wrap[0] = '\0';

	while (wrapped_enter(buffer, wrap, -1,-1, edit_fd, &is_wrapped,
			     sizeof buffer, sizeof wrap) == 0) {

	  if (is_wrapped) { /* No need to check for escape or break */
	      fprintf(edit_fd, "%s\n", buffer);
	      NewLine();
	      strfcpy(buffer,wrap, sizeof buffer);
	      goto wrap_input;
	  }

	  /*** End of changes for line wrapping ***/

	  interrupts_while_editing = 0;	/* reset to zero... */

	  if (strcmp(buffer, ".") == 0)
	    break;	/* '.' is as good as a ^D to us dumb programs :-) */
	  if (buffer[0] == escape_char) {
	      if (!isascii(buffer[0]))
		  goto error_message;

	      switch (tolower(buffer[1])) {
	      case '?' : tilde_help();
		  goto more_input;
		  
	      case TILDE_ESCAPE: move_left(buffer, 1); 
			  	 goto tilde_input;	/*!!*/

	      case 't' : get_addr_with_expansion("\n\rTo: ",
					       &headers->to, buffer);
	      goto more_input;
	      case 'b' : get_addr_with_expansion("\n\rBcc: ",
						 &headers->bcc, buffer);
	      goto more_input;
	      case 'c' : get_addr_with_expansion("\n\rCc: ",
						 &headers->cc, buffer);
	      goto more_input;
	      case 's' : get_text("\n\rSubject: ",
						 &headers->subject,buffer);
	      goto more_input;

	      case 'h' : 
		  get_addr_with_expansion("\n\rTo: ", 
					  &headers->to, NULL);
		  get_addr_with_expansion("Cc: ", 
					  &headers->cc, NULL);
		  get_addr_with_expansion("Bcc: ", 
					  &headers->bcc,NULL);
		  get_text("Subject: ", 
			   &headers->subject, NULL);
		  goto more_input;

	      case 'r' : read_in_file(edit_fd, (char *) buffer + 2, 1);
		  goto more_input;

	      case 'e' : 
		  if (strlen(e_editor) > 0 || 
		      0 != strcmp(e_editor,"none")) 
		      if (have_editor(e_editor)) {
			  fclose(edit_fd);
			  (void) edit_the_message(filename,0,headers,
						  e_editor);
			  edit_fd = fopen(filename, "a+");
			  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						  ElmPostEdContinue,
						  "(Continue entering message.  Type ^D or '.' on a line by itself to end.)\n\r"));
			  goto more_input;
		      }
		      else
			  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						  ElmCantFindEmacs,
						  "\n\r(Can't find Emacs on this system! Continue.)\n\r"));
		  else
		      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					      ElmDontKnowEmacs,
					      "\n\r(Don't know where Emacs would be. Continue.)\n\r"));	
		  goto more_input;
		  
	      case 'v' : NewLine();
		  if (have_editor(v_editor)) {
		      fclose(edit_fd);
		      (void) edit_the_message(filename,0,headers,v_editor);
		      edit_fd = fopen(filename, "a+");
		  }
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					  ElmPostEdContinue,
					  "(Continue entering message.  Type ^D or '.' on a line by itself to end.)\n\r"));
		  goto more_input;


	      case 'o' : 
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEnterNameEditor,
					  "\n\rPlease enter the name of the editor: "));
		  editor_name[0] = '\0';
		  if (optionally_enter(editor_name,-1,-1, 0,
				       sizeof editor_name) != 0) {
		      NewLine();
		      goto more_input;
		  }
		  
		  NewLine();
		  if (strlen(editor_name) > 0 &&
		      have_editor(editor_name)) {
		      fclose(edit_fd);
		      (void) edit_the_message(filename,0,headers,editor_name);
		      edit_fd = fopen(filename, "a+");
		      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					      ElmPostEdContinue,
					      "(Continue entering message.  Type ^D or '.' on a line by itself to end.)\n\r"));
		      goto more_input;
		  }
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					  ElmSimpleContinue,
					  "(Continue.)\n\r"));
		  goto more_input; 
		case '<' : 
		    NewLine();
		    if (strlen(buffer) < 3)
			Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						ElmUseSpecificCommand,
						"(You need to use a specific command here. Continue.)\n\r"));
		    else {
			elm_sfprintf(buf, sizeof buf,
				     FRM(" > %s%s.%d 2>)&1"), 
				     temp_dir, temp_edit, getpid());
			strfcat(buffer, buf, sizeof buffer);
			if (( old_raw = RawState()) == ON)
			    Raw(OFF);
			(void) system_call((char *) buffer+2, SY_ENAB_SIGINT|SY_DUMPSTATE);
			if (old_raw == ON)
			    Raw(ON);
			elm_sfprintf(buffer, sizeof buffer,
				     FRM("~r %s%s.%d"), 
				     temp_dir, temp_edit, getpid());
			read_in_file(edit_fd, (char *) buffer + 3, 0);
			(void) unlink((char *) buffer+3);
			SetXYLocation(0, 40);	/* a location not near the next request, so an absolute is used */
			MoveCursor(elm_LINES, 0);	/* and go to a known location, last row col 0 */
			   }
		    goto more_input; 
		    
	      case '!' : 
		  NewLine();
		  if (( old_raw = RawState()) == ON)
		      Raw(OFF);
		  (void) system_call((strlen(buffer) < 3 ? (char *)NULL : buffer+2),
				     SY_USER_SHELL|SY_ENAB_SIGINT|SY_DUMPSTATE);
		  if (old_raw == ON)
		      Raw(ON);
		  SetXYLocation(0, 40);	/* a location not near the next request, so an absolute is used */
		  MoveCursor(elm_LINES, 0);	/* and go to a known location, last row col 0 */
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					  ElmSimpleContinue,
					  "(Continue.)\n\r"));
		  goto more_input;

	      case 'm' : /* same as 'f' but with leading prefix added */

	      case 'f' : /* this can be directly translated into a
			    'readmsg' call with the same params! */
		  NewLine();
		  read_in_messages(edit_fd, (char *) buffer + 1);
		  goto more_input;

	      case 'p' : /* print out message so far.  Soooo simple! */
		  print_message_so_far(edit_fd, filename,
				       headers);
		  goto more_input;

	      default  : 
	      error_message:
	      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
				      ElmDontKnowChar,
				      "\n\r(Don't know what %c%c is. Try %c? for help.)\n\r"),
			      escape_char, buffer[1], escape_char);
	      
	      }
	  }
	  else {
	  tilde_input:
	      fprintf(edit_fd, "%s\n", buffer);
	      NewLine();
	  }
	  buffer[0] = '\0';
	}


	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmEndOfMessage,
				"\n\r<end-of-message>\n\r\n\r\n\r\n\r"));

	(void) signal(SIGINT,  oldint);
	(void) signal(SIGQUIT, oldquit);
	
	if (edit_fd != NULL)	/* insurance... */
	    fclose(edit_fd);

	builtin_editor_active = FALSE;
	return(0);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
