#!/usr/local/bin/python

""" Helper script to path the VC generated Makefile and execute
    NMAKE.

    Copyright (c) 2000, Marc-Andre Lemburg; mailto:mal@lemburg.com
    Copyright (c) 2000-2003, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further copyright information or contact
    the author.

"""

import sys,os,re,string

def make(projectname,configuration='Release',*args):

    # Edit Makefile
    makefile = open(projectname + '.mak','rb').read()
    makefile = re.sub('CPP_PROJ=(.*) /O2(?! /Gf)',
                      'CPP_PROJ=\\1 /O2 /Gf /GB /GD',
                      makefile)
    open(projectname + '.mak','wb').write(makefile)

    # Call NMAKE
    os.system('nmake /nologo /c /f "%s.mak" CFG="%s - Win32 %s" %s' %
              (projectname,projectname,configuration,string.join(args)))

if __name__ == '__main__':
    try:
        apply(make,tuple(sys.argv[1:]))
    except TypeError:
        print "vcmake.py <projectname> <configuration> [<maketarget>]"
        print
        print "Example: vcmake.py mxODBC Release"
        print
        sys.exit(1)

