@echo off

REM reset ant command line in environment and variables
set ws=
set os=
set arch=
set target=
set ANT_CMD_LINE_ARGS=
set bootclasspath=%JAVA_HOME%\jre\lib\rt.jar
set ANT_OPTS=-Xmx768m

if x%1==x goto usage

REM process all command line parameters
:loop
if x%1==x goto checkvars
if x%1==x-os set os=%2
if x%1==x-ws set ws=%2
if x%1==x-arch set arch=%2
if x%1==x-bc set bootclasspath=%2
if x%1==x-target set target=%2
shift
goto loop

REM verify that ws and os values and combinations are valid
:checkvars
if x%os%==x goto usage
if x%ws%==x goto usage
if x%arch%==x goto usage

if %os%-%ws%-%arch%==win32-win32-x86 goto run
if %os%-%ws%-%arch%==linux-motif-x86 goto run
if %os%-%ws%-%arch%==linux-gtk-x86 goto run
if %os%-%ws%-%arch%==linux-gtk-amd64 goto run
if %os%-%ws%-%arch%==linux-gtk-ia64 goto run
if %os%-%ws%-%arch%==solaris-motif-sparc goto run
if %os%-%ws%-%arch%==aix-motif-ppc goto run
if %os%-%ws%-%arch%==hpux-motif-PA_RISC goto run
if %os%-%ws%-%arch%==qnx-photon-x86 goto run
if %os%-%ws%-%arch%==linux-gtk-ppc goto run
if %os%-%ws%-%arch%==macosx-carbon-ppc goto run

ECHO The ws os arch combination entered is not valid.
goto end

:usage
ECHO "usage %0 -os <osType> -ws <windowingSystem> -arch <architecture> [-bc bootclasspath] [-target target]"
goto end

:run
REM must pass in javacTarget property value as workaround for bug #42393
ant -buildfile build.xml %target% -DinstallOs=%os% -DinstallWs=%ws% -DinstallArch=%arch% -Dbootclasspath=%bootclasspath% -DjavacTarget=1.2
goto end

:end
