/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.FieldData;
import org.eclipse.swt.tools.internal.JNIGenerator;

public class StructsGenerator
extends JNIGenerator {
    static /* synthetic */ Class class$0;

    public void generate(Class clazz) {
        this.generateHeaderFile(clazz);
        this.generateSourceFile(clazz);
    }

    public void generateExcludes(Class[] classes) {
        HashSet<String> excludes = new HashSet<String>();
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = this.getMetaData().getMetaData(clazz);
            String exclude = classData.getExclude();
            if (exclude.length() != 0) {
                excludes.add(exclude);
            }
            ++i;
        }
        Iterator iter = excludes.iterator();
        while (iter.hasNext()) {
            String exclude = (String)iter.next();
            this.output(exclude);
            this.outputDelimiter();
            int i2 = 0;
            while (i2 < classes.length) {
                Class clazz = classes[i2];
                ClassData classData = this.getMetaData().getMetaData(clazz);
                String classExclude = classData.getExclude();
                if (exclude.equals(classExclude)) {
                    this.output("#define NO_");
                    this.output(JNIGenerator.getClassName(clazz));
                    this.outputDelimiter();
                }
                ++i2;
            }
            this.output("#endif");
            this.outputDelimiter();
            this.outputDelimiter();
        }
    }

    public void generateHeaderFile(Class clazz) {
        this.generateSourceStart(clazz);
        this.generatePrototypes(clazz);
        this.generateBlankMacros(clazz);
        this.generateSourceEnd(clazz);
        this.outputDelimiter();
    }

    public void generateHeaderFile(Class[] classes) {
        if (classes.length == 0) {
            return;
        }
        JNIGenerator.sort(classes);
        this.generateMetaData("swt_copyright");
        this.generateMetaData("swt_includes");
        this.generateExcludes(classes);
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = this.getMetaData().getMetaData(clazz);
            if (!classData.getFlag("no_gen")) {
                this.generateHeaderFile(clazz);
            }
            ++i;
        }
    }

    public void generateSourceFile(Class clazz) {
        this.generateSourceStart(clazz);
        this.generateFIDsStructure(clazz);
        this.outputDelimiter();
        this.generateGlobalVar(clazz);
        this.outputDelimiter();
        this.generateFunctions(clazz);
        this.generateSourceEnd(clazz);
        this.outputDelimiter();
    }

    public void generateSourceFile(Class[] classes) {
        if (classes.length == 0) {
            return;
        }
        JNIGenerator.sort(classes);
        this.generateMetaData("swt_copyright");
        this.generateMetaData("swt_includes");
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = this.getMetaData().getMetaData(clazz);
            if (!classData.getFlag("no_gen")) {
                this.generateSourceFile(clazz);
            }
            ++i;
        }
    }

    void generateSourceStart(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output("#ifndef NO_");
        this.output(clazzName);
        this.outputDelimiter();
    }

    void generateSourceEnd(Class clazz) {
        this.output("#endif");
        this.outputDelimiter();
    }

    void generateGlobalVar(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output(clazzName);
        this.output("_FID_CACHE ");
        this.output(clazzName);
        this.output("Fc;");
        this.outputDelimiter();
    }

    void generateBlankMacros(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output("#else");
        this.outputDelimiter();
        this.output("#define cache");
        this.output(clazzName);
        this.output("Fields(a,b)");
        this.outputDelimiter();
        this.output("#define get");
        this.output(clazzName);
        this.output("Fields(a,b,c) NULL");
        this.outputDelimiter();
        this.output("#define set");
        this.output(clazzName);
        this.output("Fields(a,b,c)");
        this.outputDelimiter();
        this.output("#define ");
        this.output(clazzName);
        this.output("_sizeof() 0");
        this.outputDelimiter();
    }

    void generatePrototypes(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output("void cache");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject);");
        this.outputDelimiter();
        this.output(clazzName);
        this.output(" *get");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.output(" *lpStruct);");
        this.outputDelimiter();
        this.output("void set");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.output(" *lpStruct);");
        this.outputDelimiter();
        this.output("#define ");
        this.output(clazzName);
        this.output("_sizeof() sizeof(");
        this.output(clazzName);
        this.output(")");
        this.outputDelimiter();
    }

    void generateFIDsStructure(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output("typedef struct ");
        this.output(clazzName);
        this.output("_FID_CACHE {");
        this.outputDelimiter();
        this.output("\tint cached;");
        this.outputDelimiter();
        this.output("\tjclass clazz;");
        this.outputDelimiter();
        this.output("\tjfieldID ");
        Field[] fields = clazz.getDeclaredFields();
        boolean first = true;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                if (!first) {
                    this.output(", ");
                }
                this.output(field.getName());
                first = false;
            }
            ++i;
        }
        this.output(";");
        this.outputDelimiter();
        this.output("} ");
        this.output(clazzName);
        this.output("_FID_CACHE;");
        this.outputDelimiter();
    }

    void generateCacheFunction(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output("void cache");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject)");
        this.outputDelimiter();
        this.output("{");
        this.outputDelimiter();
        this.output("\tif (");
        this.output(clazzName);
        this.output("Fc.cached) return;");
        this.outputDelimiter();
        Class superclazz = clazz.getSuperclass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (superclazz != clazz2) {
            String superName = JNIGenerator.getClassName(superclazz);
            this.output("\tcache");
            this.output(superName);
            this.output("Fields(env, lpObject);");
            this.outputDelimiter();
        }
        this.output("\t");
        this.output(clazzName);
        this.output("Fc.clazz = (*env)->GetObjectClass(env, lpObject);");
        this.outputDelimiter();
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                this.output("\t");
                this.output(clazzName);
                this.output("Fc.");
                this.output(field.getName());
                this.output(" = (*env)->GetFieldID(env, ");
                this.output(clazzName);
                this.output("Fc.clazz, \"");
                this.output(field.getName());
                this.output("\", \"");
                this.output(JNIGenerator.getTypeSignature(field));
                this.output("\");");
                this.outputDelimiter();
            }
            ++i;
        }
        this.output("\t");
        this.output(clazzName);
        this.output("Fc.cached = 1;");
        this.outputDelimiter();
        this.output("}");
        this.outputDelimiter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateGetFields(Class clazz) {
        Class superclazz = clazz.getSuperclass();
        String clazzName = JNIGenerator.getClassName(clazz);
        String superName = JNIGenerator.getClassName(superclazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (superclazz != clazz2) {
            if (!clazzName.equals(String.valueOf(superName) + "A") && !clazzName.equals(String.valueOf(superName) + "W")) {
                this.output("\tget");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.output(" *)lpStruct);");
                this.outputDelimiter();
            } else {
                this.generateGetFields(superclazz);
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                boolean noWinCE;
                FieldData fieldData = this.getMetaData().getMetaData(field);
                String exclude = fieldData.getExclude();
                if (exclude.length() != 0) {
                    this.output(exclude);
                    this.outputDelimiter();
                }
                if (noWinCE = fieldData.getFlag("no_wince")) {
                    this.output("#ifndef _WIN32_WCE");
                    this.outputDelimiter();
                }
                Class<?> type = field.getType();
                String typeName = JNIGenerator.getClassName(type);
                String accessor = fieldData.getAccessor();
                if (accessor == null || accessor.length() == 0) {
                    accessor = field.getName();
                }
                if (type.isPrimitive()) {
                    this.output("\tlpStruct->");
                    this.output(accessor);
                    this.output(" = ");
                    this.output(fieldData.getCast());
                    this.output("(*env)->Get");
                    this.output(JNIGenerator.getTypeSignature1(field));
                    this.output("Field(env, lpObject, ");
                    this.output(JNIGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                } else if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.output("\t{");
                    this.outputDelimiter();
                    this.output("\t");
                    this.output(JNIGenerator.getTypeSignature2(field));
                    this.output(" lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    this.output(JNIGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\t(*env)->Get");
                    this.output(JNIGenerator.getTypeSignature1(componentType));
                    this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                    this.output(accessor);
                    this.output(")");
                    int byteCount = JNIGenerator.getByteCount(componentType);
                    if (byteCount > 1) {
                        this.output(" / ");
                        this.output(String.valueOf(byteCount));
                    }
                    this.output(", (void *)lpStruct->");
                    this.output(accessor);
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\t}");
                } else {
                    this.output("\t{");
                    this.outputDelimiter();
                    this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    this.output(JNIGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\tget");
                    this.output(typeName);
                    this.output("Fields(env, lpObject1, &lpStruct->");
                    this.output(accessor);
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\t}");
                }
                this.outputDelimiter();
                if (noWinCE) {
                    this.output("#endif");
                    this.outputDelimiter();
                }
                if (exclude.length() != 0) {
                    this.output("#endif");
                    this.outputDelimiter();
                }
            }
            ++i;
        }
    }

    void generateGetFunction(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output(clazzName);
        this.output(" *get");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.output(" *lpStruct)");
        this.outputDelimiter();
        this.output("{");
        this.outputDelimiter();
        this.output("\tif (!");
        this.output(clazzName);
        this.output("Fc.cached) cache");
        this.output(clazzName);
        this.output("Fields(env, lpObject);");
        this.outputDelimiter();
        this.generateGetFields(clazz);
        this.output("\treturn lpStruct;");
        this.outputDelimiter();
        this.output("}");
        this.outputDelimiter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateSetFields(Class clazz) {
        Class superclazz = clazz.getSuperclass();
        String clazzName = JNIGenerator.getClassName(clazz);
        String superName = JNIGenerator.getClassName(superclazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (superclazz != clazz2) {
            if (!clazzName.equals(String.valueOf(superName) + "A") && !clazzName.equals(String.valueOf(superName) + "W")) {
                this.output("\tset");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.output(" *)lpStruct);");
                this.outputDelimiter();
            } else {
                this.generateSetFields(superclazz);
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                boolean noWinCE;
                FieldData fieldData = this.getMetaData().getMetaData(field);
                String exclude = fieldData.getExclude();
                if (exclude.length() != 0) {
                    this.output(exclude);
                    this.outputDelimiter();
                }
                if (noWinCE = fieldData.getFlag("no_wince")) {
                    this.output("#ifndef _WIN32_WCE");
                    this.outputDelimiter();
                }
                Class<?> type = field.getType();
                String typeName = JNIGenerator.getClassName(type);
                String accessor = fieldData.getAccessor();
                if (accessor == null || accessor.length() == 0) {
                    accessor = field.getName();
                }
                if (type.isPrimitive()) {
                    this.output("\t(*env)->Set");
                    this.output(JNIGenerator.getTypeSignature1(field));
                    this.output("Field(env, lpObject, ");
                    this.output(JNIGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(", (");
                    this.output(JNIGenerator.getTypeSignature2(field));
                    this.output(")lpStruct->");
                    this.output(accessor);
                    this.output(");");
                } else if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.output("\t{");
                    this.outputDelimiter();
                    this.output("\t");
                    this.output(JNIGenerator.getTypeSignature2(field));
                    this.output(" lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    this.output(JNIGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\t(*env)->Set");
                    this.output(JNIGenerator.getTypeSignature1(componentType));
                    this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                    this.output(accessor);
                    this.output(")");
                    int byteCount = JNIGenerator.getByteCount(componentType);
                    if (byteCount > 1) {
                        this.output(" / ");
                        this.output(String.valueOf(byteCount));
                    }
                    this.output(", (void *)lpStruct->");
                    this.output(accessor);
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\t}");
                } else {
                    this.output("\t{");
                    this.outputDelimiter();
                    this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    this.output(JNIGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\tset");
                    this.output(typeName);
                    this.output("Fields(env, lpObject1, &lpStruct->");
                    this.output(accessor);
                    this.output(");");
                    this.outputDelimiter();
                    this.output("\t}");
                }
                this.outputDelimiter();
                if (noWinCE) {
                    this.output("#endif");
                    this.outputDelimiter();
                }
                if (exclude.length() != 0) {
                    this.output("#endif");
                    this.outputDelimiter();
                }
            }
            ++i;
        }
    }

    void generateSetFunction(Class clazz) {
        String clazzName = JNIGenerator.getClassName(clazz);
        this.output("void set");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.output(" *lpStruct)");
        this.outputDelimiter();
        this.output("{");
        this.outputDelimiter();
        this.output("\tif (!");
        this.output(clazzName);
        this.output("Fc.cached) cache");
        this.output(clazzName);
        this.output("Fields(env, lpObject);");
        this.outputDelimiter();
        this.generateSetFields(clazz);
        this.output("}");
        this.outputDelimiter();
    }

    void generateFunctions(Class clazz) {
        this.generateCacheFunction(clazz);
        this.outputDelimiter();
        this.generateGetFunction(clazz);
        this.outputDelimiter();
        this.generateSetFunction(clazz);
    }

    boolean ignoreField(Field field) {
        int mods = field.getModifiers();
        return (mods & 1) == 0 || (mods & 0x10) != 0 || (mods & 8) != 0;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java StructsGenerator <className1> <className2>");
            return;
        }
        try {
            StructsGenerator gen = new StructsGenerator();
            int i = 0;
            while (i < args.length) {
                String clazzName = args[i];
                Class<?> clazz = Class.forName(clazzName);
                gen.generate(clazz);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

