/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.JNIGenerator;

public class StatsGenerator
extends JNIGenerator {
    public void generate(Class clazz) {
        this.generateHeaderFile(clazz);
        this.generateSourceFile(clazz);
    }

    public void generate(Method[] methods) {
        JNIGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generateStringArray(method);
            }
            ++i;
        }
    }

    public void generateHeaderFile(Class clazz) {
        this.generateNATIVEMacros(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        this.generateHeaderFile(methods);
    }

    public void generateHeaderFile(Class[] classes) {
        if (classes.length == 0) {
            return;
        }
        JNIGenerator.sort(classes);
        this.generateMetaData("swt_copyright");
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = this.getMetaData().getMetaData(clazz);
            if (!classData.getFlag("no_gen")) {
                this.generateHeaderFile(clazz);
            }
            ++i;
        }
    }

    void generateNATIVEMacros(Class clazz) {
        String className = JNIGenerator.getClassName(clazz);
        this.output("#ifdef NATIVE_STATS");
        this.outputDelimiter();
        this.output("int ");
        this.output(className);
        this.output("_nativeFunctionCallCount[];");
        this.outputDelimiter();
        this.output("char* ");
        this.output(className);
        this.output("_nativeFunctionNames[];");
        this.outputDelimiter();
        this.output("#define ");
        this.output(className);
        this.output("_NATIVE_ENTER(env, that, func) ");
        this.output(className);
        this.output("_nativeFunctionCallCount[func]++;");
        this.outputDelimiter();
        this.output("#define ");
        this.output(className);
        this.output("_NATIVE_EXIT(env, that, func) ");
        this.outputDelimiter();
        this.output("#else");
        this.outputDelimiter();
        this.output("#define ");
        this.output(className);
        this.output("_NATIVE_ENTER(env, that, func) ");
        this.outputDelimiter();
        this.output("#define ");
        this.output(className);
        this.output("_NATIVE_EXIT(env, that, func) ");
        this.outputDelimiter();
        this.output("#endif");
        this.outputDelimiter();
        this.outputDelimiter();
    }

    public void generateHeaderFile(Method[] methods) {
        JNIGenerator.sort(methods);
        this.generateDefines(methods);
    }

    public void generateSourceFile(Class[] classes) {
        if (classes.length == 0) {
            return;
        }
        JNIGenerator.sort(classes);
        this.generateMetaData("swt_copyright");
        this.generateMetaData("swt_includes");
        this.output("#ifdef NATIVE_STATS");
        this.outputDelimiter();
        this.outputDelimiter();
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = this.getMetaData().getMetaData(clazz);
            if (!classData.getFlag("no_gen")) {
                this.generateSourceFile(clazz);
            }
            ++i;
        }
        this.outputDelimiter();
        this.output("#endif");
        this.outputDelimiter();
    }

    public void generateSourceFile(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        int methodCount = 0;
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                ++methodCount;
            }
            ++i;
        }
        String className = JNIGenerator.getClassName(clazz);
        this.output("int ");
        this.output(className);
        this.output("_nativeFunctionCount = ");
        this.output(String.valueOf(methodCount));
        this.output(";");
        this.outputDelimiter();
        this.output("int ");
        this.output(className);
        this.output("_nativeFunctionCallCount[");
        this.output(String.valueOf(methodCount));
        this.output("];");
        this.outputDelimiter();
        this.output("char * ");
        this.output(className);
        this.output("_nativeFunctionNames[] = {");
        this.outputDelimiter();
        this.generate(methods);
        this.output("};");
        this.outputDelimiter();
    }

    void generateStringArray(Method method) {
        this.output("\t\"" + JNIGenerator.getFunctionName(method) + "\", ");
        this.outputDelimiter();
    }

    void generateDefines(Method[] methods) {
        int methodCount = 0;
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.output("#define " + JNIGenerator.getFunctionName(method) + "_FUNC " + methodCount);
                ++methodCount;
                this.outputDelimiter();
            }
            ++i;
        }
    }
}

