/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.MethodData;
import org.eclipse.swt.tools.internal.ParameterData;

public class NativesGenerator
extends JNIGenerator {
    boolean nativeMacro = true;
    boolean enterExitMacro = true;
    static /* synthetic */ Class class$0;

    public void generate(Class clazz, String methodName) {
        Method[] methods = clazz.getDeclaredMethods();
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith(methodName)) {
                ++count;
            }
            ++i;
        }
        Method[] result = new Method[count];
        count = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2].getName().startsWith(methodName)) {
                result[count++] = methods[i2];
            }
            ++i2;
        }
        this.generate(result);
    }

    public void generate(Class clazz) {
        ClassData classData = this.getMetaData().getMetaData(clazz);
        if (classData.getFlag("no_gen")) {
            return;
        }
        this.generateMetaData("swt_copyright");
        this.generateMetaData("swt_includes");
        this.generateNativeMacro(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        this.generateExcludes(methods);
        this.generate(methods);
    }

    public void generateExcludes(Method[] methods) {
        JNIGenerator.sort(methods);
        HashSet<String> excludes = new HashSet<String>();
        int i = 0;
        while (i < methods.length) {
            MethodData methodData;
            String exclude;
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0 && (exclude = (methodData = this.getMetaData().getMetaData(method)).getExclude()).length() != 0) {
                excludes.add(exclude);
            }
            ++i;
        }
        Iterator iter = excludes.iterator();
        while (iter.hasNext()) {
            String exclude = (String)iter.next();
            this.output(exclude);
            this.outputDelimiter();
            int i2 = 0;
            while (i2 < methods.length) {
                MethodData methodData;
                String methodExclude;
                Method method = methods[i2];
                if ((method.getModifiers() & 0x100) != 0 && exclude.equals(methodExclude = (methodData = this.getMetaData().getMetaData(method)).getExclude())) {
                    this.output("#define NO_");
                    this.output(JNIGenerator.getFunctionName(method));
                    this.outputDelimiter();
                }
                ++i2;
            }
            this.output("#endif");
            this.outputDelimiter();
            this.outputDelimiter();
        }
    }

    public void generate(Method[] methods) {
        JNIGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++i;
        }
    }

    public void generate(Method method) {
        MethodData methodData = this.getMetaData().getMetaData(method);
        if (methodData.getFlag("no_gen")) {
            return;
        }
        Class<?> returnType = method.getReturnType();
        Class[] paramTypes = method.getParameterTypes();
        String function = JNIGenerator.getFunctionName(method);
        if (returnType != Void.TYPE && !returnType.isPrimitive()) {
            this.output("Warnning: bad return type. :" + method);
            this.outputDelimiter();
            return;
        }
        this.generateSourceStart(function);
        this.generateFunctionPrototype(method, function, paramTypes, returnType);
        this.generateFunctionBody(method, methodData, function, paramTypes, returnType);
        this.generateSourceEnd(function);
        this.outputDelimiter();
    }

    public void setEnterExitMacro(boolean enterExitMacro) {
        this.enterExitMacro = enterExitMacro;
    }

    public void setNativeMacro(boolean nativeMacro) {
        this.nativeMacro = nativeMacro;
    }

    void generateNativeMacro(Class clazz) {
        this.output("#define ");
        this.output(JNIGenerator.getClassName(clazz));
        this.output("_NATIVE(func) Java_");
        this.output(JNIGenerator.toC(clazz.getName()));
        this.output("_##func");
        this.outputDelimiter();
        this.outputDelimiter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateGetParameter(int i, Class paramType, ParameterData paramData, boolean critical) {
        if (paramType.isPrimitive()) {
            return;
        }
        this.output("\tif (arg" + i);
        this.output(") lparg" + i);
        this.output(" = ");
        if (paramType.isArray()) {
            Class<?> componentType = paramType.getComponentType();
            if (!componentType.isPrimitive()) throw new Error("not done");
            if (critical) {
                this.output("(*env)->GetPrimitiveArrayCritical(env, arg" + i);
                this.output(", NULL);");
            } else {
                this.output("(*env)->Get");
                this.output(JNIGenerator.getTypeSignature1(componentType));
                this.output("ArrayElements(env, arg" + i);
                this.output(", NULL);");
            }
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (paramType == clazz) {
                if (paramData.getFlag("unicode")) {
                    this.output("(*env)->GetStringChars(env, arg" + i);
                    this.output(", NULL);");
                } else {
                    this.output("(*env)->GetStringUTFChars(env, arg" + i);
                    this.output(", NULL);");
                }
            } else if (paramData.getFlag("no_in")) {
                this.output("&_arg" + i);
                this.output(";");
            } else {
                this.output("get");
                this.output(JNIGenerator.getClassName(paramType));
                this.output("Fields(env, arg" + i);
                this.output(", &_arg" + i);
                this.output(");");
            }
        }
        this.outputDelimiter();
    }

    void generateSetParameter(int i, Class paramType, ParameterData paramData, boolean critical) {
        if (paramType.isPrimitive()) {
            return;
        }
        if (paramType.isArray()) {
            this.output("\tif (arg" + i);
            this.output(") ");
            Class<?> componentType = paramType.getComponentType();
            if (componentType.isPrimitive()) {
                if (critical) {
                    this.output("(*env)->ReleasePrimitiveArrayCritical(env, arg" + i);
                } else {
                    this.output("(*env)->Release");
                    this.output(JNIGenerator.getTypeSignature1(componentType));
                    this.output("ArrayElements(env, arg" + i);
                }
                this.output(", lparg" + i);
                this.output(", ");
                if (paramData.getFlag("no_out")) {
                    this.output("JNI_ABORT");
                } else {
                    this.output("0");
                }
            } else {
                throw new Error("not done");
            }
            this.output(");");
            this.outputDelimiter();
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (paramType == clazz) {
                this.output("\tif (arg" + i);
                this.output(") ");
                if (paramData.getFlag("unicode")) {
                    this.output("(*env)->ReleaseStringChars(env, arg" + i);
                } else {
                    this.output("(*env)->ReleaseStringUTFChars(env, arg" + i);
                }
                this.output(", lparg" + i);
                this.output(");");
                this.outputDelimiter();
            } else if (!paramData.getFlag("no_out")) {
                this.output("\tif (arg" + i);
                this.output(") ");
                this.output("set");
                this.output(JNIGenerator.getClassName(paramType));
                this.output("Fields(env, arg" + i);
                this.output(", lparg" + i);
                this.output(");");
                this.outputDelimiter();
            }
        }
    }

    void generateExitMacro(Method method, String function) {
        if (!this.enterExitMacro) {
            return;
        }
        this.output("\t");
        this.output(JNIGenerator.getClassName(method.getDeclaringClass()));
        this.output("_NATIVE_EXIT(env, that, ");
        this.output(function);
        this.output("_FUNC);");
        this.outputDelimiter();
    }

    void generateEnterMacro(Method method, String function) {
        if (!this.enterExitMacro) {
            return;
        }
        this.output("\t");
        this.output(JNIGenerator.getClassName(method.getDeclaringClass()));
        this.output("_NATIVE_ENTER(env, that, ");
        this.output(function);
        this.output("_FUNC);");
        this.outputDelimiter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateLocalVars(Method method, Class[] paramTypes, Class returnType) {
        boolean needsReturn = this.enterExitMacro;
        int i = 0;
        while (i < paramTypes.length) {
            Class paramType = paramTypes[i];
            if (!paramType.isPrimitive()) {
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                this.output("\t");
                if (paramType.isArray()) {
                    Class<?> componentType = paramType.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.output(JNIGenerator.getTypeSignature2(componentType));
                    this.output(" *lparg" + i);
                    this.output("=NULL;");
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (paramType == clazz) {
                        if (paramData.getFlag("unicode")) {
                            this.output("const jchar *lparg" + i);
                        } else {
                            this.output("const jbyte *lparg" + i);
                        }
                        this.output("= NULL;");
                    } else {
                        this.output(JNIGenerator.getClassName(paramType));
                        this.output(" _arg" + i);
                        if (paramData.getFlag("init")) {
                            this.output("={0}");
                        }
                        this.output(", *lparg" + i);
                        this.output("=NULL;");
                    }
                }
                this.outputDelimiter();
                needsReturn = true;
            }
            ++i;
        }
        if (!needsReturn || returnType == Void.TYPE) return needsReturn;
        this.output("\t");
        this.output(JNIGenerator.getTypeSignature2(returnType));
        this.output(" rc;");
        this.outputDelimiter();
        return needsReturn;
    }

    void generateGetters(Method method, Class[] paramTypes) {
        ParameterData paramData;
        Class paramType;
        int criticalCount = 0;
        int i = 0;
        while (i < paramTypes.length) {
            paramType = paramTypes[i];
            paramData = this.getMetaData().getMetaData(method, i);
            if (!this.isCritical(paramType, paramData)) {
                this.generateGetParameter(i, paramType, paramData, false);
            } else {
                ++criticalCount;
            }
            ++i;
        }
        if (criticalCount != 0) {
            this.output("#ifdef JNI_VERSION_1_2");
            this.outputDelimiter();
            this.output("\tif (IS_JNI_1_2) {");
            this.outputDelimiter();
            i = 0;
            while (i < paramTypes.length) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    this.output("\t");
                    this.generateGetParameter(i, paramType, paramData, true);
                }
                ++i;
            }
            this.output("\t} else");
            this.outputDelimiter();
            this.output("#endif");
            this.outputDelimiter();
            this.output("\t{");
            this.outputDelimiter();
            i = 0;
            while (i < paramTypes.length) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    this.output("\t");
                    this.generateGetParameter(i, paramType, paramData, false);
                }
                ++i;
            }
            this.output("\t}");
            this.outputDelimiter();
        }
    }

    void generateSetters(Method method, Class[] paramTypes) {
        ParameterData paramData;
        Class paramType;
        int criticalCount = 0;
        int i = paramTypes.length - 1;
        while (i >= 0) {
            paramType = paramTypes[i];
            paramData = this.getMetaData().getMetaData(method, i);
            if (this.isCritical(paramType, paramData)) {
                ++criticalCount;
            }
            --i;
        }
        if (criticalCount != 0) {
            this.output("#ifdef JNI_VERSION_1_2");
            this.outputDelimiter();
            this.output("\tif (IS_JNI_1_2) {");
            this.outputDelimiter();
            i = paramTypes.length - 1;
            while (i >= 0) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    this.output("\t");
                    this.generateSetParameter(i, paramType, paramData, true);
                }
                --i;
            }
            this.output("\t} else");
            this.outputDelimiter();
            this.output("#endif");
            this.outputDelimiter();
            this.output("\t{");
            this.outputDelimiter();
            i = paramTypes.length - 1;
            while (i >= 0) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    this.output("\t");
                    this.generateSetParameter(i, paramType, paramData, false);
                }
                --i;
            }
            this.output("\t}");
            this.outputDelimiter();
        }
        i = paramTypes.length - 1;
        while (i >= 0) {
            paramType = paramTypes[i];
            paramData = this.getMetaData().getMetaData(method, i);
            if (!this.isCritical(paramType, paramData)) {
                this.generateSetParameter(i, paramType, paramData, false);
            }
            --i;
        }
    }

    void generateDynamicFunctionCall(Method method, MethodData methodData, Class[] paramTypes, Class returnType, boolean needsReturn) {
        this.output("/*");
        this.outputDelimiter();
        this.generateFunctionCall(method, methodData, paramTypes, returnType, needsReturn);
        this.output("*/");
        this.outputDelimiter();
        this.output("\t");
        this.output("{");
        this.outputDelimiter();
        if (this.getPlatform().equals("win32")) {
            this.output("\t\tstatic int initialized = 0;");
            this.outputDelimiter();
            this.output("\t\tstatic HMODULE hm = NULL;");
            this.outputDelimiter();
            this.output("\t\tstatic FARPROC fp = NULL;");
            this.outputDelimiter();
            if (returnType != Void.TYPE && needsReturn) {
                this.output("\t\trc = 0;");
                this.outputDelimiter();
            }
            this.output("\t\tif (!initialized) {");
            this.outputDelimiter();
            this.output("\t\t\tif (!(hm = GetModuleHandle(");
            this.output(method.getName());
            this.output("_LIB))) hm = LoadLibrary(");
            this.output(method.getName());
            this.output("_LIB);");
            this.outputDelimiter();
            this.output("\t\t\tif (hm) fp = GetProcAddress(hm, \"");
            this.output(method.getName());
            this.output("\");");
            this.outputDelimiter();
            this.output("\t\t\tinitialized = 1;");
            this.outputDelimiter();
            this.output("\t\t}");
            this.outputDelimiter();
            this.output("\t\tif (fp) {");
            this.outputDelimiter();
            this.output("\t\t");
            this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
            this.output("fp");
            this.generateFunctionCallRightSide(method, methodData, paramTypes, 0);
            this.outputDelimiter();
            this.output("\t\t}");
            this.outputDelimiter();
        } else {
            this.output("\t\tstatic int initialized = 0;");
            this.outputDelimiter();
            this.output("\t\tstatic void *handle = NULL;");
            this.outputDelimiter();
            this.output("\t\tstatic ");
            this.output(JNIGenerator.getTypeSignature2(returnType));
            this.output(" (*fptr)(");
            int i = 0;
            while (i < paramTypes.length) {
                if (i != 0) {
                    this.output(", ");
                }
                Class paramType = paramTypes[i];
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                String cast = paramData.getCast();
                if (cast.length() > 2) {
                    this.output(cast.substring(1, cast.length() - 1));
                } else {
                    this.output(JNIGenerator.getTypeSignature4(paramType));
                }
                ++i;
            }
            this.output(");");
            this.outputDelimiter();
            if (returnType != Void.TYPE && needsReturn) {
                this.output("\t\trc = 0;");
                this.outputDelimiter();
            }
            this.output("\t\tif (!initialized) {");
            this.outputDelimiter();
            this.output("\t\t\tif (!handle) handle = dlopen(");
            this.output(method.getName());
            this.output("_LIB, RTLD_LAZY);");
            this.outputDelimiter();
            this.output("\t\t\tif (handle) fptr = dlsym(handle, \"");
            this.output(method.getName());
            this.output("\");");
            this.outputDelimiter();
            this.output("\t\t\tinitialized = 1;");
            this.outputDelimiter();
            this.output("\t\t}");
            this.outputDelimiter();
            this.output("\t\tif (fptr) {");
            this.outputDelimiter();
            this.output("\t\t");
            this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
            this.output("(*fptr)");
            this.generateFunctionCallRightSide(method, methodData, paramTypes, 0);
            this.outputDelimiter();
            this.output("\t\t}");
            this.outputDelimiter();
        }
        this.output("\t");
        this.output("}");
        this.outputDelimiter();
    }

    void generateFunctionCallLeftSide(Method method, MethodData methodData, Class returnType, boolean needsReturn) {
        this.output("\t");
        if (returnType != Void.TYPE) {
            if (needsReturn) {
                this.output("rc = ");
            } else {
                this.output("return ");
            }
            this.output("(");
            this.output(JNIGenerator.getTypeSignature2(returnType));
            this.output(")");
        }
        if (methodData.getFlag("address")) {
            this.output("&");
        }
    }

    void generateFunctionCallRightSide(Method method, MethodData methodData, Class[] paramTypes, int paramStart) {
        if (!methodData.getFlag("const")) {
            this.output("(");
            int i = paramStart;
            while (i < paramTypes.length) {
                Class paramType = paramTypes[i];
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                if (i != paramStart) {
                    this.output(", ");
                }
                if (paramData.getFlag("struct")) {
                    this.output("*");
                }
                this.output(paramData.getCast());
                if (!paramType.isPrimitive()) {
                    this.output("lp");
                }
                this.output("arg" + i);
                ++i;
            }
            this.output(")");
        }
        this.output(";");
    }

    void generateFunctionCall(Method method, MethodData methodData, Class[] paramTypes, Class returnType, boolean needsReturn) {
        this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
        int paramStart = 0;
        if (method.getName().equalsIgnoreCase("call")) {
            this.output("(");
            ParameterData paramData = this.getMetaData().getMetaData(method, 0);
            String cast = paramData.getCast();
            if (cast.length() != 0 && !cast.equals("()")) {
                this.output(cast);
            } else {
                this.output("(");
                this.output(JNIGenerator.getTypeSignature2(returnType));
                this.output(" (*)())");
            }
            this.output("arg0)");
            paramStart = 1;
        } else if (method.getName().equals("VtblCall")) {
            this.output("((");
            this.output(JNIGenerator.getTypeSignature2(returnType));
            this.output(" (STDMETHODCALLTYPE *)())(*(int **)arg1)[arg0])");
            paramStart = 1;
        } else {
            this.output(method.getName());
        }
        this.generateFunctionCallRightSide(method, methodData, paramTypes, paramStart);
        this.outputDelimiter();
    }

    void generateReturn(Method method, Class returnType, boolean needsReturn) {
        if (needsReturn && returnType != Void.TYPE) {
            this.output("\treturn rc;");
            this.outputDelimiter();
        }
    }

    void generateGTKmemmove(Method method, String function, Class[] paramTypes) {
        this.generateEnterMacro(method, function);
        this.output("\t");
        boolean get = paramTypes[0].isPrimitive();
        String className = JNIGenerator.getClassName(paramTypes[get ? 1 : 0]);
        this.output(get ? "if (arg1) get" : "if (arg0) set");
        this.output(className);
        this.output(get ? "Fields(env, arg1, (" : "Fields(env, arg0, (");
        this.output(className);
        this.output(get ? " *)arg0)" : " *)arg1)");
        this.output(";");
        this.outputDelimiter();
        this.generateExitMacro(method, function);
    }

    void generateFunctionBody(Method method, MethodData methodData, String function, Class[] paramTypes, Class returnType) {
        boolean isGTKmemove;
        this.output("{");
        this.outputDelimiter();
        boolean bl = isGTKmemove = method.getName().equals("memmove") && paramTypes.length == 2 && returnType == Void.TYPE;
        if (isGTKmemove) {
            this.generateGTKmemmove(method, function, paramTypes);
        } else {
            boolean needsReturn = this.generateLocalVars(method, paramTypes, returnType);
            this.generateEnterMacro(method, function);
            this.generateGetters(method, paramTypes);
            if (methodData.getFlag("dynamic")) {
                this.generateDynamicFunctionCall(method, methodData, paramTypes, returnType, needsReturn);
            } else {
                this.generateFunctionCall(method, methodData, paramTypes, returnType, needsReturn);
            }
            this.generateSetters(method, paramTypes);
            this.generateExitMacro(method, function);
            this.generateReturn(method, returnType, needsReturn);
        }
        this.output("}");
        this.outputDelimiter();
    }

    void generateFunctionPrototype(Method method, String function, Class[] paramTypes, Class returnType) {
        this.output("JNIEXPORT ");
        this.output(JNIGenerator.getTypeSignature2(returnType));
        this.output(" JNICALL ");
        if (this.nativeMacro) {
            this.output(JNIGenerator.getClassName(method.getDeclaringClass()));
            this.output("_NATIVE(");
        } else {
            this.output("Java_");
            this.output(JNIGenerator.toC(method.getDeclaringClass().getName()));
            this.output("_");
        }
        this.output(function);
        if (this.nativeMacro) {
            this.output(")");
        }
        this.outputDelimiter();
        this.output("\t(JNIEnv *env, ");
        if ((method.getModifiers() & 8) != 0) {
            this.output("jclass");
        } else {
            this.output("jobject");
        }
        this.output(" that");
        int i = 0;
        while (i < paramTypes.length) {
            Class paramType = paramTypes[i];
            this.output(", ");
            this.output(JNIGenerator.getTypeSignature2(paramType));
            this.output(" arg" + i);
            ++i;
        }
        this.output(")");
        this.outputDelimiter();
    }

    void generateSourceStart(String function) {
        this.output("#ifndef NO_");
        this.output(function);
        this.outputDelimiter();
    }

    void generateSourceEnd(String function) {
        this.output("#endif");
        this.outputDelimiter();
    }

    boolean isCritical(Class paramType, ParameterData paramData) {
        return paramType.isArray() && paramType.getComponentType().isPrimitive() && paramData.getFlag("critical");
    }

    boolean isUnique(Method method) {
        return JNIGenerator.isUnique(method, 256);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java NativesGenerator <className1> <className2>");
            return;
        }
        try {
            NativesGenerator gen = new NativesGenerator();
            int i = 0;
            while (i < args.length) {
                String clazzName = args[i];
                Class<?> clazz = Class.forName(clazzName);
                gen.generate(clazz);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

