/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import org.eclipse.swt.tools.internal.CleanupClass;
import org.eclipse.swt.tools.internal.JNIGenerator;

public class CleanupConstants
extends CleanupClass {
    String getFieldValue(Field field) {
        int equalsIndex;
        String name = field.getName();
        int index = 0;
        do {
            if ((index = this.classSource.indexOf(name, index + 1)) == -1) {
                return null;
            }
            equalsIndex = this.classSource.indexOf("=", index);
        } while (this.classSource.substring(index + name.length(), equalsIndex).trim().length() != 0);
        int semiIndex = this.classSource.indexOf(";", equalsIndex);
        return this.classSource.substring(equalsIndex + 1, semiIndex).trim();
    }

    public void generate(Class clazz) {
        this.usedCount = 0;
        this.unusedCount = 0;
        super.generate(clazz);
        Field[] fields = clazz.getDeclaredFields();
        this.generate(fields);
        this.output("used=" + this.usedCount + " unused=" + this.unusedCount + " total=" + (this.unusedCount + this.usedCount));
    }

    public void generate(Field[] fields) {
        JNIGenerator.sort(fields);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if ((field.getModifiers() & 0x10) != 0) {
                this.generate(field);
            }
            ++i;
        }
    }

    public void generate(Field field) {
        String name = field.getName();
        Enumeration keys = this.files.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            String str = (String)this.files.get(key);
            if (str.indexOf(name) == -1) continue;
            int modifiers = field.getModifiers();
            String modifiersStr = Modifier.toString(modifiers);
            this.output("\t");
            this.output(modifiersStr);
            if (modifiersStr.length() > 0) {
                this.output(" ");
            }
            this.output(JNIGenerator.getTypeSignature3(field.getType()));
            this.output(" ");
            this.output(field.getName());
            this.output(" = ");
            this.output(this.getFieldValue(field));
            this.output(";");
            this.outputDelimiter();
            ++this.usedCount;
            return;
        }
        ++this.unusedCount;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java CleanupConstants <OS className> <src path> <class source>");
            return;
        }
        try {
            CleanupConstants gen = new CleanupConstants();
            String clazzName = args[0];
            String[] sourcePath = new String[]{args[1]};
            String classSource = args[2];
            Class<?> clazz = Class.forName(clazzName);
            gen.setSourcePath(sourcePath);
            gen.setClassSourcePath(classSource);
            gen.generate(clazz);
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

