/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.net.URL;
import java.net.URLClassLoader;

public class AntClassLoader
extends URLClassLoader {
    protected ClassLoader[] pluginLoaders;

    public AntClassLoader(URL[] urls, ClassLoader[] pluginLoaders, ClassLoader parent) {
        super(urls, parent);
        this.pluginLoaders = pluginLoaders;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class result = this.loadClassParent(name);
        if (result == null) {
            result = this.loadClassURLs(name);
        }
        if (result == null) {
            result = this.loadClassPlugins(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    protected Class loadClassParent(String name) {
        try {
            ClassLoader parent = this.getParent();
            if (parent != null) {
                return parent.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    protected Class loadClassURLs(String name) {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected Class loadClassPlugins(String name) {
        Class<?> result = null;
        if (this.pluginLoaders != null) {
            int i = 0;
            while (i < this.pluginLoaders.length && result == null) {
                try {
                    result = this.pluginLoaders[i].loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                ++i;
            }
        }
        return result;
    }
}

