/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class AntCorePreferences {
    protected List defaultTasks;
    protected List defaultTypes;
    protected List defaultURLs;
    protected URL[] defaultAntURLs;
    protected Task[] customTasks;
    protected Type[] customTypes;
    protected URL[] antURLs;
    protected URL[] customURLs;
    protected Property[] customProperties;
    protected String[] customPropertyFiles;
    protected List pluginClassLoaders;
    private String antHome;

    protected AntCorePreferences(List defaultTasks, List defaultExtraClasspath, List defaultTypes) {
        this.initializePluginClassLoaders();
        this.defaultURLs = new ArrayList(20);
        this.defaultTasks = this.computeDefaultTasks(defaultTasks);
        this.defaultTypes = this.computeDefaultTypes(defaultTypes);
        this.computeDefaultExtraClasspathEntries(defaultExtraClasspath);
        this.restoreCustomObjects();
    }

    protected void restoreCustomObjects() {
        Preferences prefs = AntCorePlugin.getPlugin().getPluginPreferences();
        String tasks = prefs.getString("tasks");
        this.customTasks = tasks.equals("") ? new Task[0] : this.extractTasks(prefs, this.getArrayFromString(tasks));
        String types = prefs.getString("types");
        this.customTypes = types.equals("") ? new Type[0] : this.extractTypes(prefs, this.getArrayFromString(types));
        String urls = prefs.getString("ant_urls");
        this.antURLs = urls.equals("") ? this.getDefaultAntURLs() : this.extractURLs(this.getArrayFromString(urls));
        urls = prefs.getString("urls");
        this.customURLs = urls.equals("") ? new URL[0] : this.extractURLs(this.getArrayFromString(urls));
        this.antHome = prefs.getString("ant_home");
        String properties = prefs.getString("properties");
        this.customProperties = properties.equals("") ? new Property[0] : this.extractProperties(prefs, this.getArrayFromString(properties));
        String propertyFiles = prefs.getString("propertyfiles");
        this.customPropertyFiles = propertyFiles.equals("") ? new String[0] : this.getArrayFromString(propertyFiles);
    }

    protected Task[] extractTasks(Preferences prefs, String[] tasks) {
        ArrayList<Task> result = new ArrayList<Task>(tasks.length);
        int i = 0;
        while (i < tasks.length) {
            try {
                String taskName = tasks[i];
                String[] values = this.getArrayFromString(prefs.getString("task." + taskName));
                Task task = new Task();
                task.setTaskName(taskName);
                task.setClassName(values[0]);
                task.setLibrary(new URL(values[1]));
                result.add(task);
            }
            catch (MalformedURLException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            ++i;
        }
        return result.toArray(new Task[result.size()]);
    }

    protected Type[] extractTypes(Preferences prefs, String[] types) {
        ArrayList<Type> result = new ArrayList<Type>(types.length);
        int i = 0;
        while (i < types.length) {
            try {
                String typeName = types[i];
                String[] values = this.getArrayFromString(prefs.getString("type." + typeName));
                Type type = new Type();
                type.setTypeName(typeName);
                type.setClassName(values[0]);
                type.setLibrary(new URL(values[1]));
                result.add(type);
            }
            catch (MalformedURLException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            ++i;
        }
        return result.toArray(new Type[result.size()]);
    }

    protected Property[] extractProperties(Preferences prefs, String[] properties) {
        Property[] result = new Property[properties.length];
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i];
            String[] values = this.getArrayFromString(prefs.getString("property." + propertyName));
            Property property = new Property();
            property.setName(propertyName);
            property.setValue(values[0]);
            result[i] = property;
            ++i;
        }
        return result;
    }

    protected URL[] extractURLs(String[] urls) {
        ArrayList<URL> result = new ArrayList<URL>(urls.length);
        int i = 0;
        while (i < urls.length) {
            try {
                result.add(new URL(urls[i]));
            }
            catch (MalformedURLException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }

    public URL[] getDefaultAntURLs() {
        if (this.defaultAntURLs == null) {
            ArrayList<URL> result = new ArrayList<URL>(10);
            IPluginDescriptor descriptor = Platform.getPlugin((String)"org.apache.ant").getDescriptor();
            this.addLibraries(descriptor, result);
            descriptor = Platform.getPlugin((String)"org.apache.xerces").getDescriptor();
            this.addLibraries(descriptor, result);
            URL toolsURL = this.getToolsJarURL();
            if (toolsURL != null) {
                result.add(toolsURL);
            }
            this.defaultAntURLs = result.toArray(new URL[result.size()]);
        }
        return this.defaultAntURLs;
    }

    public URL[] getAntURLs() {
        return this.antURLs;
    }

    protected List computeDefaultTasks(List tasks) {
        ArrayList<Task> result = new ArrayList<Task>(tasks.size());
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            IPluginDescriptor descriptor;
            Task task;
            block4: {
                IConfigurationElement element = (IConfigurationElement)iterator.next();
                task = new Task();
                task.setTaskName(element.getAttribute("name"));
                task.setClassName(element.getAttribute("class"));
                String library = element.getAttribute("library");
                if (library == null) {
                    Status status = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.Library_not_specified_for__{0}_4"), task.getTaskName()), null);
                    AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                    continue;
                }
                descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
                try {
                    URL url = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), library));
                    task.setLibrary(url);
                    if (this.defaultURLs.contains(url)) break block4;
                    this.defaultURLs.add(url);
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                    AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                    continue;
                }
            }
            result.add(task);
            this.addPluginClassLoader(descriptor.getPluginClassLoader());
        }
        return result;
    }

    protected List computeDefaultTypes(List types) {
        ArrayList<Type> result = new ArrayList<Type>(types.size());
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            IPluginDescriptor descriptor;
            Type type;
            block4: {
                IConfigurationElement element = (IConfigurationElement)iterator.next();
                type = new Type();
                type.setTypeName(element.getAttribute("name"));
                type.setClassName(element.getAttribute("class"));
                String library = element.getAttribute("library");
                if (library == null) {
                    Status status = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.Library_not_specified_for__{0}_4"), type.getTypeName()), null);
                    AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                    continue;
                }
                descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
                try {
                    URL url = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), library));
                    type.setLibrary(url);
                    if (this.defaultURLs.contains(url)) break block4;
                    this.defaultURLs.add(url);
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                    AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                    continue;
                }
            }
            result.add(type);
            this.addPluginClassLoader(descriptor.getPluginClassLoader());
        }
        return result;
    }

    protected void computeDefaultExtraClasspathEntries(List entries) {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            IPluginDescriptor descriptor;
            block3: {
                IConfigurationElement element = (IConfigurationElement)iterator.next();
                String library = element.getAttribute("library");
                descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
                try {
                    URL url = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), library));
                    if (this.defaultURLs.contains(url)) break block3;
                    this.defaultURLs.add(url);
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                    AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                    continue;
                }
            }
            this.addPluginClassLoader(descriptor.getPluginClassLoader());
        }
    }

    public URL getToolsJarURL() {
        File tools;
        Path path = new Path(System.getProperty("java.home"));
        if (path.lastSegment().equalsIgnoreCase("jre")) {
            path = path.removeLastSegments(1);
        }
        if (!(tools = (path = path.append("lib").append("tools.jar")).toFile()).exists()) {
            path = path.removeLastSegments(1);
            tools = (path = path.append("classes.zip")).toFile();
            if (!tools.exists()) {
                return null;
            }
        }
        try {
            return new URL("file:" + tools.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            return null;
        }
    }

    protected void addLibraries(IPluginDescriptor source, List destination) {
        URL root = source.getInstallURL();
        ILibrary[] libraries = source.getRuntimeLibraries();
        int i = 0;
        while (i < libraries.length) {
            try {
                URL url = new URL(root, libraries[i].getPath().toString());
                destination.add(Platform.asLocalURL((URL)url));
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    protected void addPluginClassLoader(ClassLoader loader) {
        if (!this.pluginClassLoaders.contains(loader)) {
            this.pluginClassLoaders.add(loader);
        }
    }

    public URL[] getURLs() {
        ArrayList<URL> result = new ArrayList<URL>(10);
        if (this.defaultURLs != null) {
            result.addAll(this.defaultURLs);
        }
        if (this.antURLs != null) {
            result.addAll(Arrays.asList(this.antURLs));
        }
        if (this.customURLs != null) {
            result.addAll(Arrays.asList(this.customURLs));
        }
        return result.toArray(new URL[result.size()]);
    }

    protected ClassLoader[] getPluginClassLoaders() {
        return this.pluginClassLoaders.toArray(new ClassLoader[this.pluginClassLoaders.size()]);
    }

    protected void initializePluginClassLoaders() {
        this.pluginClassLoaders = new ArrayList(10);
        this.pluginClassLoaders.add(Platform.getPlugin((String)"org.eclipse.ant.core").getDescriptor().getPluginClassLoader());
    }

    public List getTasks() {
        ArrayList<Task> result = new ArrayList<Task>(10);
        if (this.defaultTasks != null) {
            result.addAll(this.defaultTasks);
        }
        if (this.customTasks != null) {
            result.addAll(Arrays.asList(this.customTasks));
        }
        return result;
    }

    public Task[] getCustomTasks() {
        return this.customTasks;
    }

    public Type[] getCustomTypes() {
        return this.customTypes;
    }

    public Property[] getCustomProperties() {
        return this.customProperties;
    }

    public String[] getCustomPropertyFiles() {
        return this.customPropertyFiles;
    }

    public URL[] getCustomURLs() {
        return this.customURLs;
    }

    public void setCustomTasks(Task[] tasks) {
        this.customTasks = tasks;
    }

    public void setCustomTypes(Type[] types) {
        this.customTypes = types;
    }

    public void setCustomURLs(URL[] urls) {
        this.customURLs = urls;
    }

    public void setAntURLs(URL[] urls) {
        this.antURLs = urls;
    }

    public void setCustomPropertyFiles(String[] paths) {
        this.customPropertyFiles = paths;
    }

    public void setCustomProperties(Property[] properties) {
        this.customProperties = properties;
    }

    public List getTypes() {
        ArrayList<Type> result = new ArrayList<Type>(10);
        if (this.defaultTypes != null) {
            result.addAll(this.defaultTypes);
        }
        if (this.customTypes != null) {
            result.addAll(Arrays.asList(this.customTypes));
        }
        return result;
    }

    protected String[] getArrayFromString(String list) {
        String separator = ",";
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public void updatePluginPreferences() {
        Preferences prefs = AntCorePlugin.getPlugin().getPluginPreferences();
        this.updateTasks(prefs);
        this.updateTypes(prefs);
        this.updateAntURLs(prefs);
        this.updateURLs(prefs);
        this.updateProperties(prefs);
        this.updatePropertyFiles(prefs);
        AntCorePlugin.getPlugin().savePluginPreferences();
    }

    protected void updateTasks(Preferences prefs) {
        if (this.customTasks.length == 0) {
            prefs.setValue("tasks", "");
            return;
        }
        StringBuffer tasks = new StringBuffer();
        int i = 0;
        while (i < this.customTasks.length) {
            tasks.append(this.customTasks[i].getTaskName());
            tasks.append(',');
            prefs.setValue("task." + this.customTasks[i].getTaskName(), String.valueOf(this.customTasks[i].getClassName()) + "," + this.customTasks[i].getLibrary().toExternalForm());
            ++i;
        }
        prefs.setValue("tasks", tasks.toString());
    }

    protected void updateTypes(Preferences prefs) {
        if (this.customTypes.length == 0) {
            prefs.setValue("types", "");
            return;
        }
        StringBuffer types = new StringBuffer();
        int i = 0;
        while (i < this.customTypes.length) {
            types.append(this.customTypes[i].getTypeName());
            types.append(',');
            prefs.setValue("type." + this.customTypes[i].getTypeName(), String.valueOf(this.customTypes[i].getClassName()) + "," + this.customTypes[i].getLibrary().toExternalForm());
            ++i;
        }
        prefs.setValue("types", types.toString());
    }

    protected void updateProperties(Preferences prefs) {
        if (this.customProperties.length == 0) {
            prefs.setValue("properties", "");
            return;
        }
        StringBuffer properties = new StringBuffer();
        int i = 0;
        while (i < this.customProperties.length) {
            properties.append(this.customProperties[i].getName());
            properties.append(',');
            prefs.setValue("property." + this.customProperties[i].getName(), this.customProperties[i].getValue());
            ++i;
        }
        prefs.setValue("properties", properties.toString());
    }

    protected void updateURLs(Preferences prefs) {
        StringBuffer urls = new StringBuffer();
        int i = 0;
        while (i < this.customURLs.length) {
            urls.append(this.customURLs[i].toExternalForm());
            urls.append(',');
            ++i;
        }
        prefs.setValue("urls", urls.toString());
        String prefAntHome = "";
        if (this.antHome != null) {
            prefAntHome = this.antHome;
        }
        prefs.setValue("ant_home", prefAntHome);
    }

    protected void updateAntURLs(Preferences prefs) {
        URL[] dcUrls = this.getDefaultAntURLs();
        boolean dflt = false;
        if (dcUrls.length == this.antURLs.length) {
            dflt = true;
            int i = 0;
            while (i < this.antURLs.length) {
                if (!this.antURLs[i].equals(dcUrls[i])) {
                    dflt = false;
                    break;
                }
                ++i;
            }
        }
        if (dflt) {
            prefs.setValue("ant_urls", "");
            return;
        }
        StringBuffer urls = new StringBuffer();
        int i = 0;
        while (i < this.antURLs.length) {
            urls.append(this.antURLs[i].toExternalForm());
            urls.append(',');
            ++i;
        }
        prefs.setValue("ant_urls", urls.toString());
    }

    protected void updatePropertyFiles(Preferences prefs) {
        StringBuffer files = new StringBuffer();
        int i = 0;
        while (i < this.customPropertyFiles.length) {
            files.append(this.customPropertyFiles[i]);
            files.append(',');
            ++i;
        }
        prefs.setValue("propertyfiles", files.toString());
    }

    public void setAntHome(String antHome) {
        this.antHome = antHome;
    }

    public String getAntHome() {
        return this.antHome;
    }
}

