/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.core;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.internal.core.AntClassLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class AntCorePlugin
extends Plugin
implements Preferences.IPropertyChangeListener {
    public static final int INTERNAL_ERROR = 120;
    private static AntCorePlugin plugin;
    private AntCorePreferences preferences;
    private ClassLoader classLoader;
    public static final String PI_ANTCORE = "org.eclipse.ant.core";
    public static final String PT_TASKS = "antTasks";
    public static final String PT_EXTRA_CLASSPATH = "extraClasspathEntries";
    public static final String PT_TYPES = "antTypes";
    public static final String CLASS = "class";
    public static final String NAME = "name";
    public static final String LIBRARY = "library";
    public static final String ECLIPSE_PROGRESS_MONITOR = "eclipse.progress.monitor";
    public static final int ERROR_RUNNING_SCRIPT = 1;
    public static final int ERROR_MALFORMED_URL = 2;
    public static final int ERROR_LIBRARY_NOT_SPECIFIED = 3;

    public AntCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public void startup() throws CoreException {
    }

    public void shutdown() throws CoreException {
        this.getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        if (this.preferences == null) {
            return;
        }
        this.preferences.updatePluginPreferences();
        this.savePluginPreferences();
    }

    private List extractExtensions(String point, String key) {
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(point);
        if (extensionPoint == null) {
            return null;
        }
        IConfigurationElement[] extensions = extensionPoint.getConfigurationElements();
        return Arrays.asList(extensions);
    }

    public AntCorePreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new AntCorePreferences(this.extractExtensions(PT_TASKS, NAME), this.extractExtensions(PT_EXTRA_CLASSPATH, LIBRARY), this.extractExtensions(PT_TYPES, NAME));
        }
        return this.preferences;
    }

    public static AntCorePlugin getPlugin() {
        return plugin;
    }

    protected ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            AntCorePreferences preferences = this.getPreferences();
            URL[] urls = preferences.getURLs();
            ClassLoader[] pluginLoaders = preferences.getPluginClassLoaders();
            this.classLoader = new AntClassLoader(urls, pluginLoaders, null);
            this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        return this.classLoader;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals("urls")) {
            this.classLoader = null;
        } else if (event.getProperty().equals("ant_urls")) {
            this.classLoader = null;
        }
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PI_ANTCORE, 120, "Error logged from Ant Core: ", t);
        AntCorePlugin.getPlugin().getLog().log((IStatus)status);
    }
}

