/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.commons.modeler.BaseModelMBean;

public class ContextResourceMBean
extends BaseModelMBean {
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        ContextResource cr = null;
        try {
            cr = (ContextResource)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        String value = null;
        if ("auth".equals(name)) {
            return cr.getAuth();
        }
        if ("description".equals(name)) {
            return cr.getDescription();
        }
        if ("name".equals(name)) {
            return cr.getName();
        }
        if ("scope".equals(name)) {
            return cr.getScope();
        }
        if ("type".equals(name)) {
            return cr.getType();
        }
        NamingResources nr = cr.getNamingResources();
        if (nr == null) {
            throw new AttributeNotFoundException("Cannot find naming resource " + cr.getName());
        }
        ResourceParams rp = nr.findResourceParams(cr.getName());
        if (rp == null) {
            throw new AttributeNotFoundException("Cannot find resource param " + cr.getName());
        }
        value = (String)rp.getParameters().get(name);
        if (value == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + name + rp);
        }
        return value;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute is null"), "Attribute is null");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name is null"), "Attribute name is null");
        }
        ContextResource cr = null;
        try {
            cr = (ContextResource)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        if ("auth".equals(name)) {
            cr.setAuth((String)value);
        } else if ("description".equals(name)) {
            cr.setDescription((String)value);
        } else if ("name".equals(name)) {
            cr.setName((String)value);
        } else if ("scope".equals(name)) {
            cr.setScope((String)value);
        } else if ("type".equals(name)) {
            cr.setType((String)value);
        } else {
            ResourceParams rp = cr.getNamingResources().findResourceParams(cr.getName());
            if (rp != null) {
                String valueStr = "" + value;
                rp.addParameter(name, valueStr);
                cr.getNamingResources().removeResourceParams(cr.getName());
            } else {
                rp = new ResourceParams();
                rp.setName(cr.getName());
                String valueStr = "" + value;
                rp.addParameter(name, valueStr);
            }
            cr.getNamingResources().addResourceParams(rp);
        }
        NamingResources nr = cr.getNamingResources();
        nr.removeResource(cr.getName());
        nr.addResource(cr);
    }
}

