/* $Id: proto_gnuchess4.cc,v 1.8 2002/06/14 17:32:57 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "eboard.h"
#include "protocol.h"
#include "global.h"

GnuChess4Protocol::GnuChess4Protocol() : XBoardProtocol() {
  strcpy(ComputerName,"GNU Chess");
  want_path_pane=0;
  need_handshake=false; // sending xboard confuses GNU chess 4
}

void GnuChess4Protocol::initEngine() {
  char z[32];
  createGame();
  global.network->writeLine("nopost");

  global.network->writeLine("hard");
  if (!ThinkAlways)
    global.network->writeLine("easy");

  global.network->writeLine("new");

  if (SecsPerMove > 0) {
    if (SecsPerMove%60)
      sprintf(z,"level 1 %d:%02d",SecsPerMove/60,SecsPerMove%60);
    else
      sprintf(z,"level 1 %d",SecsPerMove/60);  
    global.network->writeLine(z);
  }

  if (MaxDepth > 0) {
    sprintf(z,"depth %d",MaxDepth);
    global.network->writeLine(z);
  }

  lateInit();
  endInit();
}

void GnuChess4Protocol::readDialog() {
  XBoardProtocol::readDialog();
  strcpy(EngineCommandLine,"gnuchessx");
  EngineRunDir[0]=0;

  if (ebm) {
    ebm->proto=3;
    ebm->cmdline=EngineCommandLine;
    ebm->directory=EngineRunDir;
    makeBookmarkCaption();
  }
}

char * GnuChess4Protocol::getDialogName() {
  return("Play against GNU Chess 4");
}

