/* $Id: animate.cc,v 1.8 2002/06/14 17:32:57 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <string.h>
#include "animate.h"

int AnimatedPiece::over() {
  return(ower<=0);
}

int AnimatedPiece::getX() {
  return X;
}

int AnimatedPiece::getY() {
  return Y;
}

piece AnimatedPiece::getPiece() {
  return Piece;
}

bool AnimatedPiece::getSoundHold() {
  return((SoundHold)&&(ower>0));
}

// ================================================
// flat implementation
// ================================================

FlatAnimatedPiece::FlatAnimatedPiece(piece p,int x0,int y0,
				     int xf,int yf,int s,bool sndhold) :
  AnimatedPiece()
{
  Piece=p;
  X0=x0; Y0=y0;
  XF=xf; YF=yf;
  steps=s;
  X=X0; Y=Y0;
  DX=(XF-X0)/steps;
  DY=(YF-Y0)/steps;
  ower=steps;
  SoundHold=sndhold;
}

void FlatAnimatedPiece::create(GdkWindow *parent,PieceSet *set,int sqside) {
  square=sqside;
}

void FlatAnimatedPiece::lemming() {
  delete this;
}

void FlatAnimatedPiece::destroy() {

}

void FlatAnimatedPiece::step() {
  if (ower > 1) {
    X+=DX;
    Y+=DY;
  }
  if (ower==1) { X=XF; Y=YF; }
  --ower;
  
}

