/* $Id: eboard.h,v 1.23 2002/03/12 02:03:23 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef EBOARD_H
#define EBOARD_H 1

#include <gtk/gtk.h>

#define EMPTY 0x00
#define BLACK 0x10
#define WHITE 0x20

#define ROOK   0x01
#define KNIGHT 0x02
#define BISHOP 0x03
#define QUEEN  0x04
#define KING   0x05
#define PAWN   0x06

// to keep track of promoted pieces in zhouse
#define WASPAWN 0x40

// Not A Piece -- I mean it :-)
#define NotAPiece    0x0e

#define PIECE_MASK 0x0f
#define COLOR_MASK 0x30
#define CUTFLAGS   0x3f

typedef int piece;
typedef unsigned char * rgbptr;
typedef unsigned char hati;

class ProtocolParser;

class PieceProvider {
 public:
  virtual piece getPiece()=0;
};

class InputHandler {
 public:
  virtual void setPasswordMode(int pm)=0;
  virtual void userInput(char *text)=0;
  virtual void peekKeys(GtkWidget *who)=0;
};

class ConnectionHandler {
 public:
  virtual void openServer(char *host,int port,
			  ProtocolParser *protocol,char *helper)=0;
};

class UpdateInterface {
 public:
  virtual void update()=0;
};

class MoveListListener {
 public:
  virtual void moveListClosed()=0;
};

class GameListListener {
 public:
  virtual void gameListClosed()=0;
};

class StockListListener {
 public:
  virtual void stockListClosed()=0;
};

class AdListListener {
 public:
  virtual void adListClosed()=0;
};

class ConsoleListener {
 public:
  virtual void consoleClosed()=0;
};

class GameListConsumer {
 public:
  virtual void appendGame(int gamenum, char *desc)=0;
  virtual void endOfList()=0;
};

class PaneChangeListener {
 public:
  virtual void paneChanged(int pgseq,int pgid)=0;
};

class SigChildHandler {
 public:
  virtual void ZombieNotification(int pid)=0;
};

class BookmarkListener {
 public:
  virtual void updateBookmarks()=0;
};

typedef enum {
  REGULAR,
  CRAZYHOUSE,
  SUICIDE,
  BUGHOUSE,
  WILD,
  LOSERS,
  GIVEAWAY
} variant;

typedef enum {
  WHITE_WIN,
  BLACK_WIN,
  DRAW,
  UNDEF
} GameResult;

typedef enum {
  IM_ZERO=0,
  IM_IGNORE=1,
  IM_NORMAL=2,
  IM_PERSONAL=3,
  IM_TOP=4,
  IM_RESET=5,
} Importance;

#define CLOCK_UNCHANGED (-1000000)

#define DEFAULT_FONT_CLOK "-*-lucida-bold-r-normal-*-34-*-*-*-*-*-*"
#define DEFAULT_FONT_PLYR "-*-helvetica-bold-r-normal--18-*-*-*-*-*-*"
#define DEFAULT_FONT_INFO "-*-helvetica-medium-r-normal--12-*-*-*-*-*-*"
#define DEFAULT_FONT_CONS "-misc-fixed-medium-r-normal--14-*-*-*-*-*-*"

typedef enum {
  EF_PlayerFont,
  EF_ClockFont,
  EF_InfoFont
} EboardFont;

#endif

