/* $Id: dlg_prefs.h,v 1.16 2002/03/17 04:53:36 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef EBOARD_PREFS
#define EBOARD_PREFS

#include "sound.h"
#include "widgetproxy.h"

class PreferencesDialog : public ModalDialog,
                          public SoundEventChangeListener
{
 public:
  PreferencesDialog();
  ~PreferencesDialog();

  void SoundEventChanged();

 private:
  GtkWidget *tabposb[4],*efont[4],*fontdlg,*plainb,
    *aapieceb, *showratb, *autologb, *sbacke, *snddesc, *sndb[2],
    *asp, *aso, *afn, *sgb, *hsb, *chsb, *coct, *dhsb, *aqbar;
  BoxedLabel *fm[4];
  SoundEvent sndcopy[4];
  ColorButton *lsq, *dsq, *textcb[11];
  TextPreview *preview;
  int selected_sound_event;

  void ResolveFont(char *src,char *dest);

  void Apply();
  void ApplyCheckBox(GtkWidget *cb,int *curval,int *ch1, int *ch2);
  void ApplyEntry(GtkWidget *entry,char *curval,int sz, int *ch1, int *ch2);
  void ApplyColorButton(ColorButton *cb,int *curval,int *ch1, int *ch2);

  friend void prefs_ok(GtkWidget *w,gpointer data);
  friend void prefs_apply(GtkWidget *w,gpointer data);

  friend void prefs_frevert(GtkWidget *w,gpointer data);
  friend void prefs_cfont1(GtkWidget *w,gpointer data);
  friend void prefs_cfont2(GtkWidget *w,gpointer data);
  friend void prefs_cfont3(GtkWidget *w,gpointer data);
  friend void prefs_cfont4(GtkWidget *w,gpointer data);

  friend void prefs_fok1(GtkWidget *w,gpointer data);
  friend void prefs_fok2(GtkWidget *w,gpointer data);
  friend void prefs_fok3(GtkWidget *w,gpointer data);
  friend void prefs_fok4(GtkWidget *w,gpointer data);

  friend void prefs_sndtest(GtkWidget *w,gpointer data);
  friend void prefs_sndedit(GtkWidget *w,gpointer data);
  friend void prefs_sndsel(GtkCList *c,gint row, gint col, GdkEventButton *eb, gpointer data);
  friend void prefs_sndunsel(GtkCList *c,gint row, gint col, GdkEventButton *eb, gpointer data);

  friend void prefs_defcolor(GtkWidget *w,gpointer data);
};


#endif
