
#include <iostream.h>
#include "clock.h"
#include "global.h"

ClockMaster Chronos;

int ChessClock::freeid=1;

ClockMaster::ClockMaster() {
  timeout_on=0;
  timeout_id=-1;
}

void ClockMaster::append(ChessClock *clockp) {
  clocks.push_back(clockp);
  if (!timeout_on) {
    timeout_id=gtk_timeout_add(333,clockmaster_timeout,this);
    timeout_on=1;
  }
}

void ClockMaster::remove(ChessClock *clockp) {
  list<ChessClock *>::iterator li;
  for(li=clocks.begin();li!=clocks.end();li++)
    if ( (*li) == clockp ) {
      clocks.erase(li);
      return;
    }
}

void ClockMaster::update() {
  list<ChessClock *>::iterator it;
  for(it=clocks.begin();it!=clocks.end();it++)
    (*it)->update();
}

gint clockmaster_timeout(gpointer data) {
  ClockMaster *cm;
  cm=(ClockMaster *)data;
  cm->update();
  return 1;
}

// ==================================================================

ChessClock::ChessClock() {
  active=0;
  host=0;
  host2=0;
  mirror=0;
  value[0]=value[1]=0;
  t_ref[0]=t_ref[1]=0;
  val_ref[0]=val_ref[1]=0;
  id=freeid++;
  countdownf=1;
  Chronos.append(this);
}

ChessClock::~ChessClock() {
  active=0;
  host=0;
  Chronos.remove(this);
}

void ChessClock::setMirror(ChessClock *dest) {
  mirror=dest;
}

void ChessClock::setClock(int whitesec,int blacksec,int activep,int countdown)
{
  global.debug("ChessClock","setClock");
  countdownf=countdown;
  if (whitesec>-999999) {
    value[0]=whitesec;
    t_ref[0]=time(0);
    val_ref[0]=value[0];
  }
  if (blacksec>-999999) {
    value[1]=blacksec;
    t_ref[1]=time(0);
    val_ref[1]=value[1];
  }
  active=activep;
  if (mirror)
    mirror->setClock(whitesec,blacksec,activep,countdown);
}

void ChessClock::setHost(ClockHost *hostp) {
  host=hostp;
}

void ChessClock::setAnotherHost(ClockHost *hostp) {
  host2=hostp;
}

int  ChessClock::getActive() {
  return active;
}

void ChessClock::update() {
  time_t now;
  if ((active)&&(host)) {
    now=time(0);
    if (active<0)
      value[0]=val_ref[0]+(countdownf?-1:1)*(now-t_ref[0]);
    else
      value[1]=val_ref[1]+(countdownf?-1:1)*(now-t_ref[1]);     

    host->updateClock();
    if (host2) host->updateClock();
  }
}

int ChessClock::getValue(int black) {
  return(value[black?1:0]);
}

