/* $Id: dlg_about.cc,v 1.4 2001/04/28 17:07:01 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <string.h>
#include "dlg_about.h"
#include "global.h"

#include "gnupiece.xpm"

AboutDialog::AboutDialog() : ModalDialog("About eboard") {
  GtkWidget *v,*hb,*label,*bhb,*hs,*ok,*gnup;
  GtkStyle *style;
  GdkPixmap *gnud;
  GdkBitmap *gnub;
  char z[1024];

  v=gtk_vbox_new(FALSE,4);
  gtk_container_add(GTK_CONTAINER(widget),v);

  hb=gtk_hbox_new(FALSE,4);
  gtk_box_pack_start(GTK_BOX(v),hb,TRUE,TRUE,0);

  style=gtk_widget_get_style(widget);
  gnud=gdk_pixmap_create_from_xpm_d(widget->window,&gnub,
                                    &style->bg[GTK_STATE_NORMAL],
                                    (gchar **)gnupiece_xpm);
  gnup=gtk_pixmap_new(gnud,gnub);

  gtk_box_pack_start(GTK_BOX(hb),gnup,FALSE,TRUE,4);

  sprintf(z,
	  "eboard version %s\n"\
	  "(c) 2000-2001 Felipe Bergo\n"\
	  "<bergo@seul.org>\n"\
	  "http://eboard.sourceforge.net\n\n"\
	  "This program is free software; you can redistribute\n"\
	  "it and/or modify it under the terms of the GNU General\n"\
	  "Public License as published by the Free Software\n"\
	  "Foundation; either version 2 of the License, or\n"\
	  "(at your option) any later version.\n",
	  global.Version);

  label=gtk_label_new(z);
  gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(hb),label,TRUE,TRUE,4);

  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v),hs,FALSE,FALSE,4);

  bhb=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(bhb), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(bhb), 5);

  gtk_box_pack_start(GTK_BOX(v),bhb,FALSE,FALSE,4);

  ok=gtk_button_new_with_label("Close");
  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bhb),ok,TRUE,TRUE,0);

  gtk_widget_grab_default(ok);

  gtk_widget_show(ok);
  gtk_widget_show(bhb);
  gtk_widget_show(hs);
  gtk_widget_show(label);
  gtk_widget_show(gnup);
  gtk_widget_show(hb);
  gtk_widget_show(v);
  setDismiss(GTK_OBJECT(ok),"clicked");
}

