/* $Id: board.h,v 1.32 2001/10/14 17:36:26 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef BOARD_H
#define BOARD_H

#include "stl.h"
#include "eboard.h"
#include "widgetproxy.h"
#include "pieces.h"
#include "position.h"
#include "chess.h"
#include "clock.h"
#include "notebook.h"
#include "animate.h"

// foreign classes referenced here
class ChessGame;

class DropSource {
 public:
  DropSource(piece p, int x1,int y1,int w,int h);
  bool hit(int x,int y);

  int X,Y,X2,Y2;
  piece P;
};

class TargetManager {
 public:
  void cleanTargets();
  void addTarget(DropSource *ds);
  DropSource *hitTarget(int x,int y);

 private:
  vector<DropSource *> targets;
};

class RootBoard {
 protected:
  void clockString(int val,char *z);
};

class BareBoard : public WidgetProxy,
		  public RootBoard,
                  public ClockHost {
 public:
  BareBoard();
  ~BareBoard();

  void setPosition(Position *pos);
  void setWhite(char *name);
  void setBlack(char *name);
  virtual void updateClock();
  
  ChessClock clock;

 private:
  void update();

  static VectorPieces vpieces;
  char Names[2][64];
  Position position;
  GdkPixmap *pixbuf;
  GdkFont *myfont;

  friend gboolean bareboard_expose(GtkWidget *widget,GdkEventExpose *ee,
				   gpointer data);
};

class Board : public WidgetProxy,
	      public ClockHost,
	      public RootBoard,
	      public NotebookInsider,
              public TargetManager
{
 public:
  Board(bool withbugpane=false);
  ~Board();

  static void  setCurrentPieceSet(char *filename, bool chgPieces, bool chgSquares);
  static char *getCurrentPieceSet();
  static char *getCurrentSquareSet();

  void repaint();

  void  setSensitive(int state);
  void  setSelColor(int color);
  void  clearSel();
  void  setFlipped(int flip);
  void  setFlipInversion(bool v);
  bool  getFlipInversion();
  void  setClock(int wsecs,int bsecs,int actv,int cdown);
  void  setInfo(int idx,char *s);
  void  setCanMove(int value);
  void  stopClock();
  void  reset();
  
  void  setGame(ChessGame *game);
  void  reloadFonts();

  void freeze();
  void thaw();
  void queueRepaint();
  void invalidate();

  virtual void show();

  void update(bool sndflag=false);
  virtual void updateClock();

  void walkBack1();
  void walkBackAll();
  void walkForward1();
  void walkForwardAll();
  void openMovelist();
  bool hasGame();

  void dump();

  void refreshPieceSet();
  void supressNextAnimation();

  void openBugPane();
  void closeBugPane();
  void addBugText(char *text);

  bool FreeMove; // editing positions, examining games
 
  BareBoard *bugboard;

  static string BugTell;
  static Board * PopupOwner;

 private:
  static PieceSet *orig;
  static VectorPieces vpieces;

  GtkWidget *yidget, *bugpane;

  PieceSet *cur;
  GdkPixmap *buffer,*clkbar;
  GdkFont *f1,*f2,*f3;
  rgbptr scrap;
  int canselect;
  int sel_color;
  int flipped;
  int frozen_lvl;
  int repaint_due;
  int allowMove;
  int LockAnimate;
  bool FlipInvert;
  vector<SMove *> LastMove;

  list<AnimatedPiece *> animes;
  int gotAnimationLoop;
  int update_queue;

  Position position;
  Position currently_rendered;
  Position fake;

  ChessGame *mygame;
  ChessClock clock;

  int hilite_ch, clock_ch;

  // selection/highlight
  int ax[2],ay[2],sp;

  // premove
  int premoveq;
  int pmx[2],pmy[2];
  piece pmp;  

  // dragged piece info
  bool  dr_active;
  bool  dr_fromstock;
  int   dr_ox, dr_oy, dr_c, dr_r;
  piece dr_p;
  int   dr_step;
  int   dr_dirty[2];
  bool  dr_fto;

  // info lines
  char info[6][64];

  int dropsq[2];

  int sqside;
  int borx, bory; // borders (when coordinates are shown)
  int morey; // extra y space for extruded sets

  stack<bool> UpdateStack;

  // inline calculations
  int Width()  { return( (sqside<<3) + (borx<<1) ); }
  int Height() { return( (sqside<<3) + (bory<<1) + morey); }

  void popupDropMenu(int col,int row,int sx,int sy,guint32 etime);
  void popupProtocolMenu(int x,int y, guint32 etime);
  void renderClock();
  void sendMove();
  void outlineRectangle(GdkGC *gc, int x,int y,int color,int pen);
  void drawBall(GdkGC *gc, int x,int y,int color,int radius);
  void drop(piece p);
  void drawCoordinates(GdkPixmap *dest,GdkGC *gc,int side);

  void composeVecBoard(GdkGC *gc);
  void pasteVecBoard();

  void createBugPane();

  bool effectiveFlip();

  GdkFont *loadFallbackFont(int i);

  friend gboolean board_animate(gpointer data);
  friend gboolean vec_board_animate(gpointer data);

  friend gboolean board_expose_event(GtkWidget *widget,GdkEventExpose *ee,
				     gpointer data);
  friend gboolean board_configure_event(GtkWidget *widget,
					GdkEventConfigure *ce,
					gpointer data);
  friend gboolean board_button_press_event(GtkWidget *widget,
					   GdkEventButton *be,
					   gpointer data);
  friend gboolean board_button_release_event(GtkWidget *widget,
					     GdkEventButton *be,
					     gpointer data);
  friend gboolean board_motion_event(GtkWidget *widget,
				     GdkEventMotion *em,
				     gpointer data);

  friend void drop_callbackP(GtkMenuItem *item,gpointer data);
  friend void drop_callbackR(GtkMenuItem *item,gpointer data);
  friend void drop_callbackN(GtkMenuItem *item,gpointer data);
  friend void drop_callbackB(GtkMenuItem *item,gpointer data);
  friend void drop_callbackQ(GtkMenuItem *item,gpointer data);

  friend void menu_whitep(GtkMenuItem *item, gpointer data);
  friend void menu_blackp(GtkMenuItem *item, gpointer data);
  friend void menu_gamep(GtkMenuItem *item, gpointer data);

  friend void board_ptell(GtkWidget *b,gpointer data);
};

#endif

