/* $Id: global.h,v 1.37 2001/09/20 22:35:23 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2001 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef GLOBAL_H
#define GLOBAL_H 1

#include <gtk/gtk.h>
#include "eboard.h"
#include "text.h"
#include "network.h"
#include "protocol.h"
#include "chess.h"
#include "sound.h"
#include "seekgraph.h"
#include "history.h"
#include "stl.h"

class Board;
class OutputPane;
class NetConnection;
class Status;
class ProtocolParser;
class ChessGame;
class Notebook;
class SeekGraph;
class SoundSlave;

class HostBookmark {
 public:
  int operator==(HostBookmark *hbm);
  char host[128];
  int  port;
  char protocol[64];
};

class ChannelSplitter {
 public:  
  void appendToChannel(int ch,char *msg,int color,Importance im=IM_NORMAL); 
  virtual Notebook * getNotebook()=0;

 protected:
  void updateChannelScrollBacks();

 private:
  void ensurePane(int ch);
  void createPane(int ch);

  vector<Text *>  panes;
  vector<int>     numbers;
};

class TerminalColor {
 public:
  TerminalColor();
  void read(TString &t);
  void write(FILE *f);

  int TextDefault;
  int TextBright;
  int PrivateTell;
  int NewsNotify;
  int Mamer;
  int KibitzWhisper;
  int Shouts;
  int Seeks;
  int ChannelTell;
  int Engine;
  int Background;
};

class WindowGeometry {
 public:
  WindowGeometry(int a,int b,int c,int d);
  WindowGeometry();

  void write(FILE *f);
  void read(TString &t);

  void retrieve(GtkWidget *w);
  bool isNull();
  void setNull();
  int X,Y,W,H;
};

class Desktop {
 public:

  void clear();
  void write(FILE *f);
  void read(TString &t);

  void writeConsoles(FILE *f, const char *key);
  void readConsole(TString &t);

  void addConsole(DetachedConsole *dc);
  void spawnConsoles(TextSet *ts);

  WindowGeometry wMain, wGames, wLocal, wAds;

 private:
  vector<WindowGeometry *> consoles;
  vector<string *> cfilters;
};

class Global : public ChannelSplitter {
 public:
  Global();
  
  ChessGame * getGame(int num);
  void removeBoard(Board *b);
  int  nextFreeGameId(int base);
  void repaintAllBoards();

  void appendGame(ChessGame *cg,bool RenumberDupes=true);
  void prependGame(ChessGame *cg,bool RenumberDupes=true);

  void statOS();
  void ensureDirectories();
  void readRC();
  void writeRC();

  void addHostBookmark(HostBookmark *hbm);

  void WrappedMainIteration();
  void WrappedMainQuit();
  void LogAppend(char *msg);
  void debug(char *klass,char *method,char *data=0);

  void dumpGames();
  void dumpBoards();
  void dumpPanes();

  void gatherConsoleState();

  void addAgent(NetConnection *ag);
  void removeAgent(NetConnection *ag);
  void agentBroadcast(char *z);
  int  receiveAgentLine(char *dest,int limit);

  void opponentMoved();
  void drawOffered();
  void privatelyTold();
  void flushSound();
  void setPasswordMode(int pm);
  //  void clearSoundStack();

  void updateScrollBacks();

  bool hasSoundFile(char *p);

  Notebook * getNotebook();

  // free with free() as usual
  static void * safeMalloc(int nbytes);

  list<ChessGame *> GameList;
  list<ChessGame *>::iterator GLi;
  list<Board *> BoardList;
  list<Board *>::iterator BLi;
  list<int> TheOffspring;

  list<NetConnection *> Agents;
  list<DetachedConsole *> Consoles;

  InputHandler       *input;
  OutputPane         *output;
  NetConnection      *network;
  Status             *status;
  ProtocolParser     *protocol;
  ConnectionHandler  *chandler;
  PieceProvider      *promotion;
  Notebook           *ebook;
  SeekGraph          *skgraph;
  History            *inputhistory;

  SoundSlave         sndslave;

  int                SelfInputColor;

  int HilightLastMove;
  int AnimateMoves;
  int Premove;

  int TabPos; // 0=R 1=L 2=T 3=B

  char ClockFont[96];
  char PlayerFont[96];
  char InfoFont[96];
  char ConsoleFont[96];

  int PlainSquares;
  int LightSqColor;
  int DarkSqColor;
  int AntialiasPieces;

  int ShowRating;
  int ScrollBack;
  int FicsAutoLogin;
  int IcsSeekGraph;
  int HideSeeks;
  int BeepWhenOppMoves;
  int EnableSounds;
  int VectorPieces;
  int CheckLegality;

  int SplitChannels;
  int ChannelsToConsoleToo;
  int DrawHouseStock;

  int AppendPlayed;
  int AppendObserved;
  char AppendFile[128];

  int PopupSecondaryGames;
  int SmartDiscard;

  int ShowCoordinates;

  TerminalColor Colors;
  Desktop Desk;
  
  // 0=opponent moved, 1=draw offer 2=pvt tell
  SoundEvent sndevents[3];

  int CommLog;
  int DebugLog;
  int PauseLog;

  int Quitting;

  list<HostBookmark *> HostHistory;

  vector<string> SoundFiles;

  char * Version;
  char   SystemType[64];
  char   argv0[512];
 private:
  int createDir(char *z);
  void renumberGame(ChessGame *cg,int id);
  void clearDupes(ChessGame *cg);

  int MainLevel;
  int QuitPending;

  vector<const char *> RCKeys;
  stack<int> SoundStack;
};

#ifndef GLOBAL_CC
extern Global global;
#endif

#endif
