
#ifndef CLOCK_H
#define CLOCK_H 1

#include <gtk/gtk.h>
#include "stl.h"
#include "eboard.h"
#include "time.h"

class ClockHost {
 public:
  virtual void updateClock()=0;
};

class ChessClock : public UpdateInterface {
 public:
  ChessClock();
  ~ChessClock();

  void setClock(int whitesec,int blacksec,int activep,int countdown);
  void setHost(ClockHost *hostp);
  void setAnotherHost(ClockHost *hostp);
  void setMirror(ChessClock *dest);
  int  getActive();
  int  getValue(int black);

  void update();
  
  int id;  

 private:
  int value[2],val_ref[2];
  time_t t_ref[2];
  int active;
  int countdownf;
  ClockHost *host, *host2;
  ChessClock *mirror;

  static int freeid;
};


class ClockMaster {
 public:
  ClockMaster();
  void append(ChessClock *clockp);
  void remove(ChessClock *clockp);

 private:
  void update();

  list<ChessClock *> clocks;
  int timeout_on;
  int timeout_id;

  friend gint clockmaster_timeout(gpointer data);
};


#endif
