/* ape_tag.c */
/*
 *  EasyTAG - Tag editor for MP3, Ogg Vorbis and MPC files
 *  Copyright (C) 2001-2003  Jerome Couderc <j.couderc@ifrance.com>
 *  Copyright (C) 2002-2003  Artur Polaczyski <artii@o2.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h> 


#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>

#include "easytag.h"
#include "ape_tag.h"
#include "et_core.h"
#include "misc.h"
#include "setting.h"
#include "charset.h"
#include "i18n.h"
#include "libapetag/apetaglib.h"

/***************
 * Declaration *
 ***************/



/**************
 * Prototypes *
 **************/
gboolean Ape_Tag_Write_File (FILE *file_in, gchar *filename_in);


/*************
 * Functions *
 *************/

/*
 * Note:
 *  - if field is found but contains no info (strlen(str)==0), we don't read it
 */
gboolean Ape_Tag_Read_File_Tag (gchar * filename, File_Tag * FileTag)
{
    FILE *file;
    gchar *string = NULL;
    gchar *string1 = NULL;
    apetag *ape_cnt;

    if (!filename || !FileTag)
        return FALSE;

    if ((file = fopen(filename, "rb")) == NULL) {
        g_print(_("ERROR while opening file: '%s' (%s).\n\a"),filename, g_strerror(errno));
        return FALSE;
    }

    ape_cnt = apetag_init();
    apetag_read_fp(ape_cnt, file, filename, 0); /* read all tags ape,id3v[12]*/

    /*********
     * Title *
     *********/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_TITLE));
    if (FileTag->title == NULL)
        FileTag->title = g_strdup(string);
    g_free(string);

    /**********
     * Artist *
     **********/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_ARTIST));
    if (FileTag->artist == NULL)
        FileTag->artist = g_strdup(string);
    g_free(string);

    /*********
     * Album *
     *********/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_ALBUM));
    if (FileTag->album == NULL)
        FileTag->album = g_strdup(string);
    g_free(string);

    /********
     * Year *
     ********/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_YEAR));
    FileTag->year = g_strdup(string);
    g_free(string);

    /*************************
     * Track and Total Track *
     *************************/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_TRACK));
    if (string) {
        string1 = strchr(string, '/');    // strchr don't like NULL string 
        if (NUMBER_TRACK_FORMATED) {
            if (string1) {
                FileTag->track_total =
                    g_strdup_printf("%.*d",NUMBER_TRACK_FORMATED_SPIN_BUTTON, atoi(string1 + 1));
                *string1 = '\0';
            }
            FileTag->track = g_strdup_printf("%.*d",NUMBER_TRACK_FORMATED_SPIN_BUTTON, atoi(string));
        } else {
            if (string1) {
                FileTag->track_total = g_strdup(string1 + 1);
                *string1 = '\0';
            }
            FileTag->track = g_strdup(string);
        }
    } else
        FileTag->track = FileTag->track_total = NULL;
    g_free(string);

    /*********
     * Genre *
     *********/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_GENRE));
    if (FileTag->genre == NULL)
        FileTag->genre = g_strdup(string);
    g_free(string);

    /***********
     * Comment *
     ***********/
    string = convert_from_utf8(apefrm_getstr(ape_cnt, APE_TAG_FIELD_COMMENT));
    if (FileTag->comment == NULL)
        FileTag->comment = g_strdup(string);
    g_free(string);


    apetag_free(ape_cnt);
    fclose(file);

    return TRUE;
}



gboolean Ape_Tag_Write_File_Tag (ET_File *ETFile)
{

    File_Tag *FileTag;
    gchar    *filename_in;
    //FILE     *file_in;
    gchar    *string, *string1;
    //GList    *list;
    apetag   *ape_mem;

    if (!ETFile || !ETFile->FileTag)
        return FALSE;

    FileTag     = (File_Tag *)ETFile->FileTag->data;
    filename_in = ((File_Name *)ETFile->FileNameCur->data)->value;


    ape_mem = apetag_init();
    
// ************************************************************
    
    /*********
     * Title *
     *********/
    if ( FileTag->title && strlen(FileTag->title)!=0)
    {
        string = convert_to_utf8(FileTag->title);
        apefrm_add (ape_mem, 0, APE_TAG_FIELD_TITLE  , string) ;
        g_free(string);

    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_TITLE);
    }

    /**********
     * Artist *
     **********/
    if ( FileTag->artist && strlen(FileTag->artist)!=0)
    {
        string = convert_to_utf8(FileTag->artist);
        apefrm_add (ape_mem, 0 , APE_TAG_FIELD_ARTIST , string) ;
        g_free(string);
    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_ARTIST);
    }

    /*********
     * Album *
     *********/
    if ( FileTag->album && strlen(FileTag->album)!=0)
    {
        string = convert_to_utf8(FileTag->album);
        apefrm_add (ape_mem, 0 , APE_TAG_FIELD_ALBUM , string) ;
        g_free(string);
    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_ALBUM);
    }

    /********
     * Year *
     ********/
    if ( FileTag->year && strlen(FileTag->year)!=0)
    {
        string = convert_to_utf8(FileTag->year);
        apefrm_add (ape_mem, 0 , APE_TAG_FIELD_YEAR , string) ;
        g_free(string);
    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_YEAR);
    }

    /*************************
     * Track and Total Track *
     *************************/
    if ( FileTag->track && strlen(FileTag->track)!=0)
    {
        if ( FileTag->track_total && strlen(FileTag->track_total)>0 )
            string = g_strconcat(FileTag->track,"/",FileTag->track_total,NULL);
        else
            string = g_strconcat(FileTag->track,NULL);
        string1 = convert_to_utf8(string);
        apefrm_add (ape_mem, 0 , APE_TAG_FIELD_TRACK , string1) ;
        g_free(string);
        g_free(string1);
    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_TRACK);
    }

    /*********
     * Genre *
     *********/
    if ( FileTag->genre && strlen(FileTag->genre)!=0)
    {
        string = convert_to_utf8(FileTag->genre);
        apefrm_add (ape_mem, 0 , APE_TAG_FIELD_GENRE , string) ;
        g_free(string);
    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_GENRE);
    }

    /***********
     * Comment *
     ***********/
    if ( FileTag->comment && strlen(FileTag->comment)!=0)
    {
        string = convert_to_utf8(FileTag->comment);
        apefrm_add (ape_mem, 0 , APE_TAG_FIELD_COMMENT , string) ;
        g_free(string);
    }else
    {
        apefrm_remove(ape_mem,APE_TAG_FIELD_COMMENT);
    }
    
// ************************************************************    
    
    /* reread all tag-type again  excl. changed frames by apefrm_remove() */
    apetag_save(filename_in,ape_mem,APE_TAG_V2+SAVE_NEW_OLD_APE_TAG);
    apetag_free(ape_mem);
  
    return TRUE;
}
