%define    name      easytag
%define    version   0.30
%define    release   1
%define    prefix    /usr

Summary:       Tag editor for MP3 and Ogg Vorbis files.
Summary(fr):   Editeur de tags pour fichiers MP3 et Vorbis Ogg.
Name:          %name
Version:       %version
Release:       %release
Copyright:     GPL
URL:           http://easytag.sourceforge.net
Group:         Applications/Multimedia
Source:        http://prdownloads.sourceforge.net/easytag/%{name}-%{version}.tar.bz2
BuildRoot:     /var/tmp/%name-buildroot
Vendor:        Jerome Couderc <j.couderc@ifrance.com>
Packager:      Jerome Couderc <j.couderc@ifrance.com>
Requires:      gtk+      >= 1.2.7
Requires:      id3lib    >= 3.7.12
Requires:      libogg    >= 1.0
Requires:      libvorbis >= 1.0
BuildRequires: gtk+-devel      >= 1.2.7
BuildRequires: id3lib-devel    >= 3.7.12
BuildRequires: libogg-devel    >= 1.0
BuildRequires: libvorbis-devel >= 1.0
Prefix:        %prefix

%description
EasyTAG is an utility for viewing and editing tags for MP3, MP2, FLAC, Ogg Vorbis,
MusePack and Monkey's Audio files. Its simple and nice GTK+ interface makes
tagging easier under GNU/Linux.

Features:
  * View and edit ID3 tags of MP3, MP2, FLAC files (supporting ID3v2 and ID3v1.x
    specifications), Ogg Vorbis files, and APE tag for MusePack and Monkey's
    Audio files,
  * Auto tagging: parse filename and directory to complete automatically the
    fields (using masks),
  * Ability to rename files from the tag (using masks) or by loading a text file,
  * Process selected files of the selected directory,
  * Ability to browse subdirectories,
  * Recursion for tagging, removing, renaming, saving...,
  * Can set a field (artist, title,...) to all other selected files,
  * Read file header informations (bitrate, time, ...) and display them,
  * Undo and redo last changes,
  * Ability to process fields of tag and file name (convert letters into
    uppercase, downcase, ...),
  * Ability to open a directory or a file with an external program,
  * CDDB support (from http protocol),
  * A tree based browser,
  * A list to select files,
  * A playlist generator window,
  * A file searching window,
  * Simple and explicit interface!,
  * French, German, Russian, Dutch, Hungarian, Swedish, Italian, Japanese,
    Ukrainian, Czech, Spanish, Polish and Romanian translation language,
  * Written in C and uses GTK+ 1.2 for the GUI.

#%description -l fr
#

%prep
%setup

%build
./configure --prefix=%{prefix} --disable-flac
make

%install
rm -rf ${RPM_BUILD_ROOT}
make prefix=${RPM_BUILD_ROOT}%{prefix} install

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/X11/applnk/Multimedia
cat > $RPM_BUILD_ROOT%{_sysconfdir}/X11/applnk/Multimedia/easytag.desktop <<EOF
[Desktop Entry]
Name=EasyTAG
Comment=An utility for viewing/editing MP3 and Ogg Vorbis tags with a GTK+ GUI.
TryExec=easytag
Exec=easytag
Icon=EasyTAG.xpm
Terminal=0
Type=Application
EOF
chmod 0644 $RPM_BUILD_ROOT%{_sysconfdir}/X11/applnk/Multimedia/easytag.desktop

%post

%postun

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-, root, root)
%doc ChangeLog INSTALL COPYING README TODO THANKS USERS-GUIDE
%prefix/bin/easytag
%prefix/share/gnome/apps/Multimedia/easytag.desktop
%{_sysconfdir}/X11/applnk/Multimedia/easytag.desktop
%prefix/share/pixmaps/*
%prefix/man/*/easytag.*
%prefix/share/easytag/*
%prefix/share/locale/*/*/*


%changelog
* Mon Dec 31 2002 Jerome Couderc <j.couderc@ifrance.com>
  - Added man page

* Fri Aug 9 2002 Jerome Couderc <j.couderc@ifrance.com>
  - Added swith --disable-flac in the build section

* Thu Dec 18 2001 Jerome Couderc <j.couderc@ifrance.com>
  - Updated for (Build)Requires entries

* Thu Sep 22 2001 Jerome Couderc <j.couderc@ifrance.com>
  - Updated for /etc/X11/applnk/Multimedia/easytag.desktop

* Thu Sep 20 2001 Gtz Waschk <waschk@linux-mandrake.com> 0.15.1-1
  - Updated for autoconf

* Fri Jun 2 2000 Jerome Couderc <j.couderc@ifrance.com>
  - Updated to include po files into the rpm package

* Fri May 5 2000 Jerome Couderc <j.couderc@ifrance.com>
  - Initial spec file.
