/* prefs.c - 2000/05/06 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000-2002  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <errno.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <string.h>

#include "prefs.h"
#include "setting.h"
#include "msgbox.h"
#include "bar.h"
#include "misc.h"
#include "scan.h"
#include "easytag.h"
#include "browser.h"
#include "cddb.h"
#include "charset.h"
#include "i18n.h"
#include "../pixmaps/grab.xpm"


/***************
 * Declaration *
 ***************/
static GtkWidget *FileSelectionWindow = NULL;



/**************
 * Prototypes *
 **************/
/* Options window */
void OptionsWindow_Quit          (void);
void OptionsWindow_Ok_Button     (void);
void OptionsWindow_Save_Button   (void);
void OptionsWindow_Cancel_Button (void);
void OptionsWindow_Key_Press     (GtkWidget *window, GdkEvent *event);
gint Check_Config                (void);

void Set_Main_Window_Size_Toggled      (void);
void Get_Main_Window_Size              (void);
void Set_Pane_Handle_Position1_Toggled (void);
void Get_Pane_Handle_Position1         (void);
void Set_Pane_Handle_Position2_Toggled (void);
void Get_Pane_Handle_Position2         (void);

void Scanner_Window_Position_Check_Button_Toggled (void);
void Get_Scanner_Window_Position                  (void);

void Get_Cddb_Window_Size                  (void);
void Get_Cddb_Pane_Handle_Position         (void);
void Set_Cddb_Window_Size_Toggled          (void);
void Set_Cddb_Pane_Handle_Position_Toggled (void);

void Set_Default_Comment_Check_Button_Toggled (void);
void Use_Character_Set_Translation_Toggled    (void);
void Scanner_Convert_Check_Button_Toggled_1   (GtkObject *object_rec, GtkObject *object_emi);
void Cddb_Use_Proxy_Toggled                   (void);

void Sorting_File_Option_Menu_Activate_Item (GtkWidget *widget, ET_Sorting_Type *st);
void Browser_Line_Style_Option_Menu_Activate_Item (GtkWidget *widget, GtkCTreeLineStyle line_style);
void Browser_Expander_Style_Option_Menu_Activate_Item (GtkWidget *widget, GtkCTreeExpanderStyle expander_style);

/* Browser */
static void Open_File_Selection_Window (GtkWidget *combo, gchar *title, gboolean enable_file);
void        File_Selection_Window_For_File      (GtkWidget *combo);
void        File_Selection_Window_For_Directory (GtkWidget *combo);
static void File_Selection_Window_Ok_Button     (GtkWidget *widget);
void        File_Selection_Window_Destroy       (void);


/*************
 * Functions *
 *************/
void Init_OptionsWindow (void)
{
    OptionsWindow = (GtkWidget *)NULL;
}

/*
 * The window for options
 */
void Open_OptionsWindow (void)
{
    GtkWidget *OptionsVBox;
    GtkWidget *ButtonBox;
    GtkWidget *Button;
    GtkWidget *Label;
    GtkWidget *Frame;
    GtkWidget *Table;
    GtkWidget *VBox, *vbox;
    GtkWidget *HBox, *hbox;
    GtkWidget *Separator;
    GtkWidget *Menu, *MenuItem;
    GtkTooltips *Tips;
    gchar temp[MAX_STRING_LEN];
    gchar *msg;
    GList *History_List;
    GList *list = NULL;

    /* Check if already opened */
    if (OptionsWindow)
    {
        gdk_window_show(OptionsWindow->window);
        return;
    }

    /* The window */
    OptionsWindow = gtk_window_new(GTK_WINDOW_DIALOG);
    /* Config */
    gtk_window_set_position(GTK_WINDOW(OptionsWindow),GTK_WIN_POS_CENTER);
    gtk_window_set_policy(GTK_WINDOW(OptionsWindow),FALSE,FALSE,FALSE);
    gtk_window_set_transient_for(GTK_WINDOW(OptionsWindow),GTK_WINDOW(MainWindow));
    gtk_container_border_width(GTK_CONTAINER(OptionsWindow),5);
    /* Title */
    gtk_window_set_title(GTK_WINDOW(OptionsWindow),_("Preferences..."));

    /* Signals connection */
    gtk_signal_connect(GTK_OBJECT(OptionsWindow),"destroy",(GtkSignalFunc)OptionsWindow_Quit,NULL);
    gtk_signal_connect(GTK_OBJECT(OptionsWindow),"delete_event",(GtkSignalFunc)OptionsWindow_Quit,NULL);
    gtk_signal_connect(GTK_OBJECT(OptionsWindow),"key_press_event",
                (GtkSignalFunc)OptionsWindow_Key_Press,NULL);

    Tips = gtk_tooltips_new_1();

     /* Options */
     /* The vbox */
    OptionsVBox = gtk_vbox_new(FALSE,0);
    gtk_box_set_spacing (GTK_BOX(OptionsVBox),5);
    gtk_container_add(GTK_CONTAINER(OptionsWindow),OptionsVBox);

     /* Options NoteBook */
    OptionsNoteBook = gtk_notebook_new();
    gtk_notebook_popup_enable(GTK_NOTEBOOK(OptionsNoteBook));
    gtk_box_pack_start(GTK_BOX(OptionsVBox),OptionsNoteBook,TRUE,TRUE,0);



    /*
     * Common
     */
    Label = gtk_label_new(_("Common"));
    Frame = gtk_frame_new(_("Common"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),5);


    /* File Browser frame */
    Frame = gtk_frame_new (_("File Browser"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    /* Browse subdirectories */
    BrowseSubdir = gtk_check_button_new_with_label(_("Search subdirectories"));
    gtk_box_pack_start(GTK_BOX(vbox),BrowseSubdir,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(BrowseSubdir),BROWSE_SUBDIR);
    gtk_tooltips_set_tip(Tips,BrowseSubdir,_("Search subdirectories for files when reading "
        "a directory into the tree."),NULL);

    /* Load directory on startup */
    // Check box
    LoadOnStartup = gtk_check_button_new_with_label(_("Load on startup the directory"));
    gtk_box_pack_start(GTK_BOX(vbox),LoadOnStartup,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(LoadOnStartup),LOAD_ON_STARTUP);
    gtk_tooltips_set_tip(Tips,LoadOnStartup,_("Automatically search files, when EasyTAG starts, "
        "into the following directory. Note that this path may be overriden by the parameter "
        "passed to easytag (easytag /path_to/mp3_files)."),NULL);

    HBox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(vbox),HBox,FALSE,FALSE,2);
    gtk_container_border_width(GTK_CONTAINER(HBox),2);
    // Combo
    DefaultPathToMp3 = gtk_combo_new();
    gtk_combo_set_case_sensitive(GTK_COMBO(DefaultPathToMp3),TRUE);
    gtk_box_pack_start(GTK_BOX(HBox),DefaultPathToMp3,TRUE,TRUE,0);
    gtk_widget_set_usize(DefaultPathToMp3,400,-1);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(DefaultPathToMp3)->entry,_("Specify the directory where "
        "your files are located. This path will be loaded when EasyTAG starts without parameter."),NULL);
    // History list
    History_List = Load_Default_Path_To_MP3_List();
    History_List = Add_String_To_Glist (History_List,DEFAULT_PATH_TO_MP3);
    if (History_List)
        gtk_combo_set_popdown_strings(GTK_COMBO(DefaultPathToMp3),History_List);
    gtk_object_set_data(GTK_OBJECT(DefaultPathToMp3),"History",History_List);
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultPathToMp3)->entry)),"activate",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultPathToMp3));
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultPathToMp3)->entry)),"focus_out_event",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultPathToMp3));

    // Button browse
    Button = gtk_button_new_with_label(_(" Browse... "));
    gtk_box_pack_start(GTK_BOX(HBox),Button,FALSE,FALSE,0);
    gtk_object_set_data(GTK_OBJECT(DefaultPathToMp3),"Parent_Window",OptionsWindow);
    gtk_signal_connect_object(GTK_OBJECT(Button),"clicked",
        (GtkSignalFunc)File_Selection_Window_For_Directory,GTK_OBJECT(DefaultPathToMp3));

    /* Open the node to show subdirectories */
    OpenSelectedBrowserNode = gtk_check_button_new_with_label(_("Show sub-directories when selecting "
        "a directory"));
    gtk_box_pack_start(GTK_BOX(vbox),OpenSelectedBrowserNode,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(OpenSelectedBrowserNode),OPEN_SELECTED_BROWSER_NODE);
    gtk_tooltips_set_tip(Tips,OpenSelectedBrowserNode,_("This expands the selected node into the file "
        "browser to display the sub-directories."),NULL);

    /* Load directory on startup */
    KeepTreeBrowserInMemory = gtk_check_button_new_with_label(_("Keep the tree browser in memory"));
    gtk_box_pack_start(GTK_BOX(vbox),KeepTreeBrowserInMemory,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(KeepTreeBrowserInMemory),KEEP_TREE_BROWSER_IN_MEMORY);
    gtk_tooltips_set_tip(Tips,KeepTreeBrowserInMemory,_("If activated, the subdirectories of a node "
        "aren't regenerated when collapsing and re-expanding this node."),NULL);


    HBox = gtk_hbox_new(FALSE,2);
    gtk_box_pack_start(GTK_BOX(vbox),HBox,FALSE,FALSE,0);
    gtk_container_border_width(GTK_CONTAINER(HBox),2);
    /* Browser Style (line and expander) */
    Label = gtk_label_new(_("Browser style  "));
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);

    Label = gtk_label_new(_("Line style :"));
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,2);
    BrowserLineStyleOptionMenu = gtk_option_menu_new();
    gtk_box_pack_start(GTK_BOX(HBox),BrowserLineStyleOptionMenu,FALSE,FALSE,0);
    gtk_widget_set_usize(GTK_WIDGET(BrowserLineStyleOptionMenu),100,25);
    // Items of option menu
    Menu = gtk_menu_new();
    MenuItem = gtk_menu_item_new_with_label(_("None"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Line_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_LINES_NONE));
    MenuItem = gtk_menu_item_new_with_label(_("Solid"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Line_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_LINES_SOLID));
    MenuItem = gtk_menu_item_new_with_label(_("Dotted"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Line_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_LINES_DOTTED));
    MenuItem = gtk_menu_item_new_with_label(_("Tabbed"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Line_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_LINES_TABBED));
    gtk_option_menu_set_menu(GTK_OPTION_MENU(BrowserLineStyleOptionMenu),Menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(BrowserLineStyleOptionMenu),BROWSER_LINE_STYLE);
    gtk_tooltips_set_tip(Tips,BrowserLineStyleOptionMenu,_("Select the style of the line in the browser tree."),NULL);

    Label = gtk_label_new(_("Expander style :"));
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,2);
    BrowserExpanderStyleOptionMenu = gtk_option_menu_new();
    gtk_box_pack_start(GTK_BOX(HBox),BrowserExpanderStyleOptionMenu,FALSE,FALSE,0);
    gtk_widget_set_usize(GTK_WIDGET(BrowserExpanderStyleOptionMenu),100,25);
    // Items of option menu
    Menu = gtk_menu_new();
    MenuItem = gtk_menu_item_new_with_label(_("None"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Expander_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_EXPANDER_NONE));
    MenuItem = gtk_menu_item_new_with_label(_("Square"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Expander_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_EXPANDER_SQUARE));
    MenuItem = gtk_menu_item_new_with_label(_("Triangle"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Expander_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_EXPANDER_TRIANGLE));
    MenuItem = gtk_menu_item_new_with_label(_("Circular"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Browser_Expander_Style_Option_Menu_Activate_Item,
        GINT_TO_POINTER(GTK_CTREE_EXPANDER_CIRCULAR));
    gtk_option_menu_set_menu(GTK_OPTION_MENU(BrowserExpanderStyleOptionMenu),Menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(BrowserExpanderStyleOptionMenu),BROWSER_EXPANDER_STYLE);
    gtk_tooltips_set_tip(Tips,BrowserExpanderStyleOptionMenu,_("Select the style of the expander in the browser tree."),NULL);


    /* Tag Rules frame */
    Frame = gtk_frame_new (_("ID3 Tag Rules"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);
    /* Write ID3v1 tag */
    WriteId3v1Tag = gtk_check_button_new_with_label(_("Write ID3v1.x tag"));
    gtk_box_pack_start(GTK_BOX(vbox),WriteId3v1Tag,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(WriteId3v1Tag),WRITE_ID3V1_TAG);
    gtk_tooltips_set_tip(Tips,WriteId3v1Tag,_("If activated, an ID3v1 tag will be added or "
        "updated at the end of the MP3 files. Else it will be stripped."),NULL);
    /* Write ID3v2 tag */
    WriteId3v2Tag = gtk_check_button_new_with_label(_("Write ID3v2 tag"));
    gtk_box_pack_start(GTK_BOX(vbox),WriteId3v2Tag,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(WriteId3v2Tag),WRITE_ID3V2_TAG);
    gtk_tooltips_set_tip(Tips,WriteId3v2Tag,_("If activated, an ID3v2 tag will be added or "
        "updated at the beginning of the MP3 files. Else it will be stripped."),NULL);
    /* Strip tag when fields (managed by EasyTAG) are empty */
    StripTagWhenEmptyFields = gtk_check_button_new_with_label(_("Strip tags if all fields are set to blank"));
    gtk_box_pack_start(GTK_BOX(vbox),StripTagWhenEmptyFields,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(StripTagWhenEmptyFields),STRIP_TAG_WHEN_EMPTY_FIELDS);
    gtk_tooltips_set_tip(Tips,StripTagWhenEmptyFields,_("As ID3v2 tags may contain other data than "
        "Title, Artist, Album, Year, Track, Genre or Comment (as an attached picture, lyrics, ...), "
        "this option allows you to strip the whole tag when these seven standard data fields have "
        "been set to blank."),NULL);
    /* Convert old ID3v2 tag version */
    ConvertOldId3v2TagVersion = gtk_check_button_new_with_label(_("Automatically convert old ID3v2 tag versions"));
    gtk_box_pack_start(GTK_BOX(vbox),ConvertOldId3v2TagVersion,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConvertOldId3v2TagVersion),CONVERT_OLD_ID3V2_TAG_VERSION);
    gtk_tooltips_set_tip(Tips,ConvertOldId3v2TagVersion,_("If activated, an old ID3v2 tag version (as "
        "ID3v2.2) will be updated to the ID3v2.3 version."),NULL);

    /* Save configuration */
    SaveConfigBeforeExit = gtk_check_button_new_with_label(_("Save the configuration before "
        "exiting the program"));
    gtk_box_pack_start(GTK_BOX(VBox),SaveConfigBeforeExit,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SaveConfigBeforeExit),SAVE_CONFIG_BEFORE_EXIT);
    gtk_tooltips_set_tip(Tips,SaveConfigBeforeExit,_("If activated, the configuration will be "
        "automatically saved before exiting the program."),NULL);



    /*
     * User Interface
     */
    Label = gtk_label_new (_("User Interface"));
    Frame = gtk_frame_new (_("User Interface"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),2);

    Table = gtk_table_new(6,3,FALSE);
    gtk_box_pack_start(GTK_BOX(VBox),Table,FALSE,FALSE,0);
    gtk_table_set_row_spacings(GTK_TABLE(Table),2);
    gtk_table_set_col_spacings(GTK_TABLE(Table),4);

    // Main window size
    SetMainWindowSize = gtk_check_button_new_with_label(_("Set main window size"));
    gtk_table_attach(GTK_TABLE(Table),SetMainWindowSize,0,1,0,1,GTK_FILL,GTK_FILL,0,0);
    Label = gtk_label_new (_("Width :"));
    gtk_table_attach(GTK_TABLE(Table),Label,1,2,0,1,GTK_FILL,GTK_FILL,0,0);
    MainWindowWidth = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),MainWindowWidth,2,3,0,1,GTK_FILL,GTK_FILL,0,0);
    Label = gtk_label_new (_("Height :"));
    gtk_table_attach(GTK_TABLE(Table),Label,3,4,0,1,GTK_FILL,GTK_FILL,0,0);
    MainWindowHeight = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),MainWindowHeight,4,5,0,1,GTK_FILL,GTK_FILL,0,0);
    MainWindowButton = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current size "));
    gtk_table_attach(GTK_TABLE(Table),MainWindowButton,5,6,0,1,GTK_FILL,GTK_FILL,0,0);
    gtk_signal_connect (GTK_OBJECT(MainWindowButton),"clicked",(GtkSignalFunc)Get_Main_Window_Size,NULL);
    gtk_widget_set_usize(MainWindowHeight,40,-1);
    gtk_widget_set_usize(MainWindowWidth,40,-1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetMainWindowSize),SET_MAIN_WINDOW_SIZE);
    sprintf(temp,"%i",MAIN_WINDOW_HEIGHT);
    gtk_entry_set_text(GTK_ENTRY(MainWindowHeight),temp);
    sprintf(temp,"%i",MAIN_WINDOW_WIDTH);
    gtk_entry_set_text(GTK_ENTRY(MainWindowWidth),temp);
    gtk_signal_connect(GTK_OBJECT(MainWindowHeight),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    gtk_signal_connect(GTK_OBJECT(MainWindowWidth),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    /* Placed at the end of the block cause we must have all widgets built */
    gtk_signal_connect(GTK_OBJECT(SetMainWindowSize),"toggled",GTK_SIGNAL_FUNC(Set_Main_Window_Size_Toggled),NULL);
    Set_Main_Window_Size_Toggled();
    msg = g_strdup_printf(_("Specify the default size for the main window. You must restart the "
        "program to apply the new size. For your display, the max values are: width=%d and height=%d."),
        gdk_screen_width(),gdk_screen_height());
    gtk_tooltips_set_tip(Tips,SetMainWindowSize,msg,NULL);
    gtk_tooltips_set_tip(Tips,MainWindowWidth,_("Width: set -1 for automatic size"),NULL);
    gtk_tooltips_set_tip(Tips,MainWindowHeight,_("Heigth: set -1 for automatic size"),NULL);
    g_free(msg);

    /* Pane handle position 1 */
    SetPaneHandlePosition1 = gtk_check_button_new_with_label(_("Set right pane handle position"));
    gtk_table_attach(GTK_TABLE(Table),SetPaneHandlePosition1,0,2,1,2,GTK_FILL,GTK_FILL,0,0);
    Label = gtk_label_new (_("Position :"));
    gtk_table_attach(GTK_TABLE(Table),Label,2,4,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    PaneHandlePosition1 = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),PaneHandlePosition1,4,5,1,2,GTK_FILL,GTK_FILL,0,0);
    sprintf(temp,"%i",PANE_HANDLE_POSITION1);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition1),temp);
    gtk_signal_connect(GTK_OBJECT(PaneHandlePosition1),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    PaneHandleButton1 = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_table_attach(GTK_TABLE(Table),PaneHandleButton1,5,6,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_signal_connect (GTK_OBJECT(PaneHandleButton1),"clicked",(GtkSignalFunc)Get_Pane_Handle_Position1,NULL);
    gtk_widget_set_usize(PaneHandlePosition1,40,-1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetPaneHandlePosition1),SET_PANE_HANDLE_POSITION1);
    gtk_tooltips_set_tip(Tips,SetPaneHandlePosition1,_("Specify the default position for the pane handle "
        "located between the browser frame and the tag frame. Changes will be applied the next start."),NULL);
    gtk_tooltips_set_tip(Tips,PaneHandlePosition1,_("Position: set -1 for automatic positioning"),NULL);
    gtk_signal_connect(GTK_OBJECT(SetPaneHandlePosition1),"toggled",
        GTK_SIGNAL_FUNC(Set_Pane_Handle_Position1_Toggled),NULL);
    Set_Pane_Handle_Position1_Toggled();

    /* Pane handle position 2 */
    SetPaneHandlePosition2 = gtk_check_button_new_with_label(_("Set left pane handle position"));
    gtk_table_attach(GTK_TABLE(Table),SetPaneHandlePosition2,0,2,2,3,GTK_FILL,GTK_FILL,0,0);
    Label = gtk_label_new (_("Position :"));
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    gtk_table_attach(GTK_TABLE(Table),Label,2,4,2,3,GTK_FILL,GTK_FILL,0,0);
    PaneHandlePosition2 = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),PaneHandlePosition2,4,5,2,3,GTK_FILL,GTK_FILL,0,0);
    sprintf(temp,"%i",PANE_HANDLE_POSITION2);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition2),temp);
    gtk_signal_connect(GTK_OBJECT(PaneHandlePosition2),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    PaneHandleButton2 = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_table_attach(GTK_TABLE(Table),PaneHandleButton2,5,6,2,3,GTK_FILL,GTK_FILL,0,0);
    gtk_signal_connect (GTK_OBJECT(PaneHandleButton2),"clicked",(GtkSignalFunc)Get_Pane_Handle_Position2,NULL);
    gtk_widget_set_usize(PaneHandlePosition2,40,-1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetPaneHandlePosition2),SET_PANE_HANDLE_POSITION2);
    gtk_tooltips_set_tip(Tips,SetPaneHandlePosition2,_("Specify the default position for the pane handle "
        "located between the browser tree and the list of files. Changes will be applied the next start."),NULL);
    gtk_tooltips_set_tip(Tips,PaneHandlePosition2,_("Position: set -1 for automatic positioning"),NULL);
    gtk_signal_connect(GTK_OBJECT(SetPaneHandlePosition2),"toggled",
        GTK_SIGNAL_FUNC(Set_Pane_Handle_Position2_Toggled),NULL);
    Set_Pane_Handle_Position2_Toggled();

    /* Separator line */
    Separator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(VBox),Separator,FALSE,FALSE,0);

    ShowHeaderInfos = gtk_check_button_new_with_label(_("Show header informations of file"));
    gtk_box_pack_start(GTK_BOX(VBox),ShowHeaderInfos,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowHeaderInfos),SHOW_HEADER_INFO);
    gtk_tooltips_set_tip(Tips,ShowHeaderInfos,_("If activated, informations about the file as "
        "the bitrate, the time, the size, will be displayed under the filename entry."),NULL);

    /* Separator line */
    Separator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(VBox),Separator,FALSE,FALSE,0);

    /* Set yellow color to tooltips */
    UseColoredTooltips = gtk_check_button_new_with_label(_("Set yellow background for tooltips"));
    gtk_box_pack_start(GTK_BOX(VBox),UseColoredTooltips,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(UseColoredTooltips),USE_COLORED_TOOLTIPS);
    gtk_tooltips_set_tip(Tips,UseColoredTooltips,_("If activated, the background of tooltips will "
        "be yellow colored, overriding your window manager."),NULL);



    /*
     * Misc
     */
    Label = gtk_label_new (_("Misc"));
    Frame = gtk_frame_new (_("Misc"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),4);


    /* Filename Options */
    Frame = gtk_frame_new (_("Filename Options"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    ReplaceIllegalCharactersInFilename = gtk_check_button_new_with_label(_("Replace illegal characters in filename (for Windows and CD-Rom)"));
    gtk_box_pack_start(GTK_BOX(vbox),ReplaceIllegalCharactersInFilename,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ReplaceIllegalCharactersInFilename),REPLACE_ILLEGAL_CHARACTERS_IN_FILENAME);
    gtk_tooltips_set_tip(Tips,ReplaceIllegalCharactersInFilename,_("Convert illegal characters for "
        "FAT32/16 and ISO9660 + Joliet filesystems ('\\', ':', ';', '*', '?', '\"', '<', '>', '|') "
        "of the filename to avoid problem when renaming the file. This is usefull when renaming the "
        "file from the tag with the scanner."),NULL);


    /* Tag Options */
    Frame = gtk_frame_new (_("Tag Options"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    DateAutoCompletion = gtk_check_button_new_with_label(_("Auto completion of date if not complete"));
    gtk_box_pack_start(GTK_BOX(vbox),DateAutoCompletion,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(DateAutoCompletion),DATE_AUTO_COMPLETION);
    gtk_tooltips_set_tip(Tips,DateAutoCompletion,_("Try to complete the year field if you enter "
        "only the last numerals of the date (for instance, if the current year is 2005: "
        "5 => 2005, 4 => 2004, 6 => 1996, 95 => 1995, ...)."),NULL);

    NumberTrackFormated = gtk_check_button_new_with_label(_("Write the track field on two characters ('05', '09', '10', ...)"));
    gtk_box_pack_start(GTK_BOX(vbox),NumberTrackFormated,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(NumberTrackFormated),NUMBER_TRACK_FORMATED);
    gtk_tooltips_set_tip(Tips,NumberTrackFormated,_("If activated, the track field is written with "
        "two characters. Else it keeps the 'raw' track value."),NULL);

    OggTagWriteXmmsComment = gtk_check_button_new_with_label(_("OGG Files : Write also the comment to the XMMS format"));
    gtk_box_pack_start(GTK_BOX(vbox),OggTagWriteXmmsComment,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(OggTagWriteXmmsComment),OGG_TAG_WRITE_XMMS_COMMENT);
    gtk_tooltips_set_tip(Tips,OggTagWriteXmmsComment,_("XMMS doesn't make use of the right way to "
        "identify a comment in OGG files as other apps do. In fact, this field is usually labeled "
        "with 'comment=', whereas XMMS uses only `='. Please, uncheck this option if you don't want "
        "other apps to complain about an unknown field. Comments won't be shown in XMMS, though."),NULL);


    /* Sorting List Options */
    Frame = gtk_frame_new (_("Sorting List Options"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    hbox = gtk_hbox_new(FALSE,2);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
    gtk_container_border_width(GTK_CONTAINER(hbox),2);
    /* Sorting method */
    Label = gtk_label_new(_("Sort the file list by :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    SortingFileOptionMenu = gtk_option_menu_new();
    gtk_box_pack_start(GTK_BOX(hbox),SortingFileOptionMenu,FALSE,FALSE,0);
    gtk_widget_set_usize(GTK_WIDGET(SortingFileOptionMenu),260,25);
    // Items of option menu
    Menu = gtk_menu_new();
    MenuItem = gtk_menu_item_new_with_label(_("Ascending file name"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_FILENAME));
    MenuItem = gtk_menu_item_new_with_label(_("Descending file name"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_FILENAME));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending track number"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_TRACK_NUMBER));
    MenuItem = gtk_menu_item_new_with_label(_("Descending track number"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_TRACK_NUMBER));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending creation date"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_CREATION_DATE));
    MenuItem = gtk_menu_item_new_with_label(_("Descending creation date"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_CREATION_DATE));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending title"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_TITLE));
    MenuItem = gtk_menu_item_new_with_label(_("Descending title"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_TITLE));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending artist"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_ARTIST));
    MenuItem = gtk_menu_item_new_with_label(_("Descending artist"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_ARTIST));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending album"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_ALBUM));
    MenuItem = gtk_menu_item_new_with_label(_("Descending album"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_ALBUM));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending year"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_YEAR));
    MenuItem = gtk_menu_item_new_with_label(_("Descending year"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_YEAR));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending genre"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_GENRE));
    MenuItem = gtk_menu_item_new_with_label(_("Descending genre"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_GENRE));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending comment"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_COMMENT));
    MenuItem = gtk_menu_item_new_with_label(_("Descending comment"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_COMMENT));
    gtk_option_menu_set_menu(GTK_OPTION_MENU(SortingFileOptionMenu),Menu);
    // FIX ME : use a better method for selecting the option menu, because the
    // value '2' is an horizontal bar for example and musn't be selected!!!
    gtk_option_menu_set_history(GTK_OPTION_MENU(SortingFileOptionMenu),SORTING_FILE_MODE); // Cause items loaded in same order of enumeration
    gtk_tooltips_set_tip(Tips,SortingFileOptionMenu,_("Select the type of file sorting "
        "when loading a directory."),NULL);

    SortingFileCaseSensitive = gtk_check_button_new_with_label(_("Case sensitive"));
    gtk_box_pack_start(GTK_BOX(hbox),SortingFileCaseSensitive,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SortingFileCaseSensitive),SORTING_FILE_CASE_SENSITIVE);
    gtk_tooltips_set_tip(Tips,SortingFileCaseSensitive,_("If activated, the sorting of "
        "the list will be dependent on the case."),NULL);


    /* Character Set */
    Frame = gtk_frame_new (_("Character Set"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);

    vbox = gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    UseCharacterSetTranslation = gtk_check_button_new_with_label(_("Enable character set translation for ID3 tags"));
    gtk_box_pack_start(GTK_BOX(vbox),UseCharacterSetTranslation,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(UseCharacterSetTranslation),USE_CHARACTER_SET_TRANSLATION);
    gtk_tooltips_set_tip(Tips,UseCharacterSetTranslation,_("If activated, the character set "
        "translation is enabled for the files using ID3 tag (as mp3, mp2 and flac files)."),NULL);
    gtk_signal_connect_after(GTK_OBJECT(UseCharacterSetTranslation),"toggled",
        (GtkSignalFunc)Use_Character_Set_Translation_Toggled,NULL);

    // Combo boxes...
    hbox = gtk_hbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    Label = gtk_label_new(_("Convert character set from :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    FileCharacterSetEntry = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(hbox),FileCharacterSetEntry,TRUE,TRUE,0);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(FileCharacterSetEntry)->entry,_("Character set used for "
        "files on hard disk."),NULL);
    Label = gtk_label_new (_("to :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    UserCharacterSetEntry = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(hbox),UserCharacterSetEntry,TRUE,TRUE,0);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(UserCharacterSetEntry)->entry,_("Character set used to "
        "display tag data in the user interface."),NULL);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(FileCharacterSetEntry)->entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(UserCharacterSetEntry)->entry),FALSE);
    gtk_combo_set_value_in_list(GTK_COMBO(FileCharacterSetEntry),TRUE,FALSE);
    gtk_combo_set_value_in_list(GTK_COMBO(UserCharacterSetEntry),TRUE,FALSE);
    list = Charset_Create_List();
    gtk_combo_set_popdown_strings(GTK_COMBO(FileCharacterSetEntry),list);
    gtk_combo_set_popdown_strings(GTK_COMBO(UserCharacterSetEntry),list);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(FileCharacterSetEntry)->entry),Charset_Get_Title_From_Name(FILE_CHARACTER_SET));
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(UserCharacterSetEntry)->entry),Charset_Get_Title_From_Name(USER_CHARACTER_SET));
    //gtk_widget_set_usize(FileCharacterSetEntry,80,-1);
    //gtk_widget_set_usize(UserCharacterSetEntry,80,-1);
    Use_Character_Set_Translation_Toggled();

    /* Message Dialog Position */
    Frame = gtk_frame_new (_("Message Dialog Position"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    hbox = gtk_hbox_new(TRUE,4);
    gtk_container_add(GTK_CONTAINER(Frame),hbox);
    gtk_container_border_width(GTK_CONTAINER(hbox),4);

    MessageBoxPositionNone = gtk_radio_button_new_with_label(NULL,_("No particular position"));
    gtk_box_pack_start(GTK_BOX(hbox),MessageBoxPositionNone,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MessageBoxPositionNone),MESSAGE_BOX_POSITION_NONE);
    gtk_tooltips_set_tip(Tips,MessageBoxPositionNone,_("Let the Window Manager to place the windows."),NULL);

    MessageBoxPositionCenter = gtk_radio_button_new_with_label(
        gtk_radio_button_group(GTK_RADIO_BUTTON(MessageBoxPositionNone)),_("Center of the screen"));
    gtk_box_pack_start(GTK_BOX(hbox),MessageBoxPositionCenter,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MessageBoxPositionCenter),MESSAGE_BOX_POSITION_CENTER);
    gtk_tooltips_set_tip(Tips,MessageBoxPositionCenter,_("Windows should be placed in the center "
        "of the screen."),NULL);

    MessageBoxPositionMouse = gtk_radio_button_new_with_label(
        gtk_radio_button_group(GTK_RADIO_BUTTON(MessageBoxPositionNone)),_("Mouse position"));
    gtk_box_pack_start(GTK_BOX(hbox),MessageBoxPositionMouse,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MessageBoxPositionMouse),MESSAGE_BOX_POSITION_MOUSE);
    gtk_tooltips_set_tip(Tips,MessageBoxPositionMouse,_("Windows should be placed at the current "
        "mouse position."),NULL);

    /* File Player */
    Frame = gtk_frame_new (_("File Audio Player"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);

    // Player name with params
    hbox = gtk_hbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),hbox);
    gtk_container_border_width(GTK_CONTAINER(hbox),4);
    Label = gtk_label_new (_("Player to run :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    FilePlayerEntry = gtk_combo_new();
    gtk_combo_set_case_sensitive(GTK_COMBO(FilePlayerEntry),TRUE);
    gtk_widget_set_usize(GTK_WIDGET(FilePlayerEntry),300,-1);
    gtk_box_pack_start(GTK_BOX(hbox),FilePlayerEntry,FALSE,FALSE,0);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(FilePlayerEntry)->entry,_("Enter the program used to "
        "play the files. Some arguments can be passed for the program (as 'xmms -p') before "
        "to receive files as other arguments."),NULL);
    // History List
    History_List = Load_Audio_File_Player_List();
    History_List = Add_String_To_Glist (History_List,AUDIO_FILE_PLAYER);
    if (History_List)
        gtk_combo_set_popdown_strings(GTK_COMBO(FilePlayerEntry),History_List);
    gtk_object_set_data(GTK_OBJECT(FilePlayerEntry),"History",History_List);
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(FilePlayerEntry)->entry)),"activate",
        Add_To_Combo_Box_History,GTK_OBJECT(FilePlayerEntry));
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(FilePlayerEntry)->entry)),"focus_out_event",
        Add_To_Combo_Box_History,GTK_OBJECT(FilePlayerEntry));

    // Button browse
    Button = gtk_button_new_with_label(_(" Browse... "));
    gtk_box_pack_start(GTK_BOX(hbox),Button,FALSE,FALSE,0);
    gtk_object_set_data(GTK_OBJECT(FilePlayerEntry),"Parent_Window",OptionsWindow);
    gtk_signal_connect_object(GTK_OBJECT(Button),"clicked",
        (GtkSignalFunc)File_Selection_Window_For_File,GTK_OBJECT(FilePlayerEntry));



    /*
     * Scanner
     */
    Label = gtk_label_new (_("Scanner"));
    Frame = gtk_frame_new (_("Scanner"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    /* Save the number of the page. Asked in Scanner window */
    OptionsNoteBook_Scanner_Page_Num = gtk_notebook_page_num(GTK_NOTEBOOK(OptionsNoteBook),Frame);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),4);

    /* Character conversion for the scanner */
    Frame = gtk_frame_new (_("Character Conversion"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    ConvertUnderscoreAndP20IntoSpace = gtk_check_button_new_with_label(_("Convert underscore "
        "character '_' and string '%20' to space ' '"));
    ConvertSpaceIntoUnderscore = gtk_check_button_new_with_label(_("Convert space ' ' to underscore '_'"));
    gtk_box_pack_start(GTK_BOX(vbox),ConvertUnderscoreAndP20IntoSpace,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),ConvertSpaceIntoUnderscore,      FALSE,FALSE,0);
    gtk_signal_connect_object(GTK_OBJECT(ConvertUnderscoreAndP20IntoSpace),"toggled",
        Scanner_Convert_Check_Button_Toggled_1,GTK_OBJECT(ConvertSpaceIntoUnderscore));
    gtk_signal_connect_object(GTK_OBJECT(ConvertSpaceIntoUnderscore),"toggled",
        Scanner_Convert_Check_Button_Toggled_1,GTK_OBJECT(ConvertUnderscoreAndP20IntoSpace));

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConvertUnderscoreAndP20IntoSpace),
        CONVERT_UNDERSCORE_AND_P20_INTO_SPACE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConvertSpaceIntoUnderscore),
        CONVERT_SPACE_INTO_UNDERSCORE);
    gtk_tooltips_set_tip(Tips,ConvertUnderscoreAndP20IntoSpace,_("If activated, the conversion "
        "will take place when applying a mask."),NULL);
    gtk_tooltips_set_tip(Tips,ConvertSpaceIntoUnderscore,_("If activated, the conversion "
        "will take place when applying a mask."),NULL);


    /* Properties of the scanner window */
    Frame = gtk_frame_new (_("Scanner Window"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    OpenScannerWindowOnStartup = gtk_check_button_new_with_label(_("Open the Scanner Window on startup"));
    gtk_box_pack_start(GTK_BOX(vbox),OpenScannerWindowOnStartup,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(OpenScannerWindowOnStartup),OPEN_SCANNER_WINDOW_ON_STARTUP);
    gtk_tooltips_set_tip(Tips,OpenScannerWindowOnStartup,_("Activate this option to open automatically "
        "the scanner window when EasyTAG starts."),NULL);

    ScannerWindowOnTop = gtk_check_button_new_with_label(_("Scanner window always on top"));
    gtk_box_pack_start(GTK_BOX(vbox),ScannerWindowOnTop,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ScannerWindowOnTop),SCANNER_WINDOW_ON_TOP);
    gtk_tooltips_set_tip(Tips,ScannerWindowOnTop,_("If activated, the window which contains the masks "
                        "will stay always over the main window."),NULL);

    // Scanner Window Position
    hbox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

    SetScannerWindowPosition = gtk_check_button_new_with_label(_("Set scanner window position"));
    gtk_box_pack_start(GTK_BOX(hbox),SetScannerWindowPosition,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetScannerWindowPosition),SET_SCANNER_WINDOW_POSITION);
    msg = g_strdup_printf(_("If activated, the scanner window will appear at the specified "
                "coordinates relative to the main window. Use it if you want to keep the same "
                "position of the scanner window each times you open it. If deactivated, the "
                "window manager determines the position."));
    gtk_tooltips_set_tip(Tips,SetScannerWindowPosition,msg,NULL);
    g_free(msg);

    Label = gtk_label_new (_("X :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    ScannerWindowX = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),ScannerWindowX,FALSE,FALSE,0);
    gtk_widget_set_usize(ScannerWindowX,40,-1);
    Label = gtk_label_new (_("Y :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    ScannerWindowY = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),ScannerWindowY,FALSE,FALSE,0);
    gtk_widget_set_usize(ScannerWindowY,40,-1);
    ScannerWindowButton = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_box_pack_start(GTK_BOX(hbox),ScannerWindowButton,FALSE,FALSE,0);
    gtk_signal_connect (GTK_OBJECT(ScannerWindowButton),"clicked",
        (GtkSignalFunc)Get_Scanner_Window_Position,NULL);
    /* Load values */
    sprintf(temp,"%i",SCANNER_WINDOW_X);
    gtk_entry_set_text(GTK_ENTRY(ScannerWindowX),temp);
    sprintf(temp,"%i",SCANNER_WINDOW_Y);
    gtk_entry_set_text(GTK_ENTRY(ScannerWindowY),temp);
    gtk_signal_connect(GTK_OBJECT(ScannerWindowX),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    gtk_signal_connect(GTK_OBJECT(ScannerWindowY),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    // Placed at the end of the block because we must have all widgets built
    gtk_signal_connect(GTK_OBJECT(SetScannerWindowPosition),"toggled",
            GTK_SIGNAL_FUNC(Scanner_Window_Position_Check_Button_Toggled),NULL);
    Scanner_Window_Position_Check_Button_Toggled();


    /* Other options */
    Frame = gtk_frame_new (_("Fields"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    // Overwrite text into tag fields
    OverwriteTagField = gtk_check_button_new_with_label(_("Overwrite fields when scanning tag"));
    gtk_box_pack_start(GTK_BOX(vbox),OverwriteTagField,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(OverwriteTagField),OVERWRITE_TAG_FIELD);
    gtk_tooltips_set_tip(Tips,OverwriteTagField,_("If activated, the scanner will replace existing text "
        "in fields by the new one. If deactivated, only blank fields of the tag will be filled."),NULL);

    // Set a default comment text
    hbox = gtk_hbox_new(FALSE,2);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
    SetDefaultComment = gtk_check_button_new_with_label(_("Set this text as default comment :"));
    gtk_box_pack_start(GTK_BOX(hbox),SetDefaultComment,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetDefaultComment),SET_DEFAULT_COMMENT);
    gtk_tooltips_set_tip(Tips,SetDefaultComment,_("Activate this option if you want to put the "
        "following string into the comment field when using the 'Fill Tag' scanner."),NULL);
    DefaultComment = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(hbox),DefaultComment,FALSE,FALSE,0);
    gtk_combo_set_case_sensitive(GTK_COMBO(DefaultComment),TRUE);
    gtk_widget_set_usize(GTK_WIDGET(DefaultComment),250,-1);
    gtk_signal_connect(GTK_OBJECT(SetDefaultComment),"toggled",
            GTK_SIGNAL_FUNC(Set_Default_Comment_Check_Button_Toggled),NULL);
    if (DEFAULT_COMMENT==NULL)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetDefaultComment),FALSE);
    Set_Default_Comment_Check_Button_Toggled();
    /* History list */
    History_List = Load_Default_Tag_Comment_Text_List();
    History_List = Add_String_To_Glist(History_List,DEFAULT_COMMENT);
    if (History_List)
        gtk_combo_set_popdown_strings(GTK_COMBO(DefaultComment),History_List);
    gtk_object_set_data(GTK_OBJECT(DefaultComment),"History",History_List);
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultComment)->entry)),"activate",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultComment));
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultComment)->entry)),"focus_out_event",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultComment));


    /*
     * CDDB
     */
    Label = gtk_label_new (_("CDDB"));
    Frame = gtk_frame_new (_("CDDB"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),2);

    // CDDB Server Settings
    Frame = gtk_frame_new (_("Server Settings"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    hbox = gtk_hbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    Label = gtk_label_new(_("Name :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,2);
    CddbServerName = gtk_combo_new();
    gtk_combo_set_case_sensitive(GTK_COMBO(CddbServerName),TRUE);
    gtk_box_pack_start(GTK_BOX(hbox),CddbServerName,FALSE,FALSE,0);
    History_List = NULL;
    History_List = g_list_append(History_List,"freedb.freedb.org");
    History_List = g_list_append(History_List,"freedb.freedb.de");
    //History_List = g_list_append(History_List,"at.freedb.org"); // Uses probably "HTTP/1.0" ...
    History_List = g_list_append(History_List,"au.freedb.org");
    History_List = g_list_append(History_List,"bg.freedb.org");
    History_List = g_list_append(History_List,"ca.freedb.org");
    History_List = g_list_append(History_List,"ca2.freedb.org");
    History_List = g_list_append(History_List,"de.freedb.org");
    History_List = g_list_append(History_List,"es.freedb.org");
    History_List = g_list_append(History_List,"fi.freedb.org");
    History_List = g_list_append(History_List,"lu.freedb.org");
    History_List = g_list_append(History_List,"no.freedb.org");
    History_List = g_list_append(History_List,"uk.freedb.org");
    History_List = g_list_append(History_List,"us.freedb.org");
    gtk_combo_set_popdown_strings(GTK_COMBO(CddbServerName),History_List);
    gtk_entry_set_text_1(CddbServerName,CDDB_SERVER_NAME);

    Label = gtk_label_new (_("Port :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,2);
    CddbServerPort = gtk_entry_new();
    gtk_widget_set_usize(GTK_WIDGET(CddbServerPort),45,-1);
    gtk_entry_set_max_length(GTK_ENTRY(CddbServerPort),5);
    gtk_box_pack_start(GTK_BOX(hbox),CddbServerPort,FALSE,FALSE,0);
    sprintf(temp,"%i",CDDB_SERVER_PORT);
    gtk_entry_set_text(GTK_ENTRY(CddbServerPort),temp);
    gtk_signal_connect(GTK_OBJECT(CddbServerPort),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);

    Label = gtk_label_new (_("CGI Path :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,2);
    CddbServerCgiPath = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(hbox),CddbServerCgiPath,FALSE,FALSE,0);
    gtk_entry_set_text_1(CddbServerCgiPath,CDDB_SERVER_CGI_PATH);

    // CDDB Proxy Settings
    Frame = gtk_frame_new (_("Proxy Settings"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);

    Table = gtk_table_new(4,4,FALSE);
    gtk_container_add(GTK_CONTAINER(Frame),Table);
    gtk_table_set_row_spacings(GTK_TABLE(Table),2);
    gtk_table_set_col_spacings(GTK_TABLE(Table),4);
    gtk_container_border_width(GTK_CONTAINER(Table),2);

    CddbUseProxy = gtk_check_button_new_with_label(_("Use a proxy"));
    gtk_table_attach(GTK_TABLE(Table),CddbUseProxy,0,4,0,1,GTK_FILL,GTK_FILL,0,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CddbUseProxy),CDDB_USE_PROXY);
    gtk_tooltips_set_tip(Tips,CddbUseProxy,_("Set active the settings of the proxy server."),NULL);

    Label = gtk_label_new(_("Host Name :"));
    gtk_table_attach(GTK_TABLE(Table),Label,0,1,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    CddbProxyName = gtk_entry_new();
    gtk_table_attach(GTK_TABLE(Table),CddbProxyName,1,2,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_tooltips_set_tip(Tips,CddbProxyName,_("Name of the proxy server."),NULL);
    Label = gtk_label_new (_("Port :"));
    gtk_table_attach(GTK_TABLE(Table),Label,2,3,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    gtk_entry_set_text(GTK_ENTRY(CddbProxyName),CDDB_PROXY_NAME);
    CddbProxyPort = gtk_entry_new();
    gtk_widget_set_usize(GTK_WIDGET(CddbProxyPort),45,-1);
    gtk_entry_set_max_length(GTK_ENTRY(CddbProxyPort),5);
    gtk_table_attach(GTK_TABLE(Table),CddbProxyPort,3,4,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_tooltips_set_tip(Tips,CddbProxyPort,_("Port of the proxy server."),NULL);
    sprintf(temp,"%i",CDDB_PROXY_PORT);
    gtk_entry_set_text(GTK_ENTRY(CddbProxyPort),temp);
    gtk_signal_connect(GTK_OBJECT(CddbProxyPort),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    gtk_signal_connect(GTK_OBJECT(CddbUseProxy),"toggled",GTK_SIGNAL_FUNC(Cddb_Use_Proxy_Toggled),NULL);
    Label = gtk_label_new(_("User Name :"));
    gtk_table_attach(GTK_TABLE(Table),Label,0,1,2,3,GTK_FILL,GTK_FILL,0,0);
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    CddbProxyUserName = gtk_entry_new();
    gtk_table_attach(GTK_TABLE(Table),CddbProxyUserName,1,2,2,3,GTK_FILL,GTK_FILL,0,0);
    gtk_tooltips_set_tip(Tips,CddbProxyUserName,_("Name of user for the the proxy server."),NULL);
gtk_widget_set_sensitive(Label,FALSE);
gtk_widget_set_sensitive(CddbProxyUserName,FALSE);
    Label = gtk_label_new(_("User Password :"));
    gtk_table_attach(GTK_TABLE(Table),Label,0,1,3,4,GTK_FILL,GTK_FILL,0,0);
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    CddbProxyUserPassword = gtk_entry_new();
    gtk_table_attach(GTK_TABLE(Table),CddbProxyUserPassword,1,2,3,4,GTK_FILL,GTK_FILL,0,0);
    gtk_entry_set_visibility(GTK_ENTRY(CddbProxyUserPassword),FALSE);
    gtk_tooltips_set_tip(Tips,CddbProxyUserPassword,_("Password of user for the the proxy server."),NULL);
gtk_widget_set_sensitive(Label,FALSE);
gtk_widget_set_sensitive(CddbProxyUserPassword,FALSE);
    Cddb_Use_Proxy_Toggled();


    // CDDB Window
    Frame = gtk_frame_new (_("CDDB Window"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);

    Table = gtk_table_new(6,3,FALSE);
    gtk_container_add(GTK_CONTAINER(Frame),Table);
    gtk_table_set_row_spacings(GTK_TABLE(Table),2);
    gtk_table_set_col_spacings(GTK_TABLE(Table),4);
    gtk_container_border_width(GTK_CONTAINER(Table),2);

    /* Window size */
    SetCddbWindowSize = gtk_check_button_new_with_label(_("Set CDDB window size"));
    gtk_table_attach(GTK_TABLE(Table),SetCddbWindowSize,0,1,0,1,GTK_FILL,GTK_FILL,0,0);
    Label = gtk_label_new (_("Width :"));
    gtk_table_attach(GTK_TABLE(Table),Label,1,2,0,1,GTK_FILL,GTK_FILL,0,0);
    CddbWindowWidth = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),CddbWindowWidth,2,3,0,1,GTK_FILL,GTK_FILL,0,0);
    gtk_widget_set_usize(CddbWindowWidth,40,-1);
    Label = gtk_label_new (_("Height :"));
    gtk_table_attach(GTK_TABLE(Table),Label,3,4,0,1,GTK_FILL,GTK_FILL,0,0);
    CddbWindowHeight = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),CddbWindowHeight,4,5,0,1,GTK_FILL,GTK_FILL,0,0);
    gtk_widget_set_usize(CddbWindowHeight,40,-1);
    CddbWindowButton = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current size "));
    gtk_table_attach(GTK_TABLE(Table),CddbWindowButton,5,6,0,1,GTK_FILL,GTK_FILL,0,0);
    gtk_signal_connect (GTK_OBJECT(CddbWindowButton),"clicked",(GtkSignalFunc)Get_Cddb_Window_Size,NULL);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetCddbWindowSize),SET_CDDB_WINDOW_SIZE);
    sprintf(temp,"%i",CDDB_WINDOW_HEIGHT);
    gtk_entry_set_text(GTK_ENTRY(CddbWindowHeight),temp);
    sprintf(temp,"%i",CDDB_WINDOW_WIDTH);
    gtk_entry_set_text(GTK_ENTRY(CddbWindowWidth),temp);
    gtk_signal_connect(GTK_OBJECT(CddbWindowHeight),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    gtk_signal_connect(GTK_OBJECT(CddbWindowWidth),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    // Placed at the end of the block cause we must have all widgets built
    gtk_signal_connect(GTK_OBJECT(SetCddbWindowSize),"toggled",GTK_SIGNAL_FUNC(Set_Cddb_Window_Size_Toggled),NULL);
    Set_Cddb_Window_Size_Toggled();
    gtk_tooltips_set_tip(Tips,SetCddbWindowSize,_("Specify the default size for the CDDB window."),NULL);
    gtk_tooltips_set_tip(Tips,CddbWindowWidth,_("Width: set -1 for automatic size"),NULL);
    gtk_tooltips_set_tip(Tips,CddbWindowHeight,_("Heigth: set -1 for automatic size"),NULL);

    // Pane handle position
    SetCddbPaneHandlePosition = gtk_check_button_new_with_label(_("Set pane handle position"));
    gtk_table_attach(GTK_TABLE(Table),SetCddbPaneHandlePosition,0,2,1,2,GTK_FILL,GTK_FILL,0,0);
    Label = gtk_label_new (_("Position :"));
    gtk_table_attach(GTK_TABLE(Table),Label,2,4,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    CddbPaneHandlePosition = gtk_entry_new_with_max_length(4);
    gtk_table_attach(GTK_TABLE(Table),CddbPaneHandlePosition,4,5,1,2,GTK_FILL,GTK_FILL,0,0);
    sprintf(temp,"%i",CDDB_PANE_HANDLE_POSITION);
    gtk_entry_set_text(GTK_ENTRY(CddbPaneHandlePosition),temp);
    gtk_signal_connect(GTK_OBJECT(CddbPaneHandlePosition),"insert_text",GTK_SIGNAL_FUNC(Insert_Only_Digit),NULL);
    gtk_widget_set_usize(CddbPaneHandlePosition,40,-1);
    CddbPaneHandleButton = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_table_attach(GTK_TABLE(Table),CddbPaneHandleButton,5,6,1,2,GTK_FILL,GTK_FILL,0,0);
    gtk_signal_connect (GTK_OBJECT(CddbPaneHandleButton),"clicked",(GtkSignalFunc)Get_Cddb_Pane_Handle_Position,NULL);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetCddbPaneHandlePosition),SET_CDDB_PANE_HANDLE_POSITION);
    gtk_tooltips_set_tip(Tips,SetCddbPaneHandlePosition,_("Specify the default position for the pane "
        "handle in the CDDB window."),NULL);
    gtk_tooltips_set_tip(Tips,CddbPaneHandlePosition,_("Position: set -1 for automatic positioning"),NULL);
    gtk_signal_connect(GTK_OBJECT(SetCddbPaneHandlePosition),"toggled",GTK_SIGNAL_FUNC(Set_Cddb_Pane_Handle_Position_Toggled),NULL);
    Set_Cddb_Pane_Handle_Position_Toggled();


    /*
     * Confirmation
     */
    Label = gtk_label_new (_("Confirmation"));
    Frame = gtk_frame_new (_("Confirmation"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),2);

    ConfirmBeforeExit = gtk_check_button_new_with_label(_("Confirm exit from program"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmBeforeExit,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmBeforeExit),CONFIRM_BEFORE_EXIT);
    gtk_tooltips_set_tip(Tips,ConfirmBeforeExit,_("If activated, opens a dialog box to ask "
        "confirmation before exiting the program."),NULL);

    ConfirmWriteTag = gtk_check_button_new_with_label(_("Confirm writing of file tag"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmWriteTag,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmWriteTag),CONFIRM_WRITE_TAG);

    ConfirmRenameFile = gtk_check_button_new_with_label(_("Confirm renaming of file"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmRenameFile,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmRenameFile),CONFIRM_RENAME_FILE);

    ConfirmWritePlayList = gtk_check_button_new_with_label(_("Confirm writing of playlist"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmWritePlayList,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmWritePlayList),CONFIRM_WRITE_PLAYLIST);



    /* 
     * Buttons box of Option Window
     */
    ButtonBox = gtk_hbutton_box_new ();
    gtk_box_pack_start(GTK_BOX(OptionsVBox), ButtonBox, FALSE, FALSE, 4);

    gtk_button_box_set_layout (GTK_BUTTON_BOX (ButtonBox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (ButtonBox), 15);


    /* OK Button */
    Button = Create_Button_With_Pixmap(BUTTON_APPLY);
    gtk_container_add(GTK_CONTAINER(ButtonBox),Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)OptionsWindow_Ok_Button,NULL);
    GTK_WIDGET_SET_FLAGS(Button, GTK_CAN_DEFAULT);
    gtk_tooltips_set_tip(Tips,Button,_("Apply changes (but don't save) and close this window"),NULL);

    /* Save Button */
    Button = Create_Button_With_Pixmap(BUTTON_SAVE);
    gtk_container_add(GTK_CONTAINER(ButtonBox), Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)OptionsWindow_Save_Button,NULL);
    GTK_WIDGET_SET_FLAGS(Button, GTK_CAN_DEFAULT);
    gtk_tooltips_set_tip(Tips,Button,_("Save changes and close this window"),NULL);

    /* Cancel Button */
    Button = Create_Button_With_Pixmap(BUTTON_CANCEL);
    gtk_container_add(GTK_CONTAINER(ButtonBox), Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)OptionsWindow_Cancel_Button,NULL);
    GTK_WIDGET_SET_FLAGS(Button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (Button);
    gtk_tooltips_set_tip(Tips,Button,_("Close this window without saving"),NULL);


    /* Show all in the options window */
    gtk_widget_show_all(OptionsWindow);

    /* Load the default page */
    gtk_notebook_set_page(GTK_NOTEBOOK(OptionsNoteBook),OPTIONS_NOTEBOOK_PAGE);
}


void Set_Main_Window_Size_Toggled (void)
{
    gtk_widget_set_sensitive(MainWindowWidth, GTK_TOGGLE_BUTTON(SetMainWindowSize)->active);
    gtk_widget_set_sensitive(MainWindowHeight,GTK_TOGGLE_BUTTON(SetMainWindowSize)->active);
    gtk_widget_set_sensitive(MainWindowButton,GTK_TOGGLE_BUTTON(SetMainWindowSize)->active);
}

void Set_Pane_Handle_Position1_Toggled (void)
{
    gtk_widget_set_sensitive(PaneHandlePosition1,GTK_TOGGLE_BUTTON(SetPaneHandlePosition1)->active);
    gtk_widget_set_sensitive(PaneHandleButton1,  GTK_TOGGLE_BUTTON(SetPaneHandlePosition1)->active);
}

void Set_Pane_Handle_Position2_Toggled (void)
{
    gtk_widget_set_sensitive(PaneHandlePosition2,GTK_TOGGLE_BUTTON(SetPaneHandlePosition2)->active);
    gtk_widget_set_sensitive(PaneHandleButton2,  GTK_TOGGLE_BUTTON(SetPaneHandlePosition2)->active);
}

void Scanner_Window_Position_Check_Button_Toggled (void)
{
    gtk_widget_set_sensitive(ScannerWindowX,     GTK_TOGGLE_BUTTON(SetScannerWindowPosition)->active);
    gtk_widget_set_sensitive(ScannerWindowY,     GTK_TOGGLE_BUTTON(SetScannerWindowPosition)->active);
    gtk_widget_set_sensitive(ScannerWindowButton,GTK_TOGGLE_BUTTON(SetScannerWindowPosition)->active);
}

void Set_Default_Comment_Check_Button_Toggled (void)
{
    gtk_widget_set_sensitive(DefaultComment,GTK_TOGGLE_BUTTON(SetDefaultComment)->active);
}


void Use_Character_Set_Translation_Toggled (void)
{
    gtk_widget_set_sensitive(FileCharacterSetEntry,GTK_TOGGLE_BUTTON(UseCharacterSetTranslation)->active);
    gtk_widget_set_sensitive(UserCharacterSetEntry,GTK_TOGGLE_BUTTON(UseCharacterSetTranslation)->active);
}

void Cddb_Use_Proxy_Toggled (void)
{
    gtk_widget_set_sensitive(CddbProxyName,GTK_TOGGLE_BUTTON(CddbUseProxy)->active);
    gtk_widget_set_sensitive(CddbProxyPort,GTK_TOGGLE_BUTTON(CddbUseProxy)->active);
//    gtk_widget_set_sensitive(CddbProxyUserName,GTK_TOGGLE_BUTTON(CddbUseProxy)->active);
//    gtk_widget_set_sensitive(CddbProxyUserPassword,GTK_TOGGLE_BUTTON(CddbUseProxy)->active);
}

void Set_Cddb_Window_Size_Toggled (void)
{
    gtk_widget_set_sensitive(CddbWindowWidth, GTK_TOGGLE_BUTTON(SetCddbWindowSize)->active);
    gtk_widget_set_sensitive(CddbWindowHeight,GTK_TOGGLE_BUTTON(SetCddbWindowSize)->active);
    gtk_widget_set_sensitive(CddbWindowButton,GTK_TOGGLE_BUTTON(SetCddbWindowSize)->active);
}

void Set_Cddb_Pane_Handle_Position_Toggled (void)
{
    gtk_widget_set_sensitive(CddbPaneHandlePosition,GTK_TOGGLE_BUTTON(SetCddbPaneHandlePosition)->active);
    gtk_widget_set_sensitive(CddbPaneHandleButton,  GTK_TOGGLE_BUTTON(SetCddbPaneHandlePosition)->active);
}

void Sorting_File_Option_Menu_Activate_Item (GtkWidget *widget, ET_Sorting_Type *st)
{
    SORTING_FILE_MODE = GPOINTER_TO_INT(st);
}

void Browser_Line_Style_Option_Menu_Activate_Item (GtkWidget *widget, GtkCTreeLineStyle line_style)
{
    BROWSER_LINE_STYLE = GPOINTER_TO_INT(line_style);
}

void Browser_Expander_Style_Option_Menu_Activate_Item (GtkWidget *widget, GtkCTreeExpanderStyle expander_style)
{
    BROWSER_EXPANDER_STYLE = GPOINTER_TO_INT(expander_style);
}


/* Callback from Open_OptionsWindow */
void OptionsWindow_Key_Press (GtkWidget *window, GdkEvent *event)
{
    GdkEventKey *kevent;

    if (event && event->type == GDK_KEY_PRESS)
    {
        kevent = (GdkEventKey *)event;
        switch(kevent->keyval)
        {
            case GDK_Escape:    
            {
                OptionsWindow_Quit();
                break;
            }
        }
    }
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Ok_Button(void)
{
    if (!Check_Config()) return;
    Apply_Changes();
    OptionsWindow_Quit();
    Statusbar_Message(_("Changes applied"),TRUE);
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Save_Button(void)
{
    if (!Check_Config()) return;
    Save_Changes();
    OptionsWindow_Quit();
    Statusbar_Message(_("Configuration saved"),TRUE);
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Cancel_Button(void)
{
    OptionsWindow_Quit();
    Statusbar_Message(_("Configuration unchanged"),TRUE);
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Quit(void)
{
    if (OptionsWindow)
    {
        GList *list;
        
        /* Save combobox history lists before exit */
        list = gtk_object_get_data(GTK_OBJECT(DefaultPathToMp3),"History");
        Save_Default_Path_To_MP3_List(list);
        
        list = gtk_object_get_data(GTK_OBJECT(DefaultComment),"History");
        Save_Default_Tag_Comment_Text_List(list);
        
        list = gtk_object_get_data(GTK_OBJECT(FilePlayerEntry),"History");
        Save_Audio_File_Player_List(list);
        
        /* Now quit */
        gtk_widget_destroy(OptionsWindow);
        OptionsWindow = (GtkWidget *)NULL;
        gtk_widget_set_sensitive(MainWindow, TRUE);
    }
}


/*
 * Check_Config: Check if config informations are correct
 */
#include <sys/stat.h>
#include <unistd.h>
gint Check_DefaultPathToMp3 (void)
{
    gchar *path;
    struct stat stbuf;

    path = g_strdup(gtk_entry_get_text_1(DefaultPathToMp3));
    if (!path || strlen(path)<1)
    {
        g_free(path);
        return 1;
    }

    if ( stat(path,&stbuf)==0 && S_ISDIR(stbuf.st_mode) )
    {
        g_free(path);
        return 1;    /* Path is good */
    }else
    {
        gchar *msg = g_strdup_printf(_(" The selected path for 'Default path to MP3 files' isn't "
            "valid!\n (%s) "),(stat(path,&stbuf)==0)?_("Not a directory"):g_strerror(errno) );
        GtkWidget *msgbox = msg_box_new (_("Confirm..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        g_free(path);

        return 0;
    }
}
gint Check_Size (void)
{
    if ( atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowHeight))) > gdk_screen_height() )
    {
        gchar *msg = g_strdup_printf(_(" Window height (%d) is bigger than screen height (%d)! "),
                atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowHeight))),gdk_screen_height());
        GtkWidget *msgbox = msg_box_new (_("Size Error..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        return 0;
    }
    if ( atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowWidth))) > gdk_screen_width() )
    {
        gchar *msg = g_strdup_printf(_(" Window width (%d) is bigger than screen width (%d)! "),
                atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowWidth))),gdk_screen_width());
        GtkWidget *msgbox = msg_box_new (_("Size Error..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        return 0;
    }
    /* Size is good */
    return 1;
}
gint Check_CharacterSetTranslation (void)
{
    gchar *from = Charset_Get_Name_From_Title(gtk_entry_get_text_1(FileCharacterSetEntry));
    gchar *to   = Charset_Get_Name_From_Title(gtk_entry_get_text_1(UserCharacterSetEntry));

    if ( GTK_TOGGLE_BUTTON(UseCharacterSetTranslation)->active && (test_conversion_charset(from,to)!=TRUE) )
    {
        gchar *msg = g_strdup_printf(_("The character set translation from '%s'\n"
                                       "to '%s' isn't supported!"),from,to);
        GtkWidget *msgbox = msg_box_new (_("Error..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(UseCharacterSetTranslation),FALSE);
        return 0;
    }
    return 1;
}
gint Check_DefaultComment (void)
{
    gchar *file;

    file = gtk_entry_get_text_1(DefaultComment);
    if (!file || strlen(file)<1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetDefaultComment),FALSE);

    return 1;    /* A blank entry is ignored */
}

gint Check_Config (void)
{
    if (   Check_DefaultPathToMp3() 
        && Check_Size() 
        && Check_CharacterSetTranslation() 
        && Check_DefaultComment()
       )
        return 1;    /* No problem detected */
    else
        return 0;    /* Oups! */
}



void File_Selection_Window_For_File (GtkWidget *combo)
{
    Open_File_Selection_Window(combo,_("Select directory..."),TRUE);
}

void File_Selection_Window_For_Directory (GtkWidget *combo)
{
    Open_File_Selection_Window(combo,_("Select file..."),FALSE);
}

/*
 * Open the file selection window
 * - 'combo' receives the path of a file/directory...
 * - the data named "Parent_Window" and containing the parent_window widget must be attached to the combo
 */
static void Open_File_Selection_Window (GtkWidget *combo, gchar *title, gboolean enable_file)
{
    gchar *tmp = NULL;
    GtkWidget *parent_window;

    if (FileSelectionWindow)
    {
        gdk_window_show(FileSelectionWindow->window);
        return;
    }

    FileSelectionWindow = gtk_file_selection_new(title);
    // Enable/Disable file selection
    gtk_widget_set_sensitive(GTK_FILE_SELECTION(FileSelectionWindow)->file_list,enable_file);
    // Set init directory
    tmp = gtk_entry_get_text_1(combo);
    if (tmp && *tmp)
        gtk_file_selection_set_filename(GTK_FILE_SELECTION(FileSelectionWindow),tmp);

    if ( (parent_window=gtk_object_get_data(GTK_OBJECT(combo),"Parent_Window")) != NULL )
        gtk_window_set_transient_for(GTK_WINDOW(FileSelectionWindow),GTK_WINDOW(parent_window));
    gtk_window_set_modal(GTK_WINDOW(FileSelectionWindow),TRUE);
    gtk_signal_connect(GTK_OBJECT(&(GTK_FILE_SELECTION(FileSelectionWindow)->window)),
                       "delete_event",(GtkSignalFunc)File_Selection_Window_Destroy,FileSelectionWindow);

    // Callbacks of the buttons
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelectionWindow)->ok_button),
                           "clicked",(GtkSignalFunc)File_Selection_Window_Ok_Button,GTK_OBJECT(combo));
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelectionWindow)->cancel_button),
                           "clicked",(GtkSignalFunc)File_Selection_Window_Destroy,FileSelectionWindow);

    gtk_widget_show(FileSelectionWindow);
}

/* Callback from Open_File_Selection_Window */
static void File_Selection_Window_Ok_Button (GtkWidget *widget)
{
    gchar *tmp;

    tmp = gtk_file_selection_get_filename(GTK_FILE_SELECTION(FileSelectionWindow));
    gtk_entry_set_text_1(GTK_WIDGET(widget),tmp);

    gtk_widget_destroy(FileSelectionWindow);
    FileSelectionWindow = (GtkWidget *)NULL;
}

/* Callback from Open_File_Selection_Window */
void File_Selection_Window_Destroy (void)
{
    gtk_widget_destroy(FileSelectionWindow);
    FileSelectionWindow = (GtkWidget *)NULL;
}


/* 
 * Get current size of main window and complete "window size" fields
 */
void Get_Main_Window_Size (void)
{
    gint height;
    gint width;
    gchar temp[MAX_STRING_LEN];

    gdk_window_get_size(MainWindow->window,&width,&height);
    sprintf(temp,"%i",height);
    gtk_entry_set_text(GTK_ENTRY(MainWindowHeight),temp);
    sprintf(temp,"%i",width);
    gtk_entry_set_text(GTK_ENTRY(MainWindowWidth),temp);
}



/* 
 * Get current position of pane handle
 */
void Get_Pane_Handle_Position1 (void)
{
    gchar temp[MAX_STRING_LEN];

    sprintf(temp,"%i",GTK_PANED(MainWindowHPaned)->child1_size);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition1),temp);
}
void Get_Pane_Handle_Position2 (void)
{
    gchar temp[MAX_STRING_LEN];

    sprintf(temp,"%i",GTK_PANED(BrowserHPaned)->child1_size);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition2),temp);
}



/* 
 * Get current position of scanner window with regards to main 
 * window and complete "window position" fields.
 */
void Get_Scanner_Window_Position (void)
{
    gint x,x1;
    gint y,y1;
    gchar temp[MAX_STRING_LEN];

    if (!MainWindow) return;
    if (!ScannerWindow)
    {
        GtkWidget *msgbox = msg_box_new (_("Error..."),_("The scanner window must be "
            "open to get its current position!"),MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
    }else
    {
        gdk_window_get_position(MainWindow->window,&x,&y);
        gdk_window_get_position(ScannerWindow->window,&x1,&y1);
        sprintf(temp,"%i",x1-x);
        gtk_entry_set_text(GTK_ENTRY(ScannerWindowX),temp);
        sprintf(temp,"%i",y1-y);
        gtk_entry_set_text(GTK_ENTRY(ScannerWindowY),temp);
    }
}



/*
 * Manage Check buttons into Scanner tab: conversion group
 */
void Scanner_Convert_Check_Button_Toggled_1 (GtkObject *object_rec, GtkObject *object_emi)
{
    if (!object_rec && !object_emi) return;

    if (GTK_TOGGLE_BUTTON(object_emi)->active == TRUE)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(object_rec),
                        !GTK_TOGGLE_BUTTON(object_emi)->active);

}


void Get_Cddb_Window_Size (void)
{
    gint height;
    gint width;
    gchar temp[MAX_STRING_LEN];

    if (!CddbWindow)
    {
        GtkWidget *msgbox = msg_box_new (_("Error..."),_("The CDDB window must be "
            "open to get its current position!"),MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        return;
    }else
    {
        gdk_window_get_size(CddbWindow->window,&width,&height);
        sprintf(temp,"%i",height);
        gtk_entry_set_text(GTK_ENTRY(CddbWindowHeight),temp);
        sprintf(temp,"%i",width);
        gtk_entry_set_text(GTK_ENTRY(CddbWindowWidth),temp);
    }
}

void Get_Cddb_Pane_Handle_Position (void)
{
    gchar temp[MAX_STRING_LEN];

    if (!CddbWindow)
    {
        GtkWidget *msgbox = msg_box_new (_("Error..."),_("The CDDB window must be "
            "open to get its current position!"),MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        return;
    }else
    {
        sprintf(temp,"%i",GTK_PANED(CddbWindowHPaned)->child1_size);
        gtk_entry_set_text(GTK_ENTRY(CddbPaneHandlePosition),temp);
    }
}


