/*
    Dysnomia 0.3.4 (BETA)
    Copyright (C) 2007 Benjamin Renaut

    Dysnomia is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    Dysnomia is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Dysnomia; if not, write to the Free Software Foundation,
    Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    -----

    solozerk@sekren.org
    http://www.dysnomia-project.org/
    IRC: #dysnomia@irc.code-libre.org
*/

#include "deezer.hpp"


/*
Warning : even if it works, most of the code beyond is a mess ;-)
It will be cleaned up on a next version.
Also, if the deezer system were to change, the program would be very likely to segfault.
*/


char* encrypt_searchrequest(const char* searchrequest)
{
  int size=strlen(searchrequest);
  char* encrypted=new char[(size*2)+1];
  char nb[3];

  memset(encrypted, 0, (size*2)+1);

  for(int i=0; i<size; ++i)
  {
    sprintf(nb, "%02x", ((unsigned int)(searchrequest[i]))^deezer_search_key[i]);
    strcat(encrypted, nb);
  }

  return(encrypted);
}


char* deezer_decrypt(const char* str, int type)
{
  int size=strlen(str);
  if((size%2)!=0)
  {
    cerr<<"Error : wrong key/session id."<<endl;
    exit(42);
  }
  char nb[3];
  int vnb;
  const unsigned int* key;
  char* decrypted=new char[size+1];

  if(type==TYPE_SESSION)
    key=deezer_sessions_key;
  else
    key=deezer_streaming_key;

  memset(decrypted, 0, size+1);
  for(int i=0; i<size; i+=2)
  {
    strncpy(nb, str+i, 2);
    nb[2]='\0';
    sscanf(nb, "%x", &vnb);
    sprintf(nb, "%02x", (vnb^key[i/2]));
    strcat(decrypted, nb);
  }

  return(decrypted);
}


char* get_random_phpsessid()
{
  char* ret=new char[33];
  int rnd;

  memset(ret, 0, 33);

  rnd=rand()%(10);
  ret[0]='0'+rnd;

  for(int i=1; i<32; ++i)
  {
    rnd=rand()%(2);
    if(rnd)
    {
      rnd=rand()%(26);
      ret[i]='a'+rnd;
    }
    else
    {
      rnd=rand()%(10);
      ret[i]='0'+rnd;
    }
  }

  return(ret);
}


// Callback function for the streaming request.
size_t response_getkey(void* buffer, size_t size, size_t nmemb, void* userp)
{
  short* size_key;
  char* buf=(char*)(buffer);
  char* key=(char*)(userp);
  if(size!=1)
    return(-1);

  size_key=((short*)(buf+30));

  if(ntohs(*size_key)<42)
    return(-1);

  for(int i=0; i<ntohs(*size_key); ++i)
  {
    key[i]=buf[32+i];
  }
  key[ntohs(*size_key)]='\0';
  return(0);
}


// Callback function for the SESSION_ID request.
size_t response_sessionid(void* buffer, size_t size, size_t nmemb, void* userp)
{
  short* size_id;
  char* buf=(char*)(buffer);
  char* sessid=(char*)(userp);
  if(size!=1)
    return(-1);

  size_id=((short*)(buf+30));
  
  if(ntohs(*size_id)<42)
    return(-1);

  for(int i=0; i<ntohs(*size_id); ++i)
  {
    sessid[i]=buf[32+i];
  }
  sessid[ntohs(*size_id)]='\0';
  return(0);
}


long filesize(FILE* fd)
{
   fseek(fd, 0, SEEK_END);
   long size = ftell(fd);
   fseek(fd, 0, SEEK_SET);
   return size;
}

// Quick and dirty search results parser.
void parse_searchresults(vector<song>* res, char* buf, int size)
{
  int current;
  short sizestring;
  char title[1024];
  char artist[1024];
  char album[1024];
  char imgurl[2048];
  char id[1024];
  int size_title, size_artist, size_album, size_imgurl, size_id;

  if(size<115)
    return;
  
  current=43;
  sizestring=ntohs(*((short*)(buf+current)));
  current+=2+sizestring+4;
  while(true)
  {
    sizestring=ntohs(*((short*)(buf+current)));
    if((sizestring>1022) || (sizestring==0))    // Error
      return;
    size_title=sizestring;
    current+=2;
    strncpy(title, buf+current, 1023);
    if(title[sizestring]!='\0')  // Error
      return;

    current+=4+sizestring;
    
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring+4;

    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring+11;

    sizestring=ntohs(*((short*)(buf+current)));
    if(sizestring>1022)
      return;
    size_album=sizestring;
    current+=2;
    for(int i=0; i<sizestring; ++i)
    {
      album[i]=buf[current];
      ++current;
    }
    album[sizestring]='\0';

    current+=4;
    
    sizestring=ntohs(*((short*)(buf+current)));
    if(sizestring>1022)   // Error
      return;
    size_imgurl=sizestring;
    if(sizestring==0)
    {
      strcpy(imgurl, "");
      /* if((buf[current+3]==0) && (buf[current+4]==10))
	current+=16;
	else*/
	current+=6;
    }
    else
    {
      current+=2;
      for(int i=0; i<sizestring; ++i)
      {
	imgurl[i]=buf[current];
	++current;
      }
      imgurl[sizestring]='\0';
      if((buf[current+1]==0) && (buf[current+2]==10))
	current+=14;
      else
	current+=4;
    }

    sizestring=ntohs(*((short*)(buf+current)));
    if(sizestring>1022)   // Error
      return;
    current+=2;
    size_artist=sizestring;
    for(int i=0; i<sizestring; ++i)
    {
      artist[i]=buf[current];
      ++current;
    }
    artist[sizestring]='\0';

    current+=11;

    sizestring=ntohs(*((short*)(buf+current)));
    if(sizestring>1022)
      return;
    size_id=sizestring;
    current+=2;
    for(int i=0; i<sizestring; ++i)
    {
      id[i]=buf[current];
      ++current;
    }
    id[sizestring]='\0';

    res->push_back(song(artist, title, album, imgurl, id));

    if((buf[current+2]=='c') && (buf[current+3]=='u') && (buf[current+4]=='r') && (buf[current+5]=='s') && (buf[current+6]=='o') && (buf[current+7]=='r'))
      break;

    // Fields we don't care - ART_ID, ALB_ID, etc...
    current+=9;
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring;
    current+=14+size_title;
    current+=9;
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring;
    current+=9;
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring;

    current+=7;
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring;  // The "visitor's rating" field, to use in a next version.

    current+=14+size_album+16+size_imgurl+13+size_artist+8;
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring+13+size_id+12;
    sizestring=ntohs(*((short*)(buf+current)));
    current+=2+sizestring+4;
  }
}




vector<song>* search_deezer(const char* search)
{
  vector<song>* res=new vector<song>;

  CURL *easyhandle;
  struct curl_slist *headers=NULL;
  char* phpsessid;
  char url[1024];
  char postfield[1024];
  int fsize;
  char* bufsearch;
  char* search_encrypted;

  phpsessid=get_random_phpsessid();

  strcpy(url, "http://www.deezer.com/flashservices/gateway.php?PHPSESSID=");
  strcat(url, phpsessid);

  int current=0;
  for(unsigned int i=0; i<(sizeof(amfphp_search_serialized_part1)-1); ++i)
  {
    postfield[i]=amfphp_search_serialized_part1[i];
    ++current;
  }

  search_encrypted=encrypt_searchrequest(search);
  short size=htons(strlen(search_encrypted)+8);
  postfield[current]=*((char*)(&size));
  postfield[current+1]=*(((char*)(&size))+1);
  current+=2;
  for(unsigned int i=0; i<(sizeof(amfphp_search_serialized_part2)-1); ++i)
  {
    postfield[current]=amfphp_search_serialized_part2[i];
    ++current;
  }

  size=htons(strlen(search_encrypted));
  postfield[current]=*((char*)(&size));
  postfield[current+1]=*(((char*)(&size))+1);
  current+=2;

  for(unsigned int i=0; i<strlen(search_encrypted); ++i)
  {
    postfield[current]=search_encrypted[i];
    ++current;
  }
  FILE* searchres_fd=fopen(TEMP_SEARCHRESULTS_FILENAME, "wb");
  if(searchres_fd==NULL)
  {
    cerr<<"Error : unable to open the search results file. Permissions problem ?"<<endl;
    exit(42);
  }
  // Deezer search request
  easyhandle = curl_easy_init();
  curl_easy_setopt(easyhandle, CURLOPT_URL, url);
  curl_easy_setopt(easyhandle, CURLOPT_POSTFIELDS, postfield);
  curl_easy_setopt(easyhandle, CURLOPT_POSTFIELDSIZE, current);

#ifdef __WINDOWS__
  headers = curl_slist_append(headers, "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#else
  headers = curl_slist_append(headers, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#endif

  headers = curl_slist_append(headers, "Referer: http://www.deezer.com/index3.swf?Version=2-0-6");
  headers = curl_slist_append(headers, "Content-Type: application/x-amf");
  curl_easy_setopt(easyhandle, CURLOPT_HTTPHEADER, headers);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEDATA, searchres_fd);
  if(curl_easy_perform(easyhandle))
  {
    cerr<<"Error : unable to do the search request."<<endl;
    exit(42);
  }
  curl_slist_free_all(headers);
  curl_easy_cleanup(easyhandle);
  
  fclose(searchres_fd);

  searchres_fd=fopen(TEMP_SEARCHRESULTS_FILENAME, "rb");
  if(searchres_fd==NULL)
  {
    cerr<<"Error : unable to open the search results file. Permissions problem ?"<<endl;
    exit(42);
  }
  fsize=filesize(searchres_fd);
  bufsearch=new char[fsize+1];
  fread(bufsearch, 1, fsize, searchres_fd);
  fclose(searchres_fd);

  if(unlink(TEMP_SEARCHRESULTS_FILENAME)==-1)
  {
    cerr<<"Error : unable to delete the search results file. Permissions problem ?"<<endl;
    exit(42);
  }
  parse_searchresults(res, bufsearch, fsize);

  delete bufsearch;
  delete phpsessid;
  delete search_encrypted;

  return(res);
}



void deezer_download(const char* dir, const char* id, const char* name)
{
  CURL *easyhandle;
  struct curl_slist *headers=NULL;
  struct curl_slist *headers2=NULL;
  struct curl_slist *headers3=NULL;
  char* phpsessid;
  char url[1024];
  char session_id[100];
  char postfield[1024];
  char key[100];
  char* pathname;
  char* decrypted_sessid, *decrypted_key;

  phpsessid=get_random_phpsessid();
  strcpy(url, "http://www.deezer.com/flashservices/gateway.php?PHPSESSID=");
  strcat(url, phpsessid);

  // Session initialization request
  easyhandle = curl_easy_init();
  curl_easy_setopt(easyhandle, CURLOPT_URL, url);
  curl_easy_setopt(easyhandle, CURLOPT_POSTFIELDS, amfphp_initsession_serialized);
  curl_easy_setopt(easyhandle, CURLOPT_POSTFIELDSIZE, sizeof(amfphp_initsession_serialized)-1);

#ifdef __WINDOWS__
  headers = curl_slist_append(headers, "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#else
  headers = curl_slist_append(headers, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#endif

  headers = curl_slist_append(headers, "Referer: http://www.deezer.com/index3.swf?Version=2-0-6");
  headers = curl_slist_append(headers, "Content-Type: application/x-amf");
  curl_easy_setopt(easyhandle, CURLOPT_HTTPHEADER, headers);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEFUNCTION, response_sessionid);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEDATA, &session_id);
  if(!curl_easy_perform(easyhandle))
  {
    cerr<<"Error : unable to do the SESSION_ID request."<<endl;
    exit(42);
  }
  curl_slist_free_all(headers);
  curl_easy_cleanup(easyhandle);
  decrypted_sessid=deezer_decrypt(session_id, TYPE_SESSION);

  // Streaming key request
  easyhandle = curl_easy_init();
  curl_easy_setopt(easyhandle, CURLOPT_URL, url);
  int current=0;
  for(unsigned int i=0; i<sizeof(amfphp_getkey_serialized_part1)-1; ++i)
    postfield[i]=amfphp_getkey_serialized_part1[i];
  current=sizeof(amfphp_getkey_serialized_part1)-1;
  short nb=htons(strlen(id)+strlen(decrypted_sessid)+11);

  postfield[current]=*((char*)(&nb));
  postfield[current+1]=*(((char*)(&nb))+1);
  current+=2;

  for(unsigned int i=0; i<sizeof(amfphp_getkey_serialized_part2)-1; ++i)
  {
    postfield[current]=amfphp_getkey_serialized_part2[i];
    ++current;
  }

  nb=htons(strlen(decrypted_sessid));
  postfield[current]=*((char*)(&nb));
  postfield[current+1]=*(((char*)(&nb))+1);
  current+=2;
  for(unsigned int i=0; i<strlen(decrypted_sessid); ++i)
  {
    postfield[current]=decrypted_sessid[i];
    ++current;
  }
  for(unsigned int i=0; i<sizeof(amfphp_getkey_serialized_part3)-1; ++i)
  {
    postfield[current]=amfphp_getkey_serialized_part3[i];
    ++current;
  }
  nb=htons(strlen(id));
  postfield[current]=*((char*)(&nb));
  postfield[current+1]=*(((char*)(&nb))+1);
  current+=2;
  for(unsigned int i=0; i<strlen(id); ++i)
  {
    postfield[current]=id[i];
    ++current;
  }

  curl_easy_setopt(easyhandle, CURLOPT_POSTFIELDS, postfield);
  curl_easy_setopt(easyhandle, CURLOPT_POSTFIELDSIZE, current);

#ifdef __WINDOWS__
  headers2 = curl_slist_append(headers2, "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#else
  headers2 = curl_slist_append(headers2, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#endif

  headers2 = curl_slist_append(headers2, "Referer: http://www.deezer.com/index3.swf?Version=2-0-6");
  headers2 = curl_slist_append(headers2, "Content-Type: application/x-amf");
  curl_easy_setopt(easyhandle, CURLOPT_HTTPHEADER, headers2);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEFUNCTION, response_getkey);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEDATA, &key);
  if(!curl_easy_perform(easyhandle))
  {
    cerr<<"Error : unable to do the streaming key request."<<endl;
    exit(42);
  }
  curl_slist_free_all(headers2);
  curl_easy_cleanup(easyhandle);

  decrypted_key=deezer_decrypt(key, TYPE_STREAMING);

  strcpy(url, "http://proxy-");
  url[13]=id[strlen(id)-2];
  url[14]='\0';
  strcat(url, ".deezer.com/cacheDiffusion.php?ID=");
  strcat(url, id);
  strcat(url, "&KEY=");
  strcat(url, decrypted_key);
  strcat(url, "&SESSION_ID=");
  strcat(url, decrypted_sessid);


  char* cleanname=new char[strlen(name)+1];
  for(unsigned int i=0; i<strlen(name); ++i)
  {
    if( ((name[i]<'a') || (name[i]>'z')) && ((name[i]<'A') || (name[i]>'Z')) && ((name[i]<'0') || (name[i]>'9')) )
      cleanname[i]='_';
    else
      cleanname[i]=name[i];
  }
  cleanname[strlen(name)]='\0';

  pathname=new char[strlen(dir)+strlen(cleanname)+6];
  strcpy(pathname, dir);
  strcat(pathname, "/");
  strcat(pathname, cleanname);
  strcat(pathname, ".mp3");

  FILE* fp=fopen(pathname, "wb");

  // Stream reception request
  easyhandle = curl_easy_init();
  curl_easy_setopt(easyhandle, CURLOPT_URL, url);

#ifdef __WINDOWS__
  headers3 = curl_slist_append(headers3, "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#else
  headers3 = curl_slist_append(headers3, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#endif

  headers3 = curl_slist_append(headers3, "Referer: http://www.deezer.com/index3.swf?Version=2-0-6");
  curl_easy_setopt(easyhandle, CURLOPT_HTTPHEADER, headers3);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEDATA, fp);
  if(curl_easy_perform(easyhandle))
  {
    cerr<<"Error : unable to do the stream reception request."<<endl;
    exit(42);
  }
  curl_slist_free_all(headers3);
  curl_easy_cleanup(easyhandle);

  fclose(fp);

  delete pathname;
  delete cleanname;
  delete phpsessid;
  delete decrypted_sessid;
  delete decrypted_key;
}



// Alternative download (using the cache).
void deezer_cache_download(const char* dir, const char* id, const char* name)
{
  CURL *easyhandle;
  struct curl_slist *headers3=NULL;
  char* pathname;
  char url[1024];

  strcpy(url, "http://proxy-");
  url[13]=id[strlen(id)-2];
  url[14]='\0';
  strcat(url, ".deezer.com/cache/");
  url[32]=id[strlen(id)-1];
  url[33]='\0';
  strcat(url, "/");
  strcat(url, id);
  strcat(url, ".rbs");

  char* cleanname=new char[strlen(name)+1];
  for(unsigned int i=0; i<strlen(name); ++i)
  {
    if( ((name[i]<'a') || (name[i]>'z')) && ((name[i]<'A') || (name[i]>'Z')) && ((name[i]<'0') || (name[i]>'9')) )
      cleanname[i]='_';
    else
      cleanname[i]=name[i];
  }
  cleanname[strlen(name)]='\0';

  pathname=new char[strlen(dir)+strlen(cleanname)+6];
  strcpy(pathname, dir);
  strcat(pathname, "/");
  strcat(pathname, cleanname);
  strcat(pathname, ".mp3");

  FILE* fp=fopen(pathname, "wb");

  // Stream reception request
  easyhandle = curl_easy_init();
  curl_easy_setopt(easyhandle, CURLOPT_URL, url);

#ifdef __WINDOWS__
  headers3 = curl_slist_append(headers3, "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#else
  headers3 = curl_slist_append(headers3, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; fr; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
#endif

  headers3 = curl_slist_append(headers3, "Referer: http://www.deezer.com/index3.swf?Version=2-0-6");
  curl_easy_setopt(easyhandle, CURLOPT_HTTPHEADER, headers3);
  curl_easy_setopt(easyhandle, CURLOPT_WRITEDATA, fp);
  if(curl_easy_perform(easyhandle))
  {
    cerr<<"Error : unable to do the stream reception request."<<endl;
    exit(42);
  }
  curl_slist_free_all(headers3);
  curl_easy_cleanup(easyhandle);

  fclose(fp);
}
