/* Copyright (C) 2006 G.P. Halkes
   Licensed under the Open Software License version 2.0 */

#ifndef DEFINITIONS_H
#define DEFINITIONS_H
#include <stdio.h>

#ifdef USE_GETTEXT
#	include <locale.h> 
#	include <libintl.h>
#	define _(String) gettext(String)
#else
#	define _(String) (String)
#endif
#define N_(String) String

#ifdef __GNUC__
void fatal(const char *fmt, ...) __attribute__((format (printf, 1, 2))) __attribute__((noreturn));
#else
/*@noreturn@*/void fatal(const char *fmt, ...);
#endif

#define PANIC() fatal(_("Program logic error at %s:%d\n"), __FILE__, __LINE__)

/* Define a bool type if not already defined (C++ and C99 do)*/
#if !(defined(__cplusplus) || (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 19990601L))
/*@-incondefs@*/
typedef enum {false, true} bool;
/*@+incondefs@*/
#elif defined(__STDC_VERSION__) && __STDC_VERSION__ >= 19990601L
#include <stdbool.h>
#endif

#define TEMPLATE "/tmp/dwdiffXXXXXXXX"
#define TEMPLATE_LENGTH sizeof(TEMPLATE)

typedef struct {
	FILE *file;
	char name[TEMPLATE_LENGTH];
} TempFile;

typedef struct {
	const char *name;
	FILE *input;
	TempFile *tokens;
	TempFile *whitespace;
	int lastPrinted;
} InputFile;

#ifndef DIFF
#	define DIFF "diff"
#endif

#ifdef NO_MINUS_A
#	define MINUS_A ""
#else
#	define MINUS_A " -a"
#endif

#define DIFF_COMMAND DIFF MINUS_A
/* Note: for the case that NO_MINUS_I is declared,
   this one is simply never used */
#define DIFF_COMMAND_CI DIFF_COMMAND " -i"

void doDiff(void);

typedef struct {
	int added,
		deleted,
		oldChanged,
		newChanged,
		oldTotal,
		newTotal;
} Statistics;
extern Statistics statistics;
extern int differences;

int yylex(void);
extern FILE *yyin;


TempFile *tempFile(void);

struct {
	InputFile oldFile,
		newFile;
	const char *delStart,
		*delStop,
		*addStart,
		*addStop,
		*delColor,
		*addColor;
	size_t delStartLen,
		delStopLen,
		addStartLen,
		addStopLen,
		delColorLen,
		addColorLen;
	char delimiters[64],
		whitespace[64];
	bool printDeleted,
		printAdded,
		printCommon,
		needMarkers,
		needStartStop;
	bool printer,
		less,
		statistics,
		ignoreCase,
		colorMode;
	bool transliterate;
	int whitespaceDelimiter;
	const char *diffOption;
} option;

#define SET_BIT(x, b) do { (x)[(b)>>3] |= 1 << ((b) & 0x7); } while (0);
#define TEST_BIT(x, b) ((x)[(b)>>3] & (1 << ((b) & 0x7)))

void parseCmdLine(int argc, char *argv[]);

#endif
