#!/usr/bin/perl

# $Id: dspam.cgi,v 1.1 2004/10/24 21:30:10 jonz Exp $
# DSPAM
# COPYRIGHT (C) 2004 NETWORK DWEEBS CORPORATION
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use Time::Local;
use vars qw { %CONFIG %DATA %FORM $MAILBOX $USER };
require "ctime.pl";

# Read configuration parameters common to all CGI scripts
require "configure.pl";

#
# The current CGI script
#

$CONFIG{'ME'} = "dspam.cgi";

$| = 1;

#
# Determine which extensions are available
#

$CONFIG{'PREFERENCES_EXTENSION'} = 0;
$CONFIG{'LARGE_SCALE'} = 0;
$CONFIG{'DOMAIN_SCALE'} = 0;
do {
  my $x = `dspam --version`;
  if ($x =~ /--enable-preferences-extension/) {
    $CONFIG{'PREFERENCES_EXTENSION'} = 1;
  }
  if ($x =~ /--enable-large-scale/) {
    $CONFIG{'LARGE_SCALE'} = 1;
  }
  if ($x =~ /--enable-domain-scale/) {
    $CONFIG{'DOMAIN_SCALE'} = 1;
  }
};

#
# Configure Filesystem
#

$USER = GetPath($ENV{'REMOTE_USER'});
$MAILBOX = $USER . ".mbox";

#
# Parse Form Variables
#

%FORM = &ReadParse;

if ($ENV{'REMOTE_USER'} eq "") { 
  &error("System Error. I was unable to determine your identity.");
}

if ($FORM{'template'} eq "" || $FORM{'template'} !~ /^([A-Z0-9]*)$/i) {
  $FORM{'template'} = "performance";
}

#
# Set up initial display variables
#
&CheckQuarantine;
$DATA{'REMOTE_USER'} = $ENV{'REMOTE_USER'};

#
# Process Commands
#

# Performance
if ($FORM{'template'} eq "performance") {
  &ResetStats if ($FORM{'command'} eq "resetStats");
  &Tweak if ($FORM{'command'} eq "tweak");
  &DisplayIndex;

# Quarantine
} elsif ($FORM{'template'} eq "quarantine") {
  if ($FORM{'command'} eq "viewMessage") {
    &Quarantine_ViewMessage;
  } else {
    &ProcessQuarantine if ($FORM{'command'} eq "processQuarantine");
    &ProcessFalsePositive if ($FORM{'command'} eq "processFalsePositive");
    &DisplayQuarantine;
  }

# Alerts
} elsif ($FORM{'template'} eq "alerts") {
  &AddAlert if ($FORM{'command'} eq "addAlert");
  &DeleteAlert if ($FORM{'command'} eq "deleteAlert");
  &DisplayAlerts;

# Preferences
} elsif ($FORM{'template'} eq "preferences") {
  &DisplayPreferences;

# Analysis
} elsif ($FORM{'template'} eq "analysis") {
  &DisplayAnalysis;

# History
} elsif ($FORM{'template'} eq "history") {
  &DisplayHistory;
} else {
  &error("Invalid Command $FORM{'COMMAND'}");
}

#
# History Functions
# 
sub DisplayHistory {
  my(@buffer);
  my($time, $class, $from, $subject, $line);
  my($rowclass) = "rowEven";
  my($LOG) = "$USER.log";
  if (! -e $LOG) {
    &error("No historical data is available.");
  }

  open(LOG, "tail -$CONFIG{'HISTORY_SIZE'} $LOG|");
  while(<LOG>) {
    push(@buffer, $_);
  }
  close(LOG);

  while($line = pop(@buffer)) {
    chomp($line);
    ($time, $class, $from, $subject) = split(/\t/, $line);
    my($ctime) = ctime($time);
    $ctime = join(" ", (split(/\s+/, $ctime))[0,3]);
    my($cl, $cllabel);
    if ($class eq "S") { $cl = "spam"; $cllabel="SPAM"; }
    elsif ($class eq "I") { $cl = "innocent"; $cllabel="Good"; }
    elsif ($class eq "F") { $cl = "false"; $cllabel="Miss"; }
    elsif ($class eq "M") { $cl = "missed"; $cllabel="Miss"; }
    elsif ($class eq "N") { $cl = "inoculation"; $cllabel="Spam"; }
    elsif ($class eq "C") { $cl = "corpus"; $cllabel="Feed"; }
    elsif ($class eq "W") { $cl = "whitelisted"; $cllabel="Good"; }
    $subject = substr($subject, 0, $CONFIG{'MAX_COL_LEN'});
    $from = substr($from, 0, $CONFIG{'MAX_COL_LEN'});
    if (length($subject)==$CONFIG{'MAX_COL_LEN'}) {
      $subject .= "...";
    }
    if (length($from)==$CONFIG{'MAX_COL_LEN'}) {
      $from .= "...";
    }

    $from =~ s/</&lt;/g;
    $from =~ s/>/&gt;/g;
    $subject =~ s/</&lt;/g;
    $subject =~ s/>/&gt;/g;

    $DATA{'HISTORY'} .= <<_END;
<tr>
	<td class="$cl $rowclass" nowrap="true">$cllabel</td>
	<td class="$rowclass" nowrap="true">$ctime</td>
	<td class="$rowclass" nowrap="true">$from</td>
	<td class="$rowclass" nowrap="true">$subject</td>
</tr>
_END
    if ($rowclass eq "rowEven") {
      $rowclass = "rowOdd";
    } else {
      $rowclass = "rowEven";
    }
  }

  &output(%DATA);
}

#
# Analysis Functions
#

sub DisplayAnalysis {
  my($LOG) = "$USER.log";
  my(@spam_daily, @nonspam_daily, @period_daily);
  my(@spam_weekly, @nonspam_weekly, @period_weekly);

  my ($min, $hour, $mday, $mon, $year) = (localtime(time))[1,2,3,4,5];
  my ($daystart) = timelocal(0, 0, 0, $mday, $mon, $year);
  my ($periodstart) = $daystart - (3600*24*13); # 2 Weeks ago
  my ($dailystart) = time - (3600*23);
  my ($c_weekly) = 0; # Cursor to most recent time slot
  my ($c_daily) = 0; 

  if (! -e $LOG) {
    &error("No historical data is available.");
  }

  # Initialize each individual time period

  for(0..23) {
    my($h) = To12Hour($hour-(23-$_));
    $period_daily[$_]	= $h;
    $spam_daily[$_]	= 0;
    $nonspam_daily[$_]	= 0;
  }

  for(0..13) {
    my($d) = $daystart - (3600*24*(13-$_));
    my ($lday, $lmon) = (localtime($d))[3,4];
    $lmon++;
    $period_weekly[$_]	= "$lmon/$lday";
    $spam_weekly[$_]	= 0;
    $nonspam_weekly[$_]	= 0;
  }

  open(LOG, "<$LOG") || &error("Unable to open logfile: $!");
  while(<LOG>) {
    my($t_log, $c_log) = split(/\t/);

    # Only Parse Log Data in our Time Period
    if ($t_log>=$periodstart) {
      my($tmin, $thour, $tday, $tmon) = (localtime($t_log))[1,2,3,4];
      $tmon++;

      # Weekly Graph
      while($period_weekly[$c_weekly] ne "$tmon/$tday" && $c_weekly<15) {
        $c_weekly++;
      }
      if ($period_weekly[$c_weekly] ne "") {

        if ($c_log eq "S") { $spam_weekly[$c_weekly]++; }
        if ($c_log eq "I" || $c_log eq "W") { $nonspam_weekly[$c_weekly]++; } 
        if ($c_log eq "F") 
          { $spam_weekly[$c_weekly]--; $nonspam_weekly[$c_weekly]++; 
            $spam_weekly[$c_weekly] = 0 if ($spam_weekly[$c_weekly]<0); }
        if ($c_log eq "M")
          { $spam_weekly[$c_weekly]++; $nonspam_weekly[$c_weekly]--; 
            $nonspam_weekly[$c_weekly] = 0 if ($nonspam_weekly[$c_weekly]<0); }
      }


      # Daily Graph
      if ($t_log>=$dailystart) {
        while($period_daily[$c_daily] ne To12Hour($thour) && $c_daily<24) {
          $c_daily++;
        }

        if ($c_log eq "S") { $spam_daily[$c_daily]++; }
        if ($c_log eq "I" || $c_log eq "W") { $nonspam_daily[$c_daily]++; }
        if ($c_log eq "F") 
          { $spam_daily[$c_daily]--; $nonspam_daily[$c_daily]++; 
            $spam_daily[$c_daily] = 0 if ($spam_daily[$c_daily]<0); }
        if ($c_log eq "M")
          { $spam_daily[$c_daily]++; $nonspam_daily[$c_daily]--; 
            $nonspam_daily[$c_daily] = 0 if ($nonspam_daily[$c_daily]<0); }
      }
    }
  }
  close(LOG);

  $DATA{'DATA_DAILY'} = join(",", @spam_daily);
  $DATA{'DATA_DAILY'} .= "_";
  $DATA{'DATA_DAILY'} .= join(",", @nonspam_daily);
  $DATA{'DATA_DAILY'} .= "_";
  $DATA{'DATA_DAILY'} .= join(",", @period_daily);

  $DATA{'DATA_WEEKLY'} = join(",", @spam_weekly);
  $DATA{'DATA_WEEKLY'} .= "_";
  $DATA{'DATA_WEEKLY'} .= join(",", @nonspam_weekly);
  $DATA{'DATA_WEEKLY'} .= "_";
  $DATA{'DATA_WEEKLY'} .= join(",", @period_weekly);

  foreach(@spam_daily)		{ $DATA{'TS_DAILY'} += $_; };
  foreach(@nonspam_daily)	{ $DATA{'TI_DAILY'} += $_; }
  foreach(@spam_weekly)		{ $DATA{'TS_WEEKLY'} += $_; }
  foreach(@nonspam_weekly)	{ $DATA{'TI_WEEKLY'} += $_; }

  &output(%DATA);
}

#
# Preferences Functions
#

sub DisplayPreferences {
  my(%PREFS);
  my($FILE) = "$USER.prefs";

  my $username = $ENV{REMOTE_USER};

  if ($FORM{'submit'} ne "") {

    if ($FORM{'enableBNR'} ne "on") {
      $FORM{'enableBNR'} = "off";
    }

    if ($FORM{'optIn'} ne "on") {
      $FORM{'optIn'} = "off";
    }

    if ($FORM{'optOut'} ne "on") {
      $FORM{'optOut'} = "off";
    }

    if ($FORM{'showFactors'} ne "on") {
      $FORM{'showFactors'} = "off";
    }
                                                                                
    if ($FORM{'enableWhitelist'} ne "on") {
      $FORM{'enableWhitelist'} = "off";
    }

    if ($CONFIG{'PREFERENCES_EXTENSION'} == 1) {

      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " trainingMode " . quotemeta($FORM{'trainingMode'}) . " > /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " spamAction " . quotemeta($FORM{'spamAction'}) . " > /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " signatureLocation "
        . quotemeta($FORM{'signatureLocation'}) . " > /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " spamSubject " . quotemeta($FORM{'spamSubject'}) . " > /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " statisticalSedation "
        . quotemeta($FORM{'statisticalSedation'}) . " > /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " enableBNR "
        . quotemeta($FORM{'enableBNR'}) . "> /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " optOut "
        . quotemeta($FORM{'optOut'}) . ">/dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " optIn "
        . quotemeta($FORM{'optIn'}) . ">/dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " showFactors "
        . quotemeta($FORM{'showFactors'}) . "> /dev/null");
      system("dspam_admin ch pref ".quotemeta($ENV{'REMOTE_USER'}).
        " enableWhitelist "
        . quotemeta($FORM{'enableWhitelist'}) . "> /dev/null");


    } else {
      open(FILE, ">$FILE") || do { &error("Unable to write preferences: $!"); };
      print FILE <<_END;
trainingMode=$FORM{'trainingMode'}
spamAction=$FORM{'spamAction'}
spamSubject=$FORM{'spamSubject'}
statisticalSedation=$FORM{'statisticalSedation'}
enableBNR=$FORM{'enableBNR'}
optIn=$FORM{'optIn'}
optOut=$FORM{'optOut'}
showFactors=$FORM{'showFactors'}
enableWhitelist=$FORM{'enableWhitelist'}
signatureLocation=$FORM{'signatureLocation'}
_END
      close(FILE);
    }
  }

  if ($CONFIG{'PREFERENCES_EXTENSION'} == 1) {
    open(PIPE, "dspam_admin l pref " . quotemeta($username) . "|");
    while(<PIPE>) {
      chomp;
      my($directive, $value) = split(/\=/);
      $PREFS{$directive} = $value;
    }
    close(PIPE);
  } 

  if (keys(%PREFS) eq "0" || $CONFIG{'PREFERENCES_EXTENSION'} != 1) {
    if (! -e $FILE) {
      $FILE = "./default.prefs";
    }

    if (! -e $FILE) {
      &error("Unable to load default preferences");
    }

    open(FILE, "<$FILE");
    while(<FILE>) {
      chomp;
      my($directive, $value) = split(/\=/);
      $PREFS{$directive} = $value;
    }
    close(FILE);
  }

  $DATA{"SEDATION_$PREFS{'statisticalSedation'}"} = "CHECKED";
  $DATA{"S_".$PREFS{'trainingMode'}} = "CHECKED";
  $DATA{"S_ACTION_".uc($PREFS{'spamAction'})} = "CHECKED"; 
  $DATA{"S_LOC_".uc($PREFS{'signatureLocation'})} = "CHECKED";
  $DATA{"SPAM_SUBJECT"} = $PREFS{'spamSubject'};
  if ($PREFS{'optIn'} eq "on") {
    $DATA{'C_OPTIN'} = "CHECKED";
  }
  if ($PREFS{'optOut'} eq "on") {
    $DATA{'C_OPTOUT'} = "CHECKED";
  }
  if ($PREFS{"enableBNR"} eq "on") {
    $DATA{"C_BNR"} = "CHECKED";
  }
  if ($PREFS{"showFactors"} eq "on") {
    $DATA{"C_FACTORS"} = "CHECKED"; 
  }
  if ($PREFS{"enableWhitelist"} eq "on") {
    $DATA{"C_WHITELIST"} = "CHECKED";
  }

  &output(%DATA);
}

#
# Quarantine Functions
#

sub ProcessQuarantine {
  if ($FORM{'manyNotSpam'} ne "") {
    &Quarantine_ManyNotSpam;
  } else {
    &Quarantine_DeleteSpam;
  }
  &CheckQuarantine;
  return;
}

sub ProcessFalsePositive {
  my(@buffer);
  if ($FORM{'messageID'} eq "") {
    &error("No Message ID Specified");
  }
  open(FILE, "<$MAILBOX");
  while(<FILE>) {
    chomp;
    push(@buffer, $_);
  }
  close(FILE);

  open(PIPE, "|$CONFIG{'DSPAM'} $CONFIG{'DSPAM_ARGS'}") || &error($!);
  while($#buffer>=0) {
    my($buff, $mode, @temp, %head);
    $mode = 0;
    @temp = ();
    while(($buff !~ /^From /) && ($#buffer>=0)) {
      $buff = $buffer[0];
      if ($buff =~ /^From /) {
        if ($mode == 0) { $mode = 1; }
        else { next; }
      }
      $buff = shift(@buffer);
      if ($buff !~ /^From /) {
        push(@temp, $buff);
      }
      next;
     }
     foreach(@temp) {
       last if ($_ eq "");
       my($key, $val) = split(/\: ?/, $_, 2);
       $head{$key} = $val;
     }
     $head{'Message-ID'} = $head{'Message-Id'} if ($head{'Message-ID'} eq "");
     $head{'Message-ID'} = $head{'X-DSPAM-Signature'} if ($head{'Message-ID'} eq "");
     if ($head{'Message-ID'} eq $FORM{'messageID'}) {
       foreach(@temp) {
       print PIPE "$_\n";
     }
   }
 }
   close(PIPE);
   $FORM{$FORM{'messageID'}} = "on";
   &Quarantine_DeleteSpam();
  return;
}

sub Quarantine_ManyNotSpam {
  my(@buffer);

  open(FILE, "<$MAILBOX");
  while(<FILE>) {
    chomp;
    push(@buffer, $_);
  }
  close(FILE);

  open(FILE, ">$MAILBOX");

  while($#buffer>=0) {
    my($buff, $mode, @temp, %head);
    $mode = 0;
    while(($buff !~ /^From /) && ($#buffer>=0)) {
      $buff = $buffer[0];
      if ($buff =~ /^From /) {
        if ($mode == 0) {
          $mode = 1;
          $buff = shift(@buffer);
          push(@temp, $buff);
          $buff = "";
          next;
        } else {
          next;
        }
      }
      $buff = shift(@buffer);
      push(@temp, $buff);
      next;
    }
    foreach(@temp) {
      last if ($_ eq "");
      my($key, $val) = split(/\: ?/, $_, 2);
      $head{$key} = $val;
    }
    $head{'Message-ID'} = $head{'Message-Id'} if ($head{'Message-ID'} eq "");
    $head{'Message-ID'} = $head{'X-DSPAM-Signature'} if ($head{'Message-ID'} eq "");
    if ($FORM{$head{'Message-ID'}} eq "") {
      foreach(@temp) {
        print FILE "$_\n";
      }
    } else {
      open(PIPE, "|$CONFIG{'DSPAM'} $CONFIG{'DSPAM_ARGS'}") || &error($!);
      foreach(@temp) {
        print PIPE "$_\n";
      }
      close(PIPE);
    }
  }
  close(FILE);
  return;
}

sub Quarantine_ViewMessage {
  my(@buffer);

  if ($FORM{'messageID'} eq "") {
    &error("No Message ID Specified");
  }

  $DATA{'MESSAGE_ID'} = $FORM{'messageID'};

  open(FILE, "<$MAILBOX");
  while(<FILE>) {
    chomp;
    push(@buffer, $_);
  }
  close(FILE);

  while($#buffer>=0) {
    my($buff, $mode, @temp, %head);
    $mode = 0;
    @temp = ();
    while(($buff !~ /^From /) && ($#buffer>=0)) {
      $buff = $buffer[0];
      if ($buff =~ /^From /) {
        if ($mode == 0) { $mode = 1; }
        else { next; }
      }
      $buff = shift(@buffer);
      if ($buff !~ /^From /) {
        push(@temp, $buff);
      }
      next;
    }
    foreach(@temp) {
      last if ($_ eq "");
      my($key, $val) = split(/\: ?/, $_, 2);
      $head{$key} = $val;
    }
    $head{'Message-ID'} = $head{'Message-Id'} if ($head{'Message-ID'} eq "");
    $head{'Message-ID'} = $head{'X-DSPAM-Signature'} if ($head{'Message-ID'} eq "");
    if ($head{'Message-ID'} eq $FORM{'messageID'}) {
      foreach(@temp) {
        s/</\&lt\;/g;
        s/>/\&gt\;/g;
        $DATA{'MESSAGE'} .= "$_\n";
      }
    }
  }
  $FORM{'template'} = "viewmessage";
  &output(%DATA);
}

sub Quarantine_DeleteSpam {
  my(@buffer);
  if ($FORM{'deleteAll'} ne "") {
    my($sz);

    my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
     $atime,$mtime,$ctime,$blksize,$blocks)
     = stat("$USER.mbox");
                                                                                
    open(FILE, "<$USER.mbox.size");
    $sz = <FILE>;
    close(FILE); 
    chomp($sz);

    if ($sz == $size) {
      open(FILE, ">$MAILBOX");
      close(FILE);
      unlink("$USER.mbox.size");
      unlink("$USER.mboxwarn");
    } else {
      return &DisplayQuarantine;
    }

    $FORM{'template'} = "performance";
    &CheckQuarantine;
    return &DisplayIndex; 
  }
  open(FILE, "<$MAILBOX");
  while(<FILE>) {
    chomp;
    push(@buffer, $_);
  }
  close(FILE);
 

  open(FILE, ">$MAILBOX");
 
  while($#buffer>=0) {
    my($buff, $mode, @temp, %head);
    $mode = 0;
    while(($buff !~ /^From /) && ($#buffer>=0)) {
      $buff = $buffer[0];
      if ($buff =~ /^From /) {
        if ($mode == 0) { 
          $mode = 1; 
          $buff = shift(@buffer); 
          push(@temp, $buff); 
          $buff = ""; 
          next; 
        } else { 
          next; 
        }
      }
      $buff = shift(@buffer);
      push(@temp, $buff);
      next;
    }
    foreach(@temp) {
      last if ($_ eq "");
      my($key, $val) = split(/\: ?/, $_, 2);
      $head{$key} = $val;
    }
    $head{'Message-ID'} = $head{'Message-Id'} if ($head{'Message-ID'} eq "");
    $head{'Message-ID'} = $head{'X-DSPAM-Signature'} if ($head{'Message-ID'} eq "");
    if ($FORM{$head{'Message-ID'}} eq "") {
      foreach(@temp) {
        print FILE "$_\n";
      }
    }
  }
  close(FILE);
  return;
}

sub by_rating { $a->{'rating'} <=> $b->{'rating'} }

sub DisplayQuarantine {
  my(@alerts);

  my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
   $atime,$mtime,$ctime,$blksize,$blocks)
   = stat("$USER.mbox");

  open(FILE, ">$USER.mbox.size");
  print(FILE "$size");
  close(FILE);

  open(FILE, "<$USER.alerts");
  while(<FILE>) {
    chomp;
    push(@alerts, $_);
  }
  close(FILE);

  my($next, @buffer, $rowclass, $mode, $markclass, $marklabel, @headings);
  $rowclass="rowEven";
  open(FILE, "<$MAILBOX");
  while(<FILE>) {
    chomp;
    if ($_ ne "") {
      if ($mode eq "") { 
        if ($_ =~ /^From /) {
          $mode = 1;
        } else { 
          next; 
        } 
      }
      push(@buffer, $_);
      next;
    }
    next if ($mode eq "");

    my($new, $start, $alert);
    $alert = 0;
    $new = {};
    foreach(@buffer) {
      my($al);
      foreach $al (@alerts) {
        if (/$al/i) {
          $alert = 1;
        }
      }
      if ($_ =~ /^From /) {
        my(@a) = split(/ /, $_);
        my($x) = 2;
        for (0..$#a) { 
          if (($a[$_] =~ /\@|>/) && ($_>$x)) { 
            $x = $_ + 1;
          }
        }
        for(1..$x) { shift(@a); }
        $start = join(" ", @a);
      } else {
        my($key, $val) = split(/\: ?/, $_, 2);
        $new->{$key} = $val; 
      }
    }
    if ($rowclass eq "rowEven") { 
      $rowclass = "rowOdd";
    } else { 
      $rowclass = "rowEven";
    }

    $new->{'alert'} = $alert;

    if ($alert) { $rowclass="rowAlert"; }

    $new->{'Sub2'} = $new->{'X-DSPAM-Signature'};
    if (length($new->{'Subject'})>$CONFIG{'MAX_COL_LEN'}) {
      $new->{'Subject'} = substr($new->{'Subject'}, 0, $CONFIG{'MAX_COL_LEN'}) . "...";
    } 
 
    if (length($new->{'From'})>$CONFIG{'MAX_COL_LEN'}) {
      $new->{'From'} = substr($new->{'From'}, 0, $CONFIG{'MAX_COL_LEN'}) . "...";
    }

    if ($new->{'Subject'} eq "") {
      $new->{'Subject'} = "<None Specified>";
    }

#   $new->{'rating'} = $new->{'X-DSPAM-Probability'} * $new->{'X-DSPAM-Confidence'};
    $new->{'rating'} = $new->{'X-DSPAM-Confidence'};

    $new->{'Message-ID'} = $new->{'Message-Id'} if ($new->{'Message-ID'} eq "");
    $new->{'Message-ID'} = $new->{'Sub2'} if ($new->{'Message-ID'} eq "");

    foreach(keys(%$new)) {
      next if ($_ eq "Message-ID");
      $new->{$_} =~ s/</\&lt\;/g;
      $new->{$_} =~ s/>/\&gt\;/g;
    }

    push(@headings, $new);

    @buffer = ();
    $mode = "";
    next;
  }

  my($sortBy) = $FORM{'sortby'};
  if ($sortBy eq "") {
    $sortBy = $CONFIG{'SORT_DEFAULT'};
  }
  if ($sortBy eq "Rating") {
    @headings = sort by_rating @headings;
  }

  $DATA{'SORT_SELECTOR'} .=  "Sort by: <a href=\"$CONFIG{'ME'}?template=quarantine&sortby=Rating\">";
  if ($sortBy eq "Rating") {
    $DATA{'SORT_SELECTOR'} .= "<strong>Rating</strong>";
  } else {
    $DATA{'SORT_SELECTOR'} .= "Rating";
  }
  $DATA{'SORT_SELECTOR'} .=  "</a> | <a href=\"$CONFIG{'ME'}?template=quarantine&sortby=Date\">";
  if ($sortBy eq "Date") {
    $DATA{'SORT_SELECTOR'} .= "<strong>Date</strong>";
  } else {
    $DATA{'SORT_SELECTOR'} .= "Date";
  }
  $DATA{'SORT_SELECTOR'} .=  "</a>";


  my($row, $rowclass);
  $rowclass = "rowEven";
  for $row (@headings) {
    my($rating, $url, $markclass, $outclass);
    $rating = sprintf("%3.0f%%", $row->{'rating'} * 100.0);
    if ($row->{'rating'} > 0.8) {
	$markclass = "high";
    } else {
	if ($row->{'rating'} < 0.7) {
	    $markclass = "low";
	} else {
	    $markclass = "medium";
	}
    }

    my(%PAIRS);
    $PAIRS{'messageID'} = $row->{'Message-ID'};
    $PAIRS{'command'}  = "viewMessage";
    $PAIRS{'template'} = "quarantine";
    $url = &SafeVars(%PAIRS);

    if ($row->{'alert'}) {
      $outclass = "rowAlert";
    } else {
      $outclass = $rowclass;
    }

    $DATA{'QUARANTINE'} .= <<_END;
<tr>
	<td class="$outclass" nowrap="true"><input type="checkbox" name="$row->{'Message-ID'}"></td>
	<td class="$outclass $markclass" nowrap="true">$rating</td>
	<td class="$outclass" nowrap="true">$row->{'From'}</td>
	<td class="$outclass" nowrap="true"><a href="$CONFIG{'ME'}?$url">$row->{'Subject'}</a></td>
</tr>
_END

    if ($rowclass eq "rowEven") {
      $rowclass = "rowOdd";
    } else {
      $rowclass = "rowEven";
    }
  }

  &output(%DATA);
}

#
# Performance Functions
#

sub ResetStats {
  my($stats);
  open(FILE, "<$USER.stats");
  chomp($stats = <FILE>);
  close(FILE);
  open(FILE, ">$USER.rstats");
  print FILE "$stats\n";
  close(FILE);
}

sub Tweak {
  my($ts, $ti, $tm, $fp, $sc, $ic);
  open(FILE, "<$USER.rstats");
  chomp($ts = <FILE>);
  close(FILE);
  ($ts, $ti, $tm, $fp, $sc, $ic) = split(/\,/, $ts);
  $tm++;
  open(FILE, ">$USER.rstats");
  print FILE "$ts,$ti,$tm,$fp,$sc,$ic\n";
  close(FILE);
}

sub DisplayIndex {
  my($spam, $innocent, $ratio, $fp, $misses);
  my($rts, $rti, $rtm, $rfp, $sc, $ic, $overall, $fpratio, $monthly, 
     $real_missed, $real_caught, $real_fp, $real_innocent);
  my($time) = ctime(time);
  my($group);

  open(FILE, "<$USER.stats");
  chomp($spam = <FILE>);
  chomp($group = <FILE>); 
  close(FILE);
  ($spam, $innocent, $misses, $fp, $sc, $ic) = split(/\,/, $spam);

  if ($group ne "") {
    my($GROUP) = GetPath($group) . ".stats";
    my($gspam, $ginnocent, $gmisses, $gfp, $gsc, $gic);
    open(FILE, "<$GROUP");
    chomp($gspam = <FILE>);
    close(FILE);
    ($gspam, $ginnocent, $gmisses, $gfp, $gsc, $gic) = split(/\,/, $gspam);
    $spam     -= $gspam;
    $innocent -= $ginnocent;
    $misses   -= $gmisses;
    $fp       -= $gfp;
    $sc       -= $gsc;
    $ic       -= $gic;
  }

  if ($spam+$innocent>0) { 
    $ratio = sprintf("%2.3f", 
      (($spam+$misses)/($spam+$misses+$fp+$innocent)*100)); 
  } else { 
    $ratio = 0; 
  }

  if (open(FILE, "<$USER.rstats")) {
    my($rstats);
   
    chomp($rstats = <FILE>);
    ($rts, $rti, $rtm, $rfp) = split(/\,/, $rstats);
    close(FILE);
    $real_missed = $misses-$rtm;
    $real_caught = $spam-$rts;
    $real_fp = $fp-$rfp;
    $real_innocent = $innocent-$rti; 
    if (($spam-$rts > 0) && ($spam-$rts + $misses-$rtm != 0) &&
        ($real_caught+$real_missed>0) && ($real_fp+$real_innocent>0)) {
      $monthly = sprintf("%2.3f", 
        (100.0-(($real_missed)/($real_caught+$real_missed))*100.0));
      $overall = sprintf("%2.3f", 
        (100-((($real_missed+$real_fp) / 
        ($real_fp+$real_innocent+$real_caught+$real_missed))*100)));
    } else {
      $monthly = 100;
      $overall = 100;
    }

    if ($real_fp+$real_innocent>0) {
      $fpratio = sprintf("%2.0f", ($real_fp/($real_fp+$real_innocent)*100));
    } else {
      $fpratio = 0;
    }

  } else {
    $rts = $spam+$misses;
    $rti = $innocent;
    $rtm = $misses;
    $rfp = $fp;
    open(FILE, ">$USER.rstats");
    print FILE "$rts,$rti,$rtm,$rfp\n";
    close(FILE);
    $monthly = "N/A";
    $fpratio = "N/A";
    $overall = "N/A";
  }

  $DATA{'TIME'} = $time;
  $DATA{'TOTAL_SPAM_SCANNED'} = $spam;
  $DATA{'TOTAL_SPAM_LEARNED'} = $misses;
  $DATA{'TOTAL_NONSPAM_SCANNED'} = $innocent;
  $DATA{'TOTAL_NONSPAM_LEARNED'} = $fp;
  $DATA{'SPAM_RATIO'} = $ratio;
  $DATA{'SPAM_ACCURACY'} = $monthly;
  $DATA{'NONSPAM_ERROR_RATE'} = $fpratio;
  $DATA{'OVERALL_ACCURACY'} = $overall;
  $DATA{'TOTAL_SPAM_CORPUSFED'} = $sc;
  $DATA{'TOTAL_NONSPAM_CORPUSFED'} = $ic;
  $DATA{'TOTAL_SPAM_MISSED'} = $real_missed;
  $DATA{'TOTAL_SPAM_CAUGHT'} = $real_caught;
  $DATA{'TOTAL_NONSPAM_MISSED'} = $real_fp;
  $DATA{'TOTAL_NONSPAM_CAUGHT'} = $real_innocent;

  $DATA{'LOCAL_DOMAIN'} = $CONFIG{'LOCAL_DOMAIN'};
  
  &output(%DATA);
}

#
# Alert Functions
#

sub AddAlert {
  if ($FORM{'ALERT'} eq "") {
    &error("No Alert Specified");
  }
  open(FILE, ">>$USER.alerts");
  print FILE "$FORM{'ALERT'}\n";
  close(FILE);
  return;
}
                                                                                
sub DeleteAlert {
  my($line, @alerts);
  $line = 0;
  if ($FORM{'line'} eq "") {
    &Error("No Alert Specified");
  }
  open(FILE, "<$USER.alerts");
  while(<FILE>) {
    if ($line != $FORM{'line'}) {
      push(@alerts, $_);
    }
    $line++;
  }
  close(FILE);
                                                                                
  open(FILE, ">$USER.alerts");
  foreach(@alerts) { print FILE $_; }
  close(FILE);
  return;
}

sub DisplayAlerts {
  my($supp);
  
  $DATA{'ALERTS'} = <<_end;
<table border="0" cellspacing="0" cellpadding="2">
	<tr>
		<th>Alert Name</th>
		<th>&nbsp;</th>
	</tr>
_end

  my($rowclass);
  $rowclass = "rowEven";

  do {
    my($line) = 0;
    open(FILE, "<$USER.alerts");
    while(<FILE>) {
      s/</&lt;/g;
      s/>/&gt;/g;
      $DATA{'ALERTS'} .= qq!<tr><td class="$rowclass">$_</td><td class="$rowclass">[<a href="$CONFIG{'ME'}?command=deleteAlert&template=alerts&line=$line">Remove</a>]</td></tr>\n!;
      $line++;

      if ($rowclass eq "rowEven") {
	$rowclass = "rowOdd";
      } else {
	$rowclass = "rowEven";
      }
    }
  }; 

$DATA{'ALERTS'} .= <<_end;
</table>
_end

  &output(%DATA);
  exit;
}

#
# Global Functions
#

sub output {
  if ($FORM{'template'} eq "" || $FORM{'template'} !~ /^([A-Z0-9]*)$/i) {
    $FORM{'template'} = "performance";
  }
  print "Expires: now\n";
  print "Pragma: no-cache\n";
  print "Cache-control: no-cache\n";
  print "Content-type: text/html\n\n";
  my(%DATA) = @_;

  # Check admin permissions
  do {
    my($admin) = 0;
    open(FILE, "<./admins");
    while(<FILE>) {
      chomp;
      if ($_ eq $ENV{'REMOTE_USER'}) {
        $admin = 1;
      }
    }
    close(FILE);

    if ($admin) {
      $DATA{'NAV_ADMIN'} = '<li><a href="admin.cgi">Administrative Suite</a></li>';
    } else {
      $DATA{'NAV_ADMIN'} = '';
    }
  };

  open(FILE, "<$CONFIG{'TEMPLATES'}/nav_$FORM{'template'}.html");
  while(<FILE>) { 
    s/\$CGI\$/$CONFIG{'ME'}/g;
    s/\$([A-Z0-9_]*)\$/$DATA{$1}/g; 
    print;
  }
  close(FILE);
  exit(0);
}

sub SafeVars {
  my(%PAIRS) = @_;
  my($url, $key);
  foreach $key (keys(%PAIRS)) {
    my($value) = $PAIRS{$key};
    $value =~ s/([^A-Z0-9])/sprintf("%%%x", ord($1))/gie;
    $url .= "$key=$value&";
  }
  $url =~ s/\&$//;
  return $url;
}

sub error {
  my($error) = @_;
  $FORM{'template'} = "error";
  $DATA{'MESSAGE'} = <<_end;
The following error occured while trying to process your request: <BR>
<B>$error</B><BR>
<BR>
If this problem persists, please contact your administrator.
_end
  &output(%DATA);
  exit;
}

sub ReadParse {
  my(@pairs, %FORM);
  if ($ENV{'REQUEST_METHOD'} =~ /GET/i)
    { @pairs = split(/&/, $ENV{'QUERY_STRING'}); }
  else {
    my($buffer);
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
    @pairs = split(/\&/, $buffer);
  }
  foreach(@pairs) {
    my($name, $value) = split(/\=/, $_);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<!--(.|\n)*-->//g;
    $FORM{$name} = $value;
  }
  return %FORM;
}

sub CheckQuarantine {
  my($f)=0;
  open(FILE, "<$MAILBOX");
  while(<FILE>) {
    next unless (/^From /);
    $f++;
  }
  close(FILE);   
  if ($f == 0) {
    $f = "Empty";
  }

  $DATA{'TOTAL_QUARANTINED_MESSAGES'} = $f;
}

sub To12Hour {
  my($h) = @_;
  if ($h < 0) { $h += 24; }
  if ($h>11) { $h -= 12 if ($h>12) ; $h .= "p"; }
  else { $h = "12" if ($h == 0); $h .= "a"; }
  return $h;
}

sub GetPath {
  my($USER) = @_;
  my($PATH);

  # Domain-scale
  if ($CONFIG{'DOMAIN_SCALE'} == 1) {
    my($VPOPUSERNAME, $VPOPDOMAIN);

    $VPOPUSERNAME = (split(/@/, $USER))[0];
    $VPOPDOMAIN = (split(/@/, $USER))[1];
    $VPOPDOMAIN = "local" if ($VPOPDOMAIN eq "");

    $PATH = "$CONFIG{'DSPAM_HOME'}/data/$VPOPDOMAIN/$VPOPUSERNAME/" .
            "$VPOPUSERNAME";
    return $PATH;

  # Normal scale
  } elsif ($CONFIG{'LARGE_SCALE'} == 0) {
    $PATH = "$CONFIG{'DSPAM_HOME'}/data/$USER/$USER";
    return $PATH;
                                                                                
  # Large-scale
  } else {
    if (length($USER)>1) {
      $PATH = "$CONFIG{'DSPAM_HOME'}/data/" . substr($USER, 0, 1) .
        "/". substr($USER, 1, 1) . "/$USER/$USER";
    } else {
      $PATH = "$CONFIG{'DSPAM_HOME'}/data/$USER/$USER";
    }
    return $PATH;
  }

  &error("Unable to determine filesystem scale");
}
