/*
  decode_x11.c

  X11.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
  
  $Id: decode_x11.c,v 1.2 2000/06/14 16:16:01 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_x11(u_char *buf, int len)
{
	char *p, *q;
	int i;
	
	p = buf + 12;
	
	if (strncmp(p, "MIT-MAGIC-COOKIE-1", 18) != 0 || len < 36)
		return (0);
	
	strlcpy(Buf, "MIT-MAGIC-COOKIE-1 ", sizeof(Buf));
	
	p += 20;
	len -= 20;
	q = Buf + 19;
	
	for (i = 0; i < 16 && i < len; i++)
		sprintf(q + (i * 2), "%.2x", (u_char)p[i]);
	strlcat(Buf, "\n", sizeof(Buf));
	
	return (strlen(Buf));
}

