/*
  decode_rlogin.c

  Berkeley remote login/shell.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_rlogin.c,v 1.2 2000/06/14 16:16:00 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "options.h"
#include "decode.h"

int
decode_rlogin(u_char *buf, int len)
{
	char *p, *q;
	
	p = buf + 1;				/* Skip first NULL */
	
	strlcpy(Buf, "[", sizeof(Buf));
	strlcat(Buf, p, sizeof(Buf));		/* Local username */
	strlcat(Buf, ":", sizeof(Buf));
	p += strlen(p) + 1;
	
	strlcat(Buf, p, sizeof(Buf));		/* Remote username */
	strlcat(Buf, "]\n", sizeof(Buf));
	p += strlen(p) + 1;
	
	p += strlen(p) + 1;			/* Skip term info */
	
	if ((q = strstr(p, "\xff\xffss")) != NULL)	/* Skip window size */
		p += 12;
	
	for (p = strtok(p, "\r\n"); p != NULL; p = strtok(NULL, "\r\n")) {
		strlcat(Buf, p, sizeof(Buf));
		strlcat(Buf, "\n", sizeof(Buf));
	}
	if (!strip_lines(Buf, Opt_lines))
		return (0);
	
	return (strlen(Buf));
}

