/*
  decode_ospf.c

  Open Shortest Path First.
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_ospf.c,v 1.3 2000/06/14 16:16:00 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_ospf(u_char *buf, int len)
{
	if (len < 25)
		return (0);
	
	if (ntohs(*(u_short *)&buf[14]) != 1)
		return (0);
	
	buf[24] = '\0';
	
	return (snprintf(Buf, sizeof(Buf), "%s\n", buf + 16));
}

