/*
  decode_napster.c

  Napster. w00w00!
  
  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_napster.c,v 1.3 2000/06/14 16:16:00 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

int
decode_napster(u_char *buf, int len)
{
	u_short i, type;
	
	if (len < 4) return (0);
	
	i = pletohs(buf);
	type = pletohs(&buf[2]);
	
	if (type != 2) return (0);
	if (i > len - 4) return (0);
	
	buf[4 + i] = '\0';
	
	strlcpy(Buf, buf + 4, sizeof(Buf));
	strlcat(Buf, "\n", sizeof(Buf));
	
	i = strlen(Buf);
	
	if (!is_ascii_string(Buf, i))
		return (0);
	
	return (i);
}

