/*
  decode_icq.c

  ICQ.
  
  See http://www.algonet.se/~henisak/icq/ for details...

  Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 
  $Id: decode_icq.c,v 1.3 2000/06/14 06:43:32 dugsong Exp $
*/

#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "decode.h"

#define ICQ2_UIN_OFFSET		6
#define ICQ2_CMD_OFFSET		2
#define ICQ2_PASS_OFFSET	16

#define ICQ5_UIN_OFFSET		6
#define ICQ5_CMD_OFFSET		14
#define ICQ5_CKSUM_OFFSET	20
#define ICQ5_PASS_OFFSET	34

const u_char icq5_table [] = {
	0x59, 0x60, 0x37, 0x6B, 0x65, 0x62, 0x46, 0x48, 0x53, 0x61, 0x4C,
	0x59, 0x60, 0x57, 0x5B, 0x3D, 0x5E, 0x34, 0x6D, 0x36, 0x50, 0x3F,
	0x6F, 0x67, 0x53, 0x61, 0x4C, 0x59, 0x40, 0x47, 0x63, 0x39, 0x50,
	0x5F, 0x5F, 0x3F, 0x6F, 0x47, 0x43, 0x69, 0x48, 0x33, 0x31, 0x64,
	0x35, 0x5A, 0x4A, 0x42, 0x56, 0x40, 0x67, 0x53, 0x41, 0x07, 0x6C,
	0x49, 0x58, 0x3B, 0x4D, 0x46, 0x68, 0x43, 0x69, 0x48, 0x33, 0x31,
	0x44, 0x65, 0x62, 0x46, 0x48, 0x53, 0x41, 0x07, 0x6C, 0x69, 0x48,
	0x33, 0x51, 0x54, 0x5D, 0x4E, 0x6C, 0x49, 0x38, 0x4B, 0x55, 0x4A,
	0x62, 0x46, 0x48, 0x33, 0x51, 0x34, 0x6D, 0x36, 0x50, 0x5F, 0x5F,
	0x5F, 0x3F, 0x6F, 0x47, 0x63, 0x59, 0x40, 0x67, 0x33, 0x31, 0x64,
	0x35, 0x5A, 0x6A, 0x52, 0x6E, 0x3C, 0x51, 0x34, 0x6D, 0x36, 0x50,
	0x5F, 0x5F, 0x3F, 0x4F, 0x37, 0x4B, 0x35, 0x5A, 0x4A, 0x62, 0x66,
	0x58, 0x3B, 0x4D, 0x66, 0x58, 0x5B, 0x5D, 0x4E, 0x6C, 0x49, 0x58,
	0x3B, 0x4D, 0x66, 0x58, 0x3B, 0x4D, 0x46, 0x48, 0x53, 0x61, 0x4C,
	0x59, 0x40, 0x67, 0x33, 0x31, 0x64, 0x55, 0x6A, 0x32, 0x3E, 0x44,
	0x45, 0x52, 0x6E, 0x3C, 0x31, 0x64, 0x55, 0x6A, 0x52, 0x4E, 0x6C,
	0x69, 0x48, 0x53, 0x61, 0x4C, 0x39, 0x30, 0x6F, 0x47, 0x63, 0x59,
	0x60, 0x57, 0x5B, 0x3D, 0x3E, 0x64, 0x35, 0x3A, 0x3A, 0x5A, 0x6A,
	0x52, 0x4E, 0x6C, 0x69, 0x48, 0x53, 0x61, 0x6C, 0x49, 0x58, 0x3B,
	0x4D, 0x46, 0x68, 0x63, 0x39, 0x50, 0x5F, 0x5F, 0x3F, 0x6F, 0x67,
	0x53, 0x41, 0x25, 0x41, 0x3C, 0x51, 0x54, 0x3D, 0x5E, 0x54, 0x5D,
	0x4E, 0x4C, 0x39, 0x50, 0x5F, 0x5F, 0x5F, 0x3F, 0x6F, 0x47, 0x43,
	0x69, 0x48, 0x33, 0x51, 0x54, 0x5D, 0x6E, 0x3C, 0x31, 0x64, 0x35,
	0x5A, 0x00, 0x00
};

int
decode_icq(u_char *buf, int len)
{
	u_int uin;
	char *p;
	
	if (len < 2)
		return (0);
	
	switch (pletohs(buf)) {
	case 2:
		if (len < ICQ2_PASS_OFFSET + 1)
			return (0);
		
		if (pletohs(&buf[ICQ2_CMD_OFFSET]) != 1000)
			return (0);
		
		uin = pletohs(&buf[ICQ2_UIN_OFFSET]);
		p = buf + ICQ2_PASS_OFFSET;
		break;
		
	case 5:
	{
		u_int32_t a1, a2, a3, a4, a5, c, key, i, k;
		
		if (len < ICQ5_PASS_OFFSET + 1)
			return (0);
		
		c = pletohl(&buf[ICQ5_CKSUM_OFFSET]);
		
		a1 = c & 0x0001f000; a1 = a1 >> 0x0c;
		a2 = c & 0x07c007c0; a2 = a2 >> 0x01;
		a3 = c & 0x003e0001; a3 = a3 << 0x0a;
		a4 = c & 0xf8000000; a4 = a4 >> 0x10;
		a5 = c & 0x0000083e; a5 = a5 << 0x0f;
		
		key = len * 0x68656C6C;
		key += a1 + a2 + a3 + a4 + a5;
		
		for (i = 0x0a; i < len + 3; i += 4) {
			k = key + icq5_table[i & 0xff];
			if (i != 0x16) {
				buf[i] ^= (u_char)(k & 0xff);
				buf[i + 1] ^= (u_char)((k & 0xff00) >> 8);
			}
			if (i != 0x12) {
				buf[i + 2] ^= (u_char)((k & 0xff0000) >> 16);
				buf[i + 3] ^= (u_char)((k & 0xff000000) >> 24);
			}
		}
		if (pletohs(&buf[ICQ5_CMD_OFFSET]) != 1000)
			return (0);
		
		uin = pletohl(&buf[ICQ5_UIN_OFFSET]);
		p = buf + ICQ5_PASS_OFFSET;
	}
	break;
	
	default:
		return (0);
	}
	snprintf(Buf, sizeof(Buf), "%d %s\n", uin, p);
	
	len = strlen(Buf);
	
	if (!is_ascii_string(Buf, len))
		return (0);
	
	return (len);
}

